/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.util.Iterator;
import org.opengis.feature.Feature;
import org.opengis.filter.Filter;

public class FilteringIterator<F extends Feature>
implements Iterator<F> {
    Iterator<F> delegate;
    Filter filter;
    F next;

    public FilteringIterator(Iterator<F> iterator, Filter filter) {
        this.delegate = iterator;
        this.filter = filter;
    }

    public Iterator<F> getDelegate() {
        return this.delegate;
    }

    @Override
    public void remove() {
        this.delegate.remove();
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        while (this.delegate.hasNext()) {
            Feature feature = (Feature)this.delegate.next();
            if (!this.filter.evaluate(feature)) continue;
            this.next = feature;
            break;
        }
        return this.next != null;
    }

    @Override
    public F next() {
        F f = this.next;
        this.next = null;
        return f;
    }
}

