/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.converter;

import java.io.Serializable;
import javax.measure.converter.ConversionException;

public abstract class UnitConverter
implements Serializable {
    public static final UnitConverter IDENTITY = new Identity();

    protected UnitConverter() {
    }

    public abstract UnitConverter inverse();

    public abstract double convert(double var1) throws ConversionException;

    public abstract boolean isLinear();

    public boolean equals(Object object) {
        if (!(object instanceof UnitConverter)) {
            return false;
        }
        return this.concatenate(((UnitConverter)object).inverse()) == IDENTITY;
    }

    public int hashCode() {
        return Float.floatToIntBits((float)this.convert(1.0));
    }

    public UnitConverter concatenate(UnitConverter unitConverter) {
        return unitConverter == IDENTITY ? this : new Compound(unitConverter, this);
    }

    private static final class Compound
    extends UnitConverter {
        private final UnitConverter _first;
        private final UnitConverter _second;
        private static final long serialVersionUID = 1L;

        private Compound(UnitConverter unitConverter, UnitConverter unitConverter2) {
            this._first = unitConverter;
            this._second = unitConverter2;
        }

        @Override
        public UnitConverter inverse() {
            return new Compound(this._second.inverse(), this._first.inverse());
        }

        @Override
        public double convert(double d) {
            return this._second.convert(this._first.convert(d));
        }

        @Override
        public boolean isLinear() {
            return this._first.isLinear() && this._second.isLinear();
        }
    }

    private static final class Identity
    extends UnitConverter {
        private static final long serialVersionUID = 1L;

        private Identity() {
        }

        @Override
        public UnitConverter inverse() {
            return this;
        }

        @Override
        public double convert(double d) {
            return d;
        }

        @Override
        public boolean isLinear() {
            return true;
        }

        @Override
        public UnitConverter concatenate(UnitConverter unitConverter) {
            return unitConverter;
        }
    }
}

