/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata;

import java.awt.Toolkit;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.MenuScroller;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.opendata.core.OdConstants;
import org.openstreetmap.josm.plugins.opendata.core.actions.DownloadDataAction;
import org.openstreetmap.josm.plugins.opendata.core.actions.DownloadDataTask;
import org.openstreetmap.josm.plugins.opendata.core.actions.OpenPreferencesActions;
import org.openstreetmap.josm.plugins.opendata.core.datasets.AbstractDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.core.datasets.DataSetCategory;
import org.openstreetmap.josm.plugins.opendata.core.gui.OdDialog;
import org.openstreetmap.josm.plugins.opendata.core.gui.OdPreferenceSetting;
import org.openstreetmap.josm.plugins.opendata.core.io.AbstractImporter;
import org.openstreetmap.josm.plugins.opendata.core.io.XmlImporter;
import org.openstreetmap.josm.plugins.opendata.core.io.archive.ZipImporter;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.GmlImporter;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.KmlKmzImporter;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.MifTabImporter;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.ShpImporter;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.CsvImporter;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.OdsImporter;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.XlsImporter;
import org.openstreetmap.josm.plugins.opendata.core.modules.Module;
import org.openstreetmap.josm.plugins.opendata.core.modules.ModuleHandler;
import org.openstreetmap.josm.plugins.opendata.core.modules.ModuleInformation;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Pair;

public final class OdPlugin
extends Plugin
implements OdConstants {
    private static OdPlugin instance;
    public final XmlImporter xmlImporter = new XmlImporter();
    private final JMenu menu;

    public OdPlugin(PluginInformation info) {
        super(info);
        if (instance != null) {
            throw new IllegalAccessError("Cannot instantiate plugin twice !");
        }
        instance = this;
        for (AbstractImporter importer : Arrays.asList(new CsvImporter(), new OdsImporter(), new XlsImporter(), new KmlKmzImporter(), new ShpImporter(), new MifTabImporter(), new GmlImporter(), new ZipImporter(), this.xmlImporter)) {
            ExtensionFileFilter.importers.add(0, importer);
        }
        this.loadModules();
        MainMenu mainMenu = Main.main.menu;
        String string = I18n.marktr((String)"Open Data");
        Main.main.menu.getClass();
        this.menu = mainMenu.addMenu(string, 79, 7, HelpUtil.ht((String)"/Plugin/OpenData"));
        this.buildMenu();
        Main.main.menu.openLocation.addDownloadTaskClass(DownloadDataTask.class);
    }

    public static final OdPlugin getInstance() {
        return instance;
    }

    private JMenu getModuleMenu(Module module) {
        String moduleName = module.getDisplayedName();
        if (moduleName == null || moduleName.isEmpty()) {
            moduleName = module.getModuleInformation().getName();
        }
        JMenu moduleMenu = new JMenu(moduleName);
        moduleMenu.setIcon(module.getModuleInformation().getScaledIcon());
        return moduleMenu;
    }

    private void buildMenu() {
        int screenHeight = Toolkit.getDefaultToolkit().getScreenSize().height;
        for (Module module : ModuleHandler.moduleList) {
            HashMap<DataSetCategory, JMenu> catMenus = new HashMap<DataSetCategory, JMenu>();
            JMenu moduleMenu = null;
            for (AbstractDataSetHandler handler : module.getNewlyInstanciatedHandlers()) {
                String handlerName;
                if (handler.getDataURL() == null && (handler.getDataURLs() == null || handler.getDataURLs().isEmpty())) continue;
                if (moduleMenu == null) {
                    moduleMenu = this.getModuleMenu(module);
                }
                DataSetCategory cat = handler.getCategory();
                JMenu endMenu = null;
                if (cat != null && (endMenu = (JMenu)catMenus.get(cat)) == null) {
                    endMenu = new JMenu(cat.getName());
                    catMenus.put(cat, endMenu);
                    moduleMenu.add(endMenu);
                }
                if (endMenu == null) {
                    endMenu = moduleMenu;
                }
                if ((handlerName = handler.getName()) == null || handlerName.isEmpty()) {
                    handlerName = handler.getClass().getName();
                }
                if (handler.getDataURL() != null) {
                    endMenu.add((Action)((Object)new DownloadDataAction(handlerName, handler.getDataURL())));
                    continue;
                }
                if (handler.getDataURLs() == null) continue;
                JMenu handlerMenu = new JMenu(handlerName);
                JComponent item = null;
                for (Pair<String, URL> pair : handler.getDataURLs()) {
                    if (pair == null || pair.a == null || pair.b == null) continue;
                    item = handlerMenu.add((Action)((Object)new DownloadDataAction((String)pair.a, (URL)pair.b)));
                }
                if (item == null) continue;
                MenuScroller.setScrollerFor((JMenu)handlerMenu, (int)(screenHeight / item.getPreferredSize().height - 3));
                endMenu.add(handlerMenu);
            }
            if (moduleMenu == null) continue;
            this.menu.add(moduleMenu);
        }
        this.menu.addSeparator();
        MainMenu.add((JMenu)this.menu, (JosmAction)new OpenPreferencesActions());
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (newFrame != null) {
            newFrame.addToggleDialog((ToggleDialog)new OdDialog());
        }
    }

    public PreferenceSetting getPreferenceSetting() {
        return new OdPreferenceSetting();
    }

    private final void loadModules() {
        List<ModuleInformation> modulesToLoad = ModuleHandler.buildListOfModulesToLoad(Main.parent);
        if (!modulesToLoad.isEmpty() && ModuleHandler.checkAndConfirmModuleUpdate(Main.parent)) {
            modulesToLoad = ModuleHandler.updateModules(Main.parent, modulesToLoad, null);
        }
        ModuleHandler.installDownloadedModules(true);
        ModuleHandler.loadModules(Main.parent, modulesToLoad, null);
    }

    private final File getSubDirectory(String name) {
        File dir = new File(this.getPluginDir() + File.separator + name);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public final File getModulesDirectory() {
        return this.getSubDirectory("modules");
    }

    public final File getResourcesDirectory() {
        return this.getSubDirectory("resources");
    }
}

