/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import javax.measure.unit.SI;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.FloatParameter;
import org.geotools.parameter.Parameter;
import org.geotools.parameter.ParameterGroup;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.MathTransformProvider;
import org.geotools.referencing.operation.transform.AbstractMathTransform;
import org.geotools.referencing.operation.transform.GeocentricTranslation;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Vocabulary;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.GenericName;

public class MolodenskiTransform
extends AbstractMathTransform
implements Serializable {
    private static final long serialVersionUID = 7536566033885338422L;
    private static final float EPS = 1.0E-5f;
    private final boolean abridged;
    private final boolean source3D;
    private final boolean target3D;
    private final double dx;
    private final double dy;
    private final double dz;
    private final double a;
    private final double b;
    private final double da;
    private final double db;
    private final double df;
    private final double b_a;
    private final double a_b;
    private final double daa;
    private final double da_a;
    private final double e2;
    private final double adf;
    private transient MolodenskiTransform inverse;

    public MolodenskiTransform(boolean bl, double d, double d2, boolean bl2, double d3, double d4, boolean bl3, double d5, double d6, double d7) {
        this.abridged = bl;
        this.source3D = bl2;
        this.target3D = bl3;
        this.dx = d5;
        this.dy = d6;
        this.dz = d7;
        this.a = d;
        this.b = d2;
        this.da = d3 - d;
        this.db = d4 - d2;
        this.a_b = d / d2;
        this.b_a = d2 / d;
        this.daa = this.da * d;
        this.da_a = this.da / d;
        this.df = (d3 - d4) / d3 - (d - d2) / d;
        this.e2 = 1.0 - d2 * d2 / (d * d);
        this.adf = d * this.df + (d - d2) * this.da / d;
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return this.abridged ? ProviderAbridged.PARAMETERS : Provider.PARAMETERS;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        Parameter<Integer> parameter = new Parameter<Integer>(Provider.DIM);
        parameter.setValue(this.getSourceDimensions());
        return new ParameterGroup(this.getParameterDescriptors(), new ParameterValue[]{parameter, new FloatParameter(Provider.DX, this.dx), new FloatParameter(Provider.DY, this.dy), new FloatParameter(Provider.DZ, this.dz), new FloatParameter(Provider.SRC_SEMI_MAJOR, this.a), new FloatParameter(Provider.SRC_SEMI_MINOR, this.b), new FloatParameter(Provider.TGT_SEMI_MAJOR, this.a + this.da), new FloatParameter(Provider.TGT_SEMI_MINOR, this.b + this.db)});
    }

    @Override
    public int getSourceDimensions() {
        return this.source3D ? 3 : 2;
    }

    @Override
    public final int getTargetDimensions() {
        return this.target3D ? 3 : 2;
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        this.transform(null, dArray, n, null, dArray2, n2, n3);
        assert (!this.target3D || dArray == dArray2 || !(this.maxError(null, dArray, n, null, dArray2, n2, n3) > 1.0E-5f));
    }

    @Override
    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        this.transform(fArray, null, n, fArray2, null, n2, n3);
        assert (!this.target3D || fArray == fArray2 || !(this.maxError(fArray, null, n, fArray2, null, n2, n3) > 1.0E-5f));
    }

    private void transform(float[] fArray, double[] dArray, int n, float[] fArray2, double[] dArray2, int n2, int n3) {
        int n4 = 0;
        if ((dArray != null ? dArray == dArray2 : fArray == fArray2) && n < n2 && n + n3 * this.getSourceDimensions() > n2) {
            if (this.source3D != this.target3D) {
                throw new UnsupportedOperationException("Not yet implemented.");
            }
            n4 = this.getSourceDimensions();
            n += (n3 - 1) * n4;
            n2 += (n3 - 1) * n4;
            n4 *= -2;
        }
        while (--n3 >= 0) {
            double d;
            double d2;
            double d3;
            if (dArray != null) {
                d3 = dArray[n++];
                d2 = dArray[n++];
                d = this.source3D ? dArray[n++] : 0.0;
            } else {
                d3 = fArray[n++];
                d2 = fArray[n++];
                d = this.source3D ? (double)fArray[n++] : 0.0;
            }
            d3 = Math.toRadians(d3);
            d2 = Math.toRadians(d2);
            double d4 = Math.sin(d3);
            double d5 = Math.cos(d3);
            double d6 = Math.sin(d2);
            double d7 = Math.cos(d2);
            double d8 = d6 * d6;
            double d9 = this.a / Math.sqrt(1.0 - this.e2 * d8);
            double d10 = d9 * (1.0 - this.e2) / (1.0 - this.e2 * d8);
            if (this.abridged) {
                d2 += (this.dz * d7 - d6 * (this.dy * d4 + this.dx * d5) + this.adf * Math.sin(2.0 * d2)) / d10;
                d3 += (this.dy * d5 - this.dx * d4) / (d9 * d7);
            } else {
                d2 += (this.dz * d7 - d6 * (this.dy * d4 + this.dx * d5) + this.da_a * (d9 * this.e2 * d6 * d7) + this.df * (d10 * this.a_b + d9 * this.b_a) * d6 * d7) / (d10 + d);
                d3 += (this.dy * d5 - this.dx * d4) / ((d9 + d) * d7);
            }
            if (Math.abs(d2) > 1.5707963267948966) {
                if (dArray2 != null) {
                    dArray2[n2++] = 0.0;
                    dArray2[n2++] = d2 > 0.0 ? 90.0 : -90.0;
                } else {
                    fArray2[n2++] = 0.0f;
                    fArray2[n2++] = d2 > 0.0 ? 90.0f : -90.0f;
                }
            } else {
                d3 = Math.toDegrees(MolodenskiTransform.rollLongitude(d3));
                d2 = Math.toDegrees(d2);
                if (dArray2 != null) {
                    dArray2[n2++] = d3;
                    dArray2[n2++] = d2;
                } else {
                    fArray2[n2++] = (float)d3;
                    fArray2[n2++] = (float)d2;
                }
            }
            if (this.target3D) {
                d = this.abridged ? (d += this.dx * d7 * d5 + this.dy * d7 * d4 + this.dz * d6 + this.adf * d8 - this.da) : (d += this.dx * d7 * d5 + this.dy * d7 * d4 + this.dz * d6 + this.df * this.b_a * d9 * d8 - this.daa / d9);
                if (dArray2 != null) {
                    dArray2[n2++] = d;
                } else {
                    fArray2[n2++] = (float)d;
                }
            }
            n += n4;
            n2 += n4;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private float maxError(float[] fArray, double[] dArray, int n, float[] fArray2, double[] dArray2, int n2, int n3) {
        float f = 0.0f;
        if (this.inverse == null) {
            this.inverse();
            if (this.inverse == null) {
                return f;
            }
        }
        int n4 = this.getSourceDimensions();
        float[] fArray3 = new float[n3 * n4];
        this.inverse.transform(fArray2, dArray2, n2, fArray3, null, 0, n3);
        int n5 = 0;
        while (true) {
            block9: {
                if (n5 >= fArray3.length) {
                    return f;
                }
                float f2 = dArray != null ? (float)dArray[n] : fArray[n];
                float f3 = Math.abs(fArray3[n5] - f2);
                switch (n5 % n4) {
                    case 0: {
                        f3 = (float)((double)f3 - 360.0 * Math.floor(f3 / 360.0f));
                        break;
                    }
                    case 2: {
                        break block9;
                    }
                }
                if (f3 > f) {
                    f = f3;
                }
            }
            ++n5;
            ++n;
        }
    }

    @Override
    public boolean isIdentity() {
        return this.dx == 0.0 && this.dy == 0.0 && this.dz == 0.0 && this.da == 0.0 && this.db == 0.0 && this.source3D == this.target3D;
    }

    @Override
    public MathTransform inverse() {
        if (this.inverse == null) {
            this.inverse = new MolodenskiTransform(this.abridged, this.a + this.da, this.b + this.db, this.target3D, this.a, this.b, this.source3D, -this.dx, -this.dy, -this.dz);
            this.inverse.inverse = this;
        }
        return this.inverse;
    }

    @Override
    public final int hashCode() {
        long l = Double.doubleToLongBits(this.dx) + 37L * (Double.doubleToLongBits(this.dy) + 37L * (Double.doubleToLongBits(this.dz) + 37L * (Double.doubleToLongBits(this.a) + 37L * (Double.doubleToLongBits(this.b) + 37L * (Double.doubleToLongBits(this.da) + 37L * Double.doubleToLongBits(this.db))))));
        int n = (int)l ^ (int)(l >>> 32) ^ 0x9C029B36;
        if (this.abridged) {
            n ^= 0xFFFFFFFF;
        }
        return n;
    }

    @Override
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            MolodenskiTransform molodenskiTransform = (MolodenskiTransform)object;
            return this.abridged == molodenskiTransform.abridged && this.source3D == molodenskiTransform.source3D && this.target3D == molodenskiTransform.target3D && Double.doubleToLongBits(this.dx) == Double.doubleToLongBits(molodenskiTransform.dx) && Double.doubleToLongBits(this.dy) == Double.doubleToLongBits(molodenskiTransform.dy) && Double.doubleToLongBits(this.dz) == Double.doubleToLongBits(molodenskiTransform.dz) && Double.doubleToLongBits(this.a) == Double.doubleToLongBits(molodenskiTransform.a) && Double.doubleToLongBits(this.b) == Double.doubleToLongBits(molodenskiTransform.b) && Double.doubleToLongBits(this.da) == Double.doubleToLongBits(molodenskiTransform.da) && Double.doubleToLongBits(this.db) == Double.doubleToLongBits(molodenskiTransform.db);
        }
        return false;
    }

    public static class ProviderAbridged
    extends Provider {
        private static final long serialVersionUID = 9148242601566635131L;
        static final ParameterDescriptorGroup PARAMETERS = ProviderAbridged.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "Abridged_Molodenski"), new NamedIdentifier(Citations.EPSG, "Abridged Molodenski"), new NamedIdentifier(Citations.EPSG, "9605"), new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.format(1))}, new ParameterDescriptor[]{DIM, DX, DY, DZ, SRC_SEMI_MAJOR, SRC_SEMI_MINOR, TGT_SEMI_MAJOR, TGT_SEMI_MINOR});

        public ProviderAbridged() {
            super(2, 2, PARAMETERS);
        }

        private ProviderAbridged(int n, int n2, ParameterDescriptorGroup parameterDescriptorGroup) {
            super(n, n2, parameterDescriptorGroup);
        }

        @Override
        Provider create3D() {
            return new ProviderAbridged(3, 3, PARAMETERS);
        }

        @Override
        boolean isAbridged() {
            return true;
        }
    }

    public static class Provider
    extends MathTransformProvider {
        private static final long serialVersionUID = -5332126871499059030L;
        static final int DEFAULT_DIMENSION = 2;
        public static final ParameterDescriptor<Integer> DIM = DefaultParameterDescriptor.create(Collections.singletonMap("name", new NamedIdentifier(Citations.OGC, "dim")), 2, 2, 3, false);
        public static final ParameterDescriptor<Double> DX = GeocentricTranslation.Provider.DX;
        public static final ParameterDescriptor<Double> DY = GeocentricTranslation.Provider.DY;
        public static final ParameterDescriptor<Double> DZ = GeocentricTranslation.Provider.DZ;
        public static final ParameterDescriptor<Double> SRC_SEMI_MAJOR = Provider.createDescriptor(Provider.identifiers(GeocentricTranslation.Provider.SRC_SEMI_MAJOR), Double.NaN, 0.0, Double.POSITIVE_INFINITY, SI.METER);
        public static final ParameterDescriptor<Double> SRC_SEMI_MINOR = Provider.createDescriptor(Provider.identifiers(GeocentricTranslation.Provider.SRC_SEMI_MINOR), Double.NaN, 0.0, Double.POSITIVE_INFINITY, SI.METER);
        public static final ParameterDescriptor<Double> TGT_SEMI_MAJOR = Provider.createDescriptor(Provider.identifiers(GeocentricTranslation.Provider.TGT_SEMI_MAJOR), Double.NaN, 0.0, Double.POSITIVE_INFINITY, SI.METER);
        public static final ParameterDescriptor<Double> TGT_SEMI_MINOR = Provider.createDescriptor(Provider.identifiers(GeocentricTranslation.Provider.TGT_SEMI_MINOR), Double.NaN, 0.0, Double.POSITIVE_INFINITY, SI.METER);
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "Molodenski"), new NamedIdentifier(Citations.EPSG, "Molodenski"), new NamedIdentifier(Citations.EPSG, "9604"), new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational(143))}, new ParameterDescriptor[]{DIM, DX, DY, DZ, SRC_SEMI_MAJOR, SRC_SEMI_MINOR, TGT_SEMI_MAJOR, TGT_SEMI_MINOR});
        private transient Provider withHeight;

        private static final NamedIdentifier[] identifiers(ParameterDescriptor parameterDescriptor) {
            Collection<GenericName> collection = parameterDescriptor.getAlias();
            return collection.toArray(new NamedIdentifier[collection.size()]);
        }

        public Provider() {
            super(2, 2, PARAMETERS);
        }

        Provider(int n, int n2, ParameterDescriptorGroup parameterDescriptorGroup) {
            super(n, n2, parameterDescriptorGroup);
        }

        public Class<Transformation> getOperationType() {
            return Transformation.class;
        }

        @Override
        protected MathTransform createMathTransform(ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
            boolean bl;
            int n = Provider.intValue(DIM, parameterValueGroup);
            switch (n) {
                case 0: 
                case 2: {
                    bl = false;
                    break;
                }
                case 3: {
                    bl = true;
                    if (this.withHeight != null) break;
                    this.withHeight = this.create3D();
                    break;
                }
                default: {
                    throw new IllegalArgumentException(Errors.format(58, "dim", n));
                }
            }
            double d = Provider.doubleValue(SRC_SEMI_MAJOR, parameterValueGroup);
            double d2 = Provider.doubleValue(SRC_SEMI_MINOR, parameterValueGroup);
            double d3 = Provider.doubleValue(TGT_SEMI_MAJOR, parameterValueGroup);
            double d4 = Provider.doubleValue(TGT_SEMI_MINOR, parameterValueGroup);
            double d5 = Provider.doubleValue(DX, parameterValueGroup);
            double d6 = Provider.doubleValue(DY, parameterValueGroup);
            double d7 = Provider.doubleValue(DZ, parameterValueGroup);
            boolean bl2 = this.isAbridged();
            if (!bl) {
                return new As2D(bl2, d, d2, d3, d4, d5, d6, d7);
            }
            return new MathTransformProvider.Delegate(new MolodenskiTransform(bl2, d, d2, bl, d3, d4, bl, d5, d6, d7), this.withHeight);
        }

        Provider create3D() {
            return new Provider(3, 3, PARAMETERS);
        }

        boolean isAbridged() {
            return false;
        }
    }

    private static final class As2D
    extends MolodenskiTransform
    implements MathTransform2D {
        private static final long serialVersionUID = 8098439371246167474L;

        public As2D(boolean bl, double d, double d2, double d3, double d4, double d5, double d6, double d7) {
            super(bl, d, d2, false, d3, d4, false, d5, d6, d7);
        }

        @Override
        public MathTransform2D inverse() {
            if (((MolodenskiTransform)this).inverse == null) {
                ((MolodenskiTransform)this).inverse = (MolodenskiTransform)new As2D(((MolodenskiTransform)this).abridged, ((MolodenskiTransform)this).a + ((MolodenskiTransform)this).da, ((MolodenskiTransform)this).b + ((MolodenskiTransform)this).db, ((MolodenskiTransform)this).a, ((MolodenskiTransform)this).b, -((MolodenskiTransform)this).dx, -((MolodenskiTransform)this).dy, -((MolodenskiTransform)this).dz);
                ((MolodenskiTransform)this).inverse.inverse = (MolodenskiTransform)this;
            }
            return (MathTransform2D)((Object)((MolodenskiTransform)this).inverse);
        }
    }
}

