/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collections;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Length;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.FloatParameter;
import org.geotools.parameter.Parameter;
import org.geotools.parameter.ParameterGroup;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.referencing.operation.MathTransformProvider;
import org.geotools.referencing.operation.transform.AbstractMathTransform;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Vocabulary;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;

public class GeocentricTransform
extends AbstractMathTransform
implements Serializable {
    private static final long serialVersionUID = -3352045463953828140L;
    private static final double MAX_ERROR = 0.01;
    private static final double COS_67P5 = 0.3826834323650898;
    private static final double AD_C = 1.0026;
    private final double a;
    private final double b;
    private final double a2;
    private final double b2;
    private final double e2;
    private final double ep2;
    private final boolean hasHeight;
    private transient MathTransform inverse;

    public GeocentricTransform(double d, double d2, Unit<Length> unit, boolean bl) {
        this.hasHeight = bl;
        UnitConverter unitConverter = unit.getConverterTo(SI.METER);
        this.a = unitConverter.convert(d);
        this.b = unitConverter.convert(d2);
        this.a2 = this.a * this.a;
        this.b2 = this.b * this.b;
        this.e2 = (this.a2 - this.b2) / this.a2;
        this.ep2 = (this.a2 - this.b2) / this.b2;
        GeocentricTransform.checkArgument("a", this.a, Double.MAX_VALUE);
        GeocentricTransform.checkArgument("b", this.b, this.a);
    }

    private static void checkArgument(String string, double d, double d2) throws IllegalArgumentException {
        if (!(d >= 0.0) || !(d <= d2)) {
            throw new IllegalArgumentException(Errors.format(58, string, d));
        }
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Provider.PARAMETERS;
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        return this.getParameterValues(this.getParameterDescriptors());
    }

    private ParameterValueGroup getParameterValues(ParameterDescriptorGroup parameterDescriptorGroup) {
        GeneralParameterValue[] generalParameterValueArray = new ParameterValue[this.hasHeight ? 2 : 3];
        int n = 0;
        if (!this.hasHeight) {
            Parameter<Integer> parameter = new Parameter<Integer>(Provider.DIM);
            parameter.setValue(2);
            generalParameterValueArray[n++] = parameter;
        }
        generalParameterValueArray[n++] = new FloatParameter(Provider.SEMI_MAJOR, this.a);
        generalParameterValueArray[n++] = new FloatParameter(Provider.SEMI_MINOR, this.b);
        return new ParameterGroup(parameterDescriptorGroup, generalParameterValueArray);
    }

    @Override
    public int getSourceDimensions() {
        return this.hasHeight ? 3 : 2;
    }

    @Override
    public final int getTargetDimensions() {
        return 3;
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        this.transform(dArray, n, dArray2, n2, n3, false);
    }

    private void transform(double[] dArray, int n, double[] dArray2, int n2, int n3, boolean bl) {
        int n4 = this.getSourceDimensions();
        bl |= n4 >= 3;
        if (dArray == dArray2 && GeocentricTransform.needCopy(n, n4, n2, 3, n3)) {
            double[] dArray3 = dArray;
            dArray = new double[n3 * (bl ? 3 : 2)];
            System.arraycopy(dArray3, n, dArray, 0, dArray.length);
            n = 0;
        }
        while (--n3 >= 0) {
            double d = Math.toRadians(dArray[n++]);
            double d2 = Math.toRadians(dArray[n++]);
            double d3 = bl ? dArray[n++] : 0.0;
            double d4 = Math.cos(d2);
            double d5 = Math.sin(d2);
            double d6 = this.a / Math.sqrt(1.0 - this.e2 * (d5 * d5));
            dArray2[n2++] = (d6 + d3) * d4 * Math.cos(d);
            dArray2[n2++] = (d6 + d3) * d4 * Math.sin(d);
            dArray2[n2++] = (d6 * (1.0 - this.e2) + d3) * d5;
        }
    }

    @Override
    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        boolean bl;
        int n4 = this.getSourceDimensions();
        boolean bl2 = bl = n4 >= 3;
        if (fArray == fArray2 && GeocentricTransform.needCopy(n, n4, n2, 3, n3)) {
            float[] fArray3 = fArray;
            fArray = new float[n3 * n4];
            System.arraycopy(fArray3, n, fArray, 0, fArray.length);
            n = 0;
        }
        while (--n3 >= 0) {
            double d = Math.toRadians(fArray[n++]);
            double d2 = Math.toRadians(fArray[n++]);
            double d3 = bl ? (double)fArray[n++] : 0.0;
            double d4 = Math.cos(d2);
            double d5 = Math.sin(d2);
            double d6 = this.a / Math.sqrt(1.0 - this.e2 * (d5 * d5));
            fArray2[n2++] = (float)((d6 + d3) * d4 * Math.cos(d));
            fArray2[n2++] = (float)((d6 + d3) * d4 * Math.sin(d));
            fArray2[n2++] = (float)((d6 * (1.0 - this.e2) + d3) * d5);
        }
    }

    public void inverseTransform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        int n4 = this.getSourceDimensions();
        if (dArray == dArray2 && GeocentricTransform.needCopy(n, 3, n2, n4, n3)) {
            double[] dArray3 = dArray;
            dArray = new double[n3 * 3];
            System.arraycopy(dArray3, n, dArray, 0, dArray.length);
            n = 0;
        }
        this.inverseTransform(null, dArray, n, null, dArray2, n2, n3, n4);
    }

    public void inverseTransform(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        int n4 = this.getSourceDimensions();
        if (fArray == fArray2 && GeocentricTransform.needCopy(n, 3, n2, n4, n3)) {
            float[] fArray3 = fArray;
            fArray = new float[n3 * 3];
            System.arraycopy(fArray3, n, fArray, 0, fArray.length);
            n = 0;
        }
        this.inverseTransform(fArray, null, n, fArray2, null, n2, n3, n4);
    }

    private void inverseTransform(float[] fArray, double[] dArray, int n, float[] fArray2, double[] dArray2, int n2, int n3, int n4) {
        boolean bl;
        boolean bl2 = bl = n4 >= 3;
        if (!$assertionsDisabled) {
            bl2 = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        while (--n3 >= 0) {
            double d;
            double d2;
            double d3;
            double d4;
            if (dArray != null) {
                d4 = dArray[n++];
                d3 = dArray[n++];
                d2 = dArray[n++];
            } else {
                d4 = fArray[n++];
                d3 = fArray[n++];
                d2 = fArray[n++];
            }
            double d5 = d4 * d4 + d3 * d3;
            double d6 = Math.sqrt(d5);
            double d7 = d2 * 1.0026;
            double d8 = Math.sqrt(d7 * d7 + d5);
            double d9 = d7 / d8;
            double d10 = d6 / d8;
            double d11 = d9 * d9 * d9;
            double d12 = d2 + this.b * this.ep2 * d11;
            double d13 = d6 - this.a * this.e2 * (d10 * d10 * d10);
            double d14 = Math.sqrt(d12 * d12 + d13 * d13);
            double d15 = d12 / d14;
            double d16 = d13 / d14;
            double d17 = Math.toDegrees(Math.atan2(d3, d4));
            double d18 = Math.toDegrees(Math.atan(d15 / d16));
            if (dArray2 != null) {
                dArray2[n2++] = d17;
                dArray2[n2++] = d18;
            } else {
                fArray2[n2++] = (float)d17;
                fArray2[n2++] = (float)d18;
            }
            if (!bl2) continue;
            double d19 = this.a / Math.sqrt(1.0 - this.e2 * (d15 * d15));
            double d20 = d16 >= 0.3826834323650898 ? d6 / d16 - d19 : (d16 <= -0.3826834323650898 ? d6 / -d16 - d19 : d2 / d15 + d19 * (this.e2 - 1.0));
            if (bl) {
                if (dArray2 != null) {
                    dArray2[n2++] = d20;
                } else {
                    fArray2[n2++] = (float)d20;
                }
            }
            assert (0.01 > (d = this.checkTransform(new double[]{d4, d3, d2, d17, d18, d20}))) : d;
        }
    }

    private double checkTransform(double[] dArray) {
        this.transform(dArray, 3, dArray, 3, 1, true);
        double d = dArray[0] - dArray[3];
        double d2 = dArray[1] - dArray[4];
        double d3 = dArray[2] - dArray[5];
        return Math.sqrt(d * d + d2 * d2 + d3 * d3);
    }

    @Override
    public synchronized MathTransform inverse() {
        if (this.inverse == null) {
            this.inverse = new Inverse();
        }
        return this.inverse;
    }

    @Override
    public int hashCode() {
        long l = Double.doubleToLongBits(this.a) + 37L * (Double.doubleToLongBits(this.b) + 37L * (Double.doubleToLongBits(this.a2) + 37L * (Double.doubleToLongBits(this.b2) + 37L * (Double.doubleToLongBits(this.e2) + 37L * Double.doubleToLongBits(this.ep2)))));
        return (int)l ^ (int)(l >>> 32) ^ 0x121296D4;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            GeocentricTransform geocentricTransform = (GeocentricTransform)object;
            return Double.doubleToLongBits(this.a) == Double.doubleToLongBits(geocentricTransform.a) && Double.doubleToLongBits(this.b) == Double.doubleToLongBits(geocentricTransform.b) && Double.doubleToLongBits(this.a2) == Double.doubleToLongBits(geocentricTransform.a2) && Double.doubleToLongBits(this.b2) == Double.doubleToLongBits(geocentricTransform.b2) && Double.doubleToLongBits(this.e2) == Double.doubleToLongBits(geocentricTransform.e2) && Double.doubleToLongBits(this.ep2) == Double.doubleToLongBits(geocentricTransform.ep2) && this.hasHeight == geocentricTransform.hasHeight;
        }
        return false;
    }

    public static class ProviderInverse
    extends Provider {
        private static final long serialVersionUID = -7356791540110076789L;
        static final ParameterDescriptorGroup PARAMETERS = ProviderInverse.createDescriptorGroup("Geocentric_To_Ellipsoid", "Geographic/geocentric conversions", "9602", 79);

        public ProviderInverse() {
            super(3, 3, PARAMETERS);
        }

        ProviderInverse(int n, int n2, ParameterDescriptorGroup parameterDescriptorGroup) {
            super(n, n2, parameterDescriptorGroup);
        }

        @Override
        public MathTransform createMathTransform(ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
            int n = ProviderInverse.intValue(DIM, parameterValueGroup);
            double d = ProviderInverse.doubleValue(SEMI_MAJOR, parameterValueGroup);
            double d2 = ProviderInverse.doubleValue(SEMI_MINOR, parameterValueGroup);
            boolean bl = n != 2;
            MathTransform mathTransform = new GeocentricTransform(d, d2, SI.METER, bl).inverse();
            if (!bl) {
                if (this.noHeight == null) {
                    this.noHeight = new ProviderInverse(3, 2, PARAMETERS);
                }
                mathTransform = new MathTransformProvider.Delegate(mathTransform, this.noHeight);
            }
            return mathTransform;
        }
    }

    public static class Provider
    extends MathTransformProvider {
        private static final long serialVersionUID = 7043216580786030251L;
        public static final ParameterDescriptor<Double> SEMI_MAJOR = Provider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "semi_major"), new NamedIdentifier(Citations.EPSG, "semi-major axis")}, Double.NaN, 0.0, Double.POSITIVE_INFINITY, SI.METER);
        public static final ParameterDescriptor<Double> SEMI_MINOR = Provider.createDescriptor(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, "semi_minor"), new NamedIdentifier(Citations.EPSG, "semi-minor axis")}, Double.NaN, 0.0, Double.POSITIVE_INFINITY, SI.METER);
        static final ParameterDescriptor<Integer> DIM = DefaultParameterDescriptor.create(Collections.singletonMap("name", new NamedIdentifier(Citations.GEOTOOLS, "dim")), 3, 2, 3, false);
        static final ParameterDescriptorGroup PARAMETERS = Provider.createDescriptorGroup("Ellipsoid_To_Geocentric", "Geographic/geocentric conversions", "9602", 79);
        transient Provider noHeight;

        static ParameterDescriptorGroup createDescriptorGroup(String string, String string2, String string3, int n) {
            return Provider.createDescriptorGroup(new NamedIdentifier[]{new NamedIdentifier(Citations.OGC, string), new NamedIdentifier(Citations.EPSG, string2), new NamedIdentifier(Citations.EPSG, string3), new NamedIdentifier(Citations.GEOTOOLS, Vocabulary.formatInternational(n))}, new ParameterDescriptor[]{SEMI_MAJOR, SEMI_MINOR, DIM});
        }

        public Provider() {
            super(3, 3, PARAMETERS);
        }

        Provider(int n, int n2, ParameterDescriptorGroup parameterDescriptorGroup) {
            super(n, n2, parameterDescriptorGroup);
        }

        public Class<Conversion> getOperationType() {
            return Conversion.class;
        }

        @Override
        protected MathTransform createMathTransform(ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
            int n = Provider.intValue(DIM, parameterValueGroup);
            double d = Provider.doubleValue(SEMI_MAJOR, parameterValueGroup);
            double d2 = Provider.doubleValue(SEMI_MINOR, parameterValueGroup);
            boolean bl = n != 2;
            Serializable serializable = new GeocentricTransform(d, d2, SI.METER, bl);
            if (!bl) {
                if (this.noHeight == null) {
                    this.noHeight = new Provider(2, 3, PARAMETERS);
                }
                serializable = new MathTransformProvider.Delegate((MathTransform)((Object)serializable), this.noHeight);
            }
            return serializable;
        }
    }

    private final class Inverse
    extends AbstractMathTransform.Inverse {
        private static final long serialVersionUID = 6942084702259211803L;

        @Override
        public ParameterDescriptorGroup getParameterDescriptors() {
            return ProviderInverse.PARAMETERS;
        }

        @Override
        public ParameterValueGroup getParameterValues() {
            return GeocentricTransform.this.getParameterValues(this.getParameterDescriptors());
        }

        @Override
        public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
            GeocentricTransform.this.inverseTransform(dArray, n, dArray2, n2, n3);
        }

        @Override
        public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) {
            GeocentricTransform.this.inverseTransform(fArray, n, fArray2, n2, n3);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            GeocentricTransform.this.inverse = this;
        }
    }
}

