/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.matrix.Matrix2;
import org.geotools.referencing.operation.matrix.Matrix3;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.resources.Formattable;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Utilities;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.util.Cloneable;

public class AffineTransform2D
extends XAffineTransform
implements MathTransform2D,
LinearTransform,
Formattable,
Cloneable {
    private static final long serialVersionUID = -5299837898367149069L;
    private transient AffineTransform2D inverse;

    public AffineTransform2D(AffineTransform affineTransform) {
        super(affineTransform);
    }

    @Override
    protected final void checkPermission() throws UnsupportedOperationException {
        super.checkPermission();
    }

    @Override
    public final int getSourceDimensions() {
        return 2;
    }

    @Override
    public final int getTargetDimensions() {
        return 2;
    }

    @Override
    public DirectPosition transform(DirectPosition directPosition, DirectPosition directPosition2) {
        if (directPosition2 == null) {
            directPosition2 = new GeneralDirectPosition(2);
        } else {
            int n = directPosition2.getDimension();
            if (n != 2) {
                throw new MismatchedDimensionException(Errors.format(94, "ptDst", n, 2));
            }
        }
        double[] dArray = directPosition.getCoordinate();
        this.transform(dArray, 0, dArray, 0, 1);
        directPosition2.setOrdinate(0, dArray[0]);
        directPosition2.setOrdinate(1, dArray[1]);
        return directPosition2;
    }

    @Override
    public Shape createTransformedShape(Shape shape) {
        return AffineTransform2D.transform((AffineTransform)this, shape, false);
    }

    @Override
    public Matrix getMatrix() {
        return new Matrix3(this);
    }

    @Override
    public Matrix derivative(Point2D point2D) {
        return new Matrix2(this.getScaleX(), this.getShearX(), this.getShearY(), this.getScaleY());
    }

    @Override
    public Matrix derivative(DirectPosition directPosition) {
        return this.derivative((Point2D)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MathTransform2D inverse() throws NoninvertibleTransformException {
        if (this.inverse == null) {
            if (this.isIdentity()) {
                this.inverse = this;
            } else {
                try {
                    AffineTransform2D affineTransform2D = this;
                    synchronized (affineTransform2D) {
                        this.inverse = new AffineTransform2D(this.createInverse());
                        this.inverse.inverse = this;
                    }
                }
                catch (java.awt.geom.NoninvertibleTransformException noninvertibleTransformException) {
                    throw new NoninvertibleTransformException(noninvertibleTransformException.getLocalizedMessage(), noninvertibleTransformException);
                }
            }
        }
        return this.inverse;
    }

    @Override
    public AffineTransform clone() {
        return new AffineTransform(this);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof AffineTransform)) {
            return false;
        }
        AffineTransform affineTransform = (AffineTransform)object;
        return Utilities.equals(this.getScaleX(), affineTransform.getScaleX()) && Utilities.equals(this.getScaleY(), affineTransform.getScaleY()) && Utilities.equals(this.getShearX(), affineTransform.getShearX()) && Utilities.equals(this.getShearY(), affineTransform.getShearY()) && Utilities.equals(this.getTranslateX(), affineTransform.getTranslateX()) && Utilities.equals(this.getTranslateY(), affineTransform.getTranslateY());
    }
}

