/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.matrix;

import java.awt.geom.AffineTransform;
import java.text.FieldPosition;
import java.text.NumberFormat;
import javax.vecmath.GMatrix;
import org.geotools.referencing.operation.matrix.XMatrix;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Utilities;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.operation.Matrix;

public class GeneralMatrix
extends GMatrix
implements XMatrix {
    private static final long serialVersionUID = 8447482612423035360L;

    public GeneralMatrix(int n) {
        super(n, n);
    }

    public GeneralMatrix(int n, int n2) {
        super(n, n2);
    }

    public GeneralMatrix(int n, int n2, double[] dArray) {
        super(n, n2, dArray);
        if (n * n2 != dArray.length) {
            throw new IllegalArgumentException(String.valueOf(dArray.length));
        }
    }

    public GeneralMatrix(Matrix matrix) {
        this(matrix.getNumRow(), matrix.getNumCol());
        int n = this.getNumRow();
        int n2 = this.getNumCol();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.setElement(i, j, matrix.getElement(i, j));
            }
        }
    }

    public GeneralMatrix(AxisDirection[] axisDirectionArray, AxisDirection[] axisDirectionArray2) {
        this(null, axisDirectionArray, null, axisDirectionArray2, false);
    }

    private GeneralMatrix(Envelope envelope, AxisDirection[] axisDirectionArray, Envelope envelope2, AxisDirection[] axisDirectionArray2, boolean bl) {
        super(axisDirectionArray2.length + 1, axisDirectionArray.length + 1);
        if (bl) {
            GeneralMatrix.ensureDimensionMatch("srcRegion", envelope, axisDirectionArray.length);
            GeneralMatrix.ensureDimensionMatch("dstRegion", envelope2, axisDirectionArray2.length);
        }
        this.setZero();
        for (int i = 0; i < axisDirectionArray2.length; ++i) {
            boolean bl2 = false;
            AxisDirection axisDirection = axisDirectionArray2[i];
            AxisDirection axisDirection2 = axisDirection.absolute();
            for (int j = 0; j < axisDirectionArray.length; ++j) {
                AxisDirection axisDirection3 = axisDirectionArray[j];
                if (!axisDirection2.equals(axisDirection3.absolute())) continue;
                if (bl2) {
                    throw new IllegalArgumentException(Errors.format(36, axisDirection3.name(), axisDirection.name()));
                }
                bl2 = true;
                boolean bl3 = axisDirection3.equals(axisDirection);
                double d = bl3 ? 1.0 : -1.0;
                double d2 = 0.0;
                if (bl) {
                    d2 = bl3 ? envelope2.getMinimum(i) : envelope2.getMaximum(i);
                    d2 -= envelope.getMinimum(j) * (d *= envelope2.getLength(i) / envelope.getLength(j));
                }
                this.setElement(i, j, d);
                this.setElement(i, axisDirectionArray.length, d2);
            }
            if (bl2) continue;
            throw new IllegalArgumentException(Errors.format(136, axisDirectionArray2[i].name()));
        }
        this.setElement(axisDirectionArray2.length, axisDirectionArray.length, 1.0);
        assert (axisDirectionArray.length != axisDirectionArray2.length || this.isAffine()) : this;
    }

    private static void ensureDimensionMatch(String string, Envelope envelope, int n) throws MismatchedDimensionException {
        int n2 = envelope.getDimension();
        if (n != n2) {
            throw new MismatchedDimensionException(Errors.format(94, string, n2, n));
        }
    }

    @Override
    public final boolean isAffine() {
        int n = this.getNumRow();
        if (n != this.getNumCol()) {
            return false;
        }
        --n;
        for (int i = 0; i <= n; ++i) {
            if (this.getElement(n, i) == (double)(i == n ? 1 : 0)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean isIdentity() {
        int n;
        int n2 = this.getNumRow();
        if (n2 != (n = this.getNumCol())) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                if (this.getElement(i, j) == (double)(j == i ? 1 : 0)) continue;
                return false;
            }
        }
        assert (this.isAffine()) : this;
        assert (this.isIdentity(0.0)) : this;
        return true;
    }

    @Override
    public final boolean isIdentity(double d) {
        return GeneralMatrix.isIdentity(this, d);
    }

    static boolean isIdentity(Matrix matrix, double d) {
        int n;
        d = Math.abs(d);
        int n2 = matrix.getNumRow();
        if (n2 != (n = matrix.getNumCol())) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                double d2 = matrix.getElement(i, j);
                if (j == i) {
                    d2 -= 1.0;
                }
                if (Math.abs(d2) <= d) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public final void multiply(Matrix matrix) {
        GMatrix gMatrix = matrix instanceof GMatrix ? (GMatrix)((Object)matrix) : new GeneralMatrix(matrix);
        this.mul(gMatrix);
    }

    @Override
    public boolean equals(Matrix matrix, double d) {
        return GeneralMatrix.epsilonEquals(this, matrix, d);
    }

    static boolean epsilonEquals(Matrix matrix, Matrix matrix2, double d) {
        int n = matrix.getNumRow();
        if (n != matrix2.getNumRow()) {
            return false;
        }
        int n2 = matrix.getNumCol();
        if (n2 != matrix2.getNumCol()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                double d2;
                double d3 = matrix.getElement(i, j);
                if (Math.abs(d3 - (d2 = matrix2.getElement(i, j))) <= d || Double.doubleToLongBits(d3) == Double.doubleToLongBits(d2)) continue;
                return false;
            }
        }
        return true;
    }

    public final AffineTransform toAffineTransform2D() throws IllegalStateException {
        int n = this.getNumRow();
        if (n != 3 || (n = this.getNumCol()) != 3) {
            throw new IllegalStateException(Errors.format(127, n - 1));
        }
        if (this.isAffine()) {
            return new AffineTransform(this.getElement(0, 0), this.getElement(1, 0), this.getElement(0, 1), this.getElement(1, 1), this.getElement(0, 2), this.getElement(1, 2));
        }
        throw new IllegalStateException(Errors.format(118));
    }

    @Override
    public String toString() {
        return GeneralMatrix.toString(this);
    }

    static String toString(Matrix matrix) {
        int n = matrix.getNumRow();
        int n2 = matrix.getNumCol();
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator", "\n");
        FieldPosition fieldPosition = new FieldPosition(0);
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setGroupingUsed(false);
        numberFormat.setMinimumFractionDigits(6);
        numberFormat.setMaximumFractionDigits(6);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n3 = stringBuffer.length();
                stringBuffer = numberFormat.format(matrix.getElement(i, j), stringBuffer, fieldPosition);
                int n4 = Math.max(12 - (stringBuffer.length() - n3), 1);
                stringBuffer.insert(n3, Utilities.spaces(n4));
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    @Override
    public GeneralMatrix clone() {
        return (GeneralMatrix)super.clone();
    }
}

