/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.measure.unit.Unit;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.Parameters;
import org.geotools.referencing.operation.DefaultOperationMethod;
import org.geotools.referencing.operation.transform.MathTransformProxy;
import org.geotools.resources.XArray;
import org.geotools.resources.i18n.Errors;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.InvalidParameterNameException;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Operation;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.GenericName;

public abstract class MathTransformProvider
extends DefaultOperationMethod {
    private static final long serialVersionUID = 7530475536803158473L;

    public MathTransformProvider(int n, int n2, ParameterDescriptorGroup parameterDescriptorGroup) {
        this(MathTransformProvider.toMap(parameterDescriptorGroup), n, n2, parameterDescriptorGroup);
    }

    public MathTransformProvider(Map<String, ?> map, int n, int n2, ParameterDescriptorGroup parameterDescriptorGroup) {
        super(map, n, n2, parameterDescriptorGroup);
    }

    private static Map<String, Object> toMap(IdentifiedObject identifiedObject) {
        MathTransformProvider.ensureNonNull("parameters", identifiedObject);
        HashMap<String, Object> hashMap = new HashMap<String, Object>(4);
        hashMap.put("name", identifiedObject.getName());
        hashMap.put("identifiers", identifiedObject.getIdentifiers().toArray(EMPTY_IDENTIFIER_ARRAY));
        hashMap.put("alias", identifiedObject.getAlias().toArray(EMPTY_ALIAS_ARRAY));
        return hashMap;
    }

    @Override
    public Class<? extends Operation> getOperationType() {
        return Operation.class;
    }

    protected abstract MathTransform createMathTransform(ParameterValueGroup var1) throws InvalidParameterNameException, ParameterNotFoundException, InvalidParameterValueException, FactoryException;

    protected static ParameterDescriptor<Double> createDescriptor(ReferenceIdentifier[] referenceIdentifierArray, double d, double d2, double d3, Unit<?> unit) {
        return DefaultParameterDescriptor.create(MathTransformProvider.toMap(referenceIdentifierArray), d, d2, d3, unit, true);
    }

    protected static ParameterDescriptor<Double> createOptionalDescriptor(ReferenceIdentifier[] referenceIdentifierArray, double d, double d2, Unit<?> unit) {
        return DefaultParameterDescriptor.create(MathTransformProvider.toMap(referenceIdentifierArray), Double.NaN, d, d2, unit, false);
    }

    protected static ParameterDescriptorGroup createDescriptorGroup(ReferenceIdentifier[] referenceIdentifierArray, GeneralParameterDescriptor[] generalParameterDescriptorArray) {
        return new DefaultParameterDescriptorGroup(MathTransformProvider.toMap(referenceIdentifierArray), generalParameterDescriptorArray);
    }

    private static Map<String, Object> toMap(ReferenceIdentifier[] referenceIdentifierArray) {
        MathTransformProvider.ensureNonNull("identifiers", referenceIdentifierArray);
        if (referenceIdentifierArray.length == 0) {
            throw new IllegalArgumentException(Errors.format(46));
        }
        int n = 0;
        int n2 = 0;
        ReferenceIdentifier[] referenceIdentifierArray2 = new ReferenceIdentifier[referenceIdentifierArray.length];
        GenericName[] genericNameArray = new GenericName[referenceIdentifierArray.length];
        for (int i = 0; i < referenceIdentifierArray.length; ++i) {
            ReferenceIdentifier referenceIdentifier = referenceIdentifierArray[i];
            if (referenceIdentifier instanceof GenericName) {
                genericNameArray[n2++] = (GenericName)((Object)referenceIdentifier);
                continue;
            }
            referenceIdentifierArray2[n++] = referenceIdentifier;
        }
        referenceIdentifierArray2 = XArray.resize(referenceIdentifierArray2, n);
        genericNameArray = XArray.resize(genericNameArray, n2);
        HashMap<String, Object> hashMap = new HashMap<String, Object>(4, 0.8f);
        hashMap.put("name", referenceIdentifierArray[0]);
        hashMap.put("identifiers", referenceIdentifierArray2);
        hashMap.put("alias", genericNameArray);
        return hashMap;
    }

    protected ParameterValueGroup ensureValidValues(ParameterValueGroup parameterValueGroup) throws InvalidParameterNameException, InvalidParameterValueException {
        ParameterDescriptorGroup parameterDescriptorGroup;
        ParameterDescriptorGroup parameterDescriptorGroup2 = this.getParameters();
        if (parameterDescriptorGroup2.equals(parameterDescriptorGroup = parameterValueGroup.getDescriptor())) {
            return parameterValueGroup;
        }
        ParameterValueGroup parameterValueGroup2 = parameterDescriptorGroup2.createValue();
        MathTransformProvider.copy(parameterValueGroup, parameterValueGroup2);
        return parameterValueGroup2;
    }

    private static void copy(ParameterValueGroup parameterValueGroup, ParameterValueGroup parameterValueGroup2) throws InvalidParameterNameException, InvalidParameterValueException {
        for (GeneralParameterValue generalParameterValue : parameterValueGroup.values()) {
            Serializable serializable;
            GeneralParameterValue generalParameterValue2;
            Object object;
            String string = generalParameterValue.getDescriptor().getName().getCode();
            if (generalParameterValue instanceof ParameterValueGroup) {
                object = parameterValueGroup2.getDescriptor().descriptor(string);
                if (object instanceof ParameterDescriptorGroup) {
                    generalParameterValue2 = (ParameterValueGroup)object.createValue();
                    MathTransformProvider.copy((ParameterValueGroup)generalParameterValue, generalParameterValue2);
                    parameterValueGroup.groups(string).add((ParameterValueGroup)generalParameterValue2);
                    continue;
                }
                throw new InvalidParameterNameException(Errors.format(176, string), string);
            }
            object = (ParameterValue)generalParameterValue;
            try {
                generalParameterValue2 = parameterValueGroup2.parameter(string);
            }
            catch (ParameterNotFoundException parameterNotFoundException) {
                serializable = new InvalidParameterNameException(Errors.format(176, string), string);
                ((Throwable)serializable).initCause(parameterNotFoundException);
                throw serializable;
            }
            Object t = object.getValue();
            serializable = object.getUnit();
            if (serializable == null) {
                generalParameterValue2.setValue(t);
                continue;
            }
            if (t instanceof Number) {
                generalParameterValue2.setValue(((Number)t).doubleValue(), (Unit<?>)serializable);
                continue;
            }
            if (t instanceof double[]) {
                generalParameterValue2.setValue((double[])t, (Unit<?>)serializable);
                continue;
            }
            throw new InvalidParameterValueException(Errors.format(58, string, t), string, t);
        }
    }

    protected static <T> ParameterValue<T> getParameter(ParameterDescriptor<T> parameterDescriptor, ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
        String string = MathTransformProvider.getName(parameterDescriptor, parameterValueGroup.getDescriptor().getName().getAuthority());
        if (string == null) {
            string = parameterDescriptor.getName().getCode();
        }
        if (parameterDescriptor.getMinimumOccurs() != 0) {
            return Parameters.cast(parameterValueGroup.parameter(string), parameterDescriptor.getValueClass());
        }
        GeneralParameterDescriptor generalParameterDescriptor = parameterValueGroup.getDescriptor().descriptor(string);
        if (generalParameterDescriptor instanceof ParameterDescriptor) {
            for (GeneralParameterValue generalParameterValue : parameterValueGroup.values()) {
                if (!generalParameterDescriptor.equals(generalParameterValue.getDescriptor())) continue;
                return Parameters.cast((ParameterValue)generalParameterValue, parameterDescriptor.getValueClass());
            }
        }
        return null;
    }

    protected static int intValue(ParameterDescriptor<?> parameterDescriptor, ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
        ParameterValue<?> parameterValue = MathTransformProvider.getParameter(parameterDescriptor, parameterValueGroup);
        return parameterValue != null ? parameterValue.intValue() : 0;
    }

    protected static double doubleValue(ParameterDescriptor<?> parameterDescriptor, ParameterValueGroup parameterValueGroup) throws ParameterNotFoundException {
        Unit<?> unit = parameterDescriptor.getUnit();
        ParameterValue<?> parameterValue = MathTransformProvider.getParameter(parameterDescriptor, parameterValueGroup);
        return parameterValue == null ? Double.NaN : (unit != null ? parameterValue.doubleValue(unit) : parameterValue.doubleValue());
    }

    protected static final class Delegate
    extends MathTransformProxy {
        private static final long serialVersionUID = -3942740060970730790L;
        public final OperationMethod method;

        public Delegate(MathTransform mathTransform, OperationMethod operationMethod) {
            super(mathTransform);
            this.method = operationMethod;
            MathTransformProvider.ensureNonNull("transform", mathTransform);
            MathTransformProvider.ensureNonNull("method", operationMethod);
        }
    }
}

