/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.factory.Hints;
import org.geotools.factory.OptionalFactory;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.factory.BackingStoreException;
import org.geotools.referencing.operation.AbstractCoordinateOperation;
import org.geotools.referencing.operation.DefaultCoordinateOperationFactory;
import org.geotools.referencing.operation.DefaultOperationMethod;
import org.geotools.resources.i18n.Loggings;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.Operation;
import org.opengis.referencing.operation.OperationMethod;

public class AuthorityBackedFactory
extends DefaultCoordinateOperationFactory
implements OptionalFactory {
    static final int PRIORITY = 60;
    private static final String DEFAULT_AUTHORITY = "EPSG";
    private CoordinateOperationAuthorityFactory authorityFactory;
    private final ThreadLocal<Boolean> processing = new ThreadLocal();

    public AuthorityBackedFactory() {
        this(null);
    }

    public AuthorityBackedFactory(Hints hints) {
        super(hints, 60);
        hints = new Hints(hints);
        hints.keySet().removeAll(this.hints.keySet());
        hints.remove(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER);
        hints.remove(Hints.FORCE_STANDARD_AXIS_DIRECTIONS);
        hints.remove(Hints.FORCE_STANDARD_AXIS_UNITS);
        if (!hints.isEmpty()) {
            AuthorityBackedFactory.noForce(hints);
            this.authorityFactory = ReferencingFactoryFinder.getCoordinateOperationAuthorityFactory(DEFAULT_AUTHORITY, hints);
        }
    }

    private static void noForce(Hints hints) {
        hints.put(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, Boolean.FALSE);
        hints.put(Hints.FORCE_STANDARD_AXIS_DIRECTIONS, Boolean.FALSE);
        hints.put(Hints.FORCE_STANDARD_AXIS_UNITS, Boolean.FALSE);
    }

    protected CoordinateOperationAuthorityFactory getAuthorityFactory() {
        if (this.authorityFactory == null) {
            Hints hints = new Hints();
            AuthorityBackedFactory.noForce(hints);
            this.authorityFactory = ReferencingFactoryFinder.getCoordinateOperationAuthorityFactory(DEFAULT_AUTHORITY, hints);
        }
        return this.authorityFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CoordinateOperation createFromDatabase(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) {
        boolean bl;
        Set<CoordinateOperation> set;
        String string;
        if (Boolean.TRUE.equals(this.processing.get())) {
            return null;
        }
        CoordinateOperationAuthorityFactory coordinateOperationAuthorityFactory = this.getAuthorityFactory();
        Citation citation = coordinateOperationAuthorityFactory.getAuthority();
        ReferenceIdentifier referenceIdentifier = AbstractIdentifiedObject.getIdentifier(coordinateReferenceSystem, citation);
        if (referenceIdentifier == null) {
            return null;
        }
        ReferenceIdentifier referenceIdentifier2 = AbstractIdentifiedObject.getIdentifier(coordinateReferenceSystem2, citation);
        if (referenceIdentifier2 == null) {
            return null;
        }
        String string2 = referenceIdentifier.getCode().trim();
        if (string2.equals(string = referenceIdentifier2.getCode().trim())) {
            return null;
        }
        try {
            set = coordinateOperationAuthorityFactory.createFromCoordinateReferenceSystemCodes(string2, string);
            boolean bl2 = bl = set == null || set.isEmpty();
            if (bl) {
                set = coordinateOperationAuthorityFactory.createFromCoordinateReferenceSystemCodes(string, string2);
            }
        }
        catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
            return null;
        }
        catch (FactoryException factoryException) {
            AuthorityBackedFactory.log(factoryException, coordinateOperationAuthorityFactory);
            return null;
        }
        if (set != null) {
            Iterator<CoordinateOperation> iterator = set.iterator();
            while (iterator.hasNext()) {
                CoordinateOperation coordinateOperation;
                block26: {
                    try {
                        coordinateOperation = iterator.next();
                        if (coordinateOperation == null) continue;
                        if (!bl) break block26;
                        coordinateOperation = this.inverse(coordinateOperation);
                    }
                    catch (NoninvertibleTransformException noninvertibleTransformException) {
                        continue;
                    }
                    catch (FactoryException factoryException) {
                        AuthorityBackedFactory.log(factoryException, coordinateOperationAuthorityFactory);
                        continue;
                    }
                    catch (BackingStoreException backingStoreException) {
                        AuthorityBackedFactory.log(backingStoreException, coordinateOperationAuthorityFactory);
                        continue;
                    }
                }
                CoordinateReferenceSystem coordinateReferenceSystem3 = coordinateOperation.getSourceCRS();
                CoordinateReferenceSystem coordinateReferenceSystem4 = coordinateOperation.getTargetCRS();
                try {
                    MathTransform mathTransform;
                    MathTransform mathTransform2;
                    if (!CRS.equalsIgnoreMetadata(coordinateReferenceSystem, coordinateReferenceSystem3)) {
                        try {
                            this.processing.set(Boolean.TRUE);
                            mathTransform2 = this.createOperation(coordinateReferenceSystem, coordinateReferenceSystem3).getMathTransform();
                            coordinateReferenceSystem3 = coordinateReferenceSystem;
                        }
                        finally {
                            this.processing.remove();
                        }
                    } else {
                        mathTransform2 = null;
                    }
                    if (!CRS.equalsIgnoreMetadata(coordinateReferenceSystem4, coordinateReferenceSystem2)) {
                        try {
                            this.processing.set(Boolean.TRUE);
                            mathTransform = this.createOperation(coordinateReferenceSystem4, coordinateReferenceSystem2).getMathTransform();
                            coordinateReferenceSystem4 = coordinateReferenceSystem2;
                        }
                        finally {
                            this.processing.remove();
                        }
                    } else {
                        mathTransform = null;
                    }
                    coordinateOperation = this.transform(coordinateReferenceSystem3, mathTransform2, coordinateOperation, mathTransform, coordinateReferenceSystem4);
                }
                catch (FactoryException factoryException) {
                    AuthorityBackedFactory.log(factoryException, coordinateOperationAuthorityFactory);
                    return null;
                }
                if (!this.accept(coordinateOperation)) continue;
                return coordinateOperation;
            }
        }
        return null;
    }

    private CoordinateOperation transform(CoordinateReferenceSystem coordinateReferenceSystem, MathTransform mathTransform, CoordinateOperation coordinateOperation, MathTransform mathTransform2, CoordinateReferenceSystem coordinateReferenceSystem2) throws FactoryException {
        Object object;
        CoordinateOperation[] coordinateOperationArray;
        if ((mathTransform == null || mathTransform.isIdentity()) && (mathTransform2 == null || mathTransform2.isIdentity())) {
            return coordinateOperation;
        }
        Map<String, ?> map = AbstractIdentifiedObject.getProperties(coordinateOperation);
        if (coordinateOperation instanceof ConcatenatedOperation && (coordinateOperationArray = (object = ((ConcatenatedOperation)coordinateOperation).getOperations()).toArray(new CoordinateOperation[object.size()])).length != 0) {
            CoordinateOperation coordinateOperation2 = coordinateOperationArray[0];
            if (coordinateOperationArray.length == 1) {
                coordinateOperationArray[0] = this.transform(coordinateReferenceSystem, mathTransform, coordinateOperation2, mathTransform2, coordinateReferenceSystem2);
            } else {
                CoordinateOperation coordinateOperation3 = coordinateOperationArray[coordinateOperationArray.length - 1];
                coordinateOperationArray[0] = this.transform(coordinateReferenceSystem, mathTransform, coordinateOperation2, null, coordinateOperation2.getTargetCRS());
                coordinateOperationArray[coordinateOperationArray.length - 1] = this.transform(coordinateOperation3.getSourceCRS(), null, coordinateOperation3, mathTransform2, coordinateReferenceSystem2);
            }
            return this.createConcatenatedOperation(map, coordinateOperationArray);
        }
        object = coordinateOperation.getMathTransform();
        coordinateOperationArray = this.getMathTransformFactory();
        if (mathTransform != null) {
            object = coordinateOperationArray.createConcatenatedTransform(mathTransform, (MathTransform)object);
        }
        if (mathTransform2 != null) {
            object = coordinateOperationArray.createConcatenatedTransform((MathTransform)object, mathTransform2);
        }
        assert (!object.equals(coordinateOperation.getMathTransform())) : object;
        Class<? extends CoordinateOperation> clazz = AbstractCoordinateOperation.getType(coordinateOperation);
        OperationMethod operationMethod = null;
        if (coordinateOperation instanceof Operation && (operationMethod = ((Operation)coordinateOperation).getMethod()) != null) {
            int n = object.getSourceDimensions();
            int n2 = object.getTargetDimensions();
            if (n != operationMethod.getSourceDimensions() || n2 != operationMethod.getTargetDimensions()) {
                operationMethod = new DefaultOperationMethod(operationMethod, n, n2);
            }
        }
        return this.createFromMathTransform(map, coordinateReferenceSystem, coordinateReferenceSystem2, (MathTransform)object, operationMethod, clazz);
    }

    private static void log(Exception exception, AuthorityFactory authorityFactory) {
        LogRecord logRecord = Loggings.format(Level.WARNING, 6, authorityFactory.getAuthority().getTitle());
        logRecord.setSourceClassName(AuthorityBackedFactory.class.getName());
        logRecord.setSourceMethodName("createFromDatabase");
        logRecord.setThrown(exception);
        logRecord.setLoggerName(LOGGER.getName());
        LOGGER.log(logRecord);
    }

    protected boolean accept(CoordinateOperation coordinateOperation) {
        return true;
    }

    @Override
    public boolean isAvailable() {
        try {
            CoordinateOperationAuthorityFactory coordinateOperationAuthorityFactory = this.getAuthorityFactory();
            if (coordinateOperationAuthorityFactory instanceof OptionalFactory) {
                return ((OptionalFactory)((Object)coordinateOperationAuthorityFactory)).isAvailable();
            }
            return true;
        }
        catch (FactoryRegistryException factoryRegistryException) {
            return false;
        }
    }
}

