/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.crs.AbstractDerivedCRS;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Utilities;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.ConicProjection;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CylindricalProjection;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.Operation;
import org.opengis.referencing.operation.PlanarProjection;
import org.opengis.referencing.operation.Projection;
import org.opengis.referencing.operation.Transformation;
import org.opengis.util.InternationalString;

public class AbstractCoordinateOperation
extends AbstractIdentifiedObject
implements CoordinateOperation {
    private static final long serialVersionUID = 1237358357729193885L;
    public static final PositionalAccuracy[] EMPTY_ACCURACY_ARRAY = new PositionalAccuracy[0];
    private static final String[] LOCALIZABLES = new String[]{"scope"};
    protected final CoordinateReferenceSystem sourceCRS;
    protected final CoordinateReferenceSystem targetCRS;
    final String operationVersion;
    private final Collection<PositionalAccuracy> coordinateOperationAccuracy;
    protected final Extent domainOfValidity;
    private final InternationalString scope;
    protected final MathTransform transform;

    AbstractCoordinateOperation(Conversion conversion, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, MathTransform mathTransform) {
        super(conversion);
        this.sourceCRS = coordinateReferenceSystem;
        this.targetCRS = coordinateReferenceSystem2;
        this.operationVersion = conversion.getOperationVersion();
        this.coordinateOperationAccuracy = conversion.getCoordinateOperationAccuracy();
        this.domainOfValidity = conversion.getDomainOfValidity();
        this.scope = conversion.getScope();
        this.transform = mathTransform;
    }

    public AbstractCoordinateOperation(Map<String, ?> map, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, MathTransform mathTransform) {
        this(map, new HashMap<String, Object>(), coordinateReferenceSystem, coordinateReferenceSystem2, mathTransform);
    }

    private AbstractCoordinateOperation(Map<String, ?> map, Map<String, Object> map2, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2, MathTransform mathTransform) {
        super(map, map2, LOCALIZABLES);
        this.domainOfValidity = (Extent)map2.get("domainOfValidity");
        this.scope = (InternationalString)map2.get("scope");
        this.operationVersion = (String)map2.get("operationVersion");
        Object[] objectArray = (PositionalAccuracy[])map2.get("coordinateOperationAccuracy");
        if (objectArray == null || objectArray.length == 0) {
            objectArray = null;
        } else {
            objectArray = (PositionalAccuracy[])objectArray.clone();
            for (int i = 0; i < objectArray.length; ++i) {
                AbstractCoordinateOperation.ensureNonNull("coordinateOperationAccuracy", objectArray, i);
            }
        }
        this.coordinateOperationAccuracy = AbstractCoordinateOperation.asSet(objectArray);
        this.sourceCRS = coordinateReferenceSystem;
        this.targetCRS = coordinateReferenceSystem2;
        this.transform = mathTransform;
        this.validate();
    }

    void validate() throws IllegalArgumentException {
        AbstractCoordinateOperation.ensureNonNull("sourceCRS", this.transform);
        AbstractCoordinateOperation.ensureNonNull("targetCRS", this.transform);
        AbstractCoordinateOperation.ensureNonNull("transform", this.transform);
        AbstractCoordinateOperation.checkDimension("sourceCRS", this.sourceCRS, this.transform.getSourceDimensions());
        AbstractCoordinateOperation.checkDimension("targetCRS", this.targetCRS, this.transform.getTargetDimensions());
    }

    private static void checkDimension(String string, CoordinateReferenceSystem coordinateReferenceSystem, int n) {
        int n2 = coordinateReferenceSystem.getCoordinateSystem().getDimension();
        if (n2 != n) {
            throw new IllegalArgumentException(Errors.format(94, string, n2, n));
        }
    }

    @Override
    public CoordinateReferenceSystem getSourceCRS() {
        return this.sourceCRS;
    }

    @Override
    public CoordinateReferenceSystem getTargetCRS() {
        return this.targetCRS;
    }

    @Override
    public String getOperationVersion() {
        return this.operationVersion;
    }

    @Override
    public Collection<PositionalAccuracy> getCoordinateOperationAccuracy() {
        if (this.coordinateOperationAccuracy == null) {
            return Collections.emptySet();
        }
        return this.coordinateOperationAccuracy;
    }

    @Override
    public Extent getDomainOfValidity() {
        return this.domainOfValidity;
    }

    @Override
    public InternationalString getScope() {
        return this.scope;
    }

    @Override
    public MathTransform getMathTransform() {
        return this.transform;
    }

    public static Class<? extends CoordinateOperation> getType(CoordinateOperation coordinateOperation) {
        if (coordinateOperation instanceof Transformation) {
            return Transformation.class;
        }
        if (coordinateOperation instanceof ConicProjection) {
            return ConicProjection.class;
        }
        if (coordinateOperation instanceof CylindricalProjection) {
            return CylindricalProjection.class;
        }
        if (coordinateOperation instanceof PlanarProjection) {
            return PlanarProjection.class;
        }
        if (coordinateOperation instanceof Projection) {
            return Projection.class;
        }
        if (coordinateOperation instanceof Conversion) {
            return Conversion.class;
        }
        if (coordinateOperation instanceof Operation) {
            return Operation.class;
        }
        return CoordinateOperation.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(AbstractIdentifiedObject abstractIdentifiedObject, boolean bl) {
        if (abstractIdentifiedObject == this) {
            return true;
        }
        if (super.equals(abstractIdentifiedObject, bl)) {
            AbstractCoordinateOperation abstractCoordinateOperation = (AbstractCoordinateOperation)abstractIdentifiedObject;
            if (AbstractCoordinateOperation.equals(this.sourceCRS, abstractCoordinateOperation.sourceCRS, bl) && Utilities.equals(this.transform, abstractCoordinateOperation.transform)) {
                if (!(!bl || Utilities.equals(this.domainOfValidity, abstractCoordinateOperation.domainOfValidity) && Utilities.equals(this.scope, abstractCoordinateOperation.scope) && Utilities.equals(this.coordinateOperationAccuracy, abstractCoordinateOperation.coordinateOperationAccuracy))) {
                    return false;
                }
                Boolean bl2 = AbstractDerivedCRS._COMPARING.get();
                if (bl2 != null && bl2.booleanValue()) {
                    return true;
                }
                try {
                    AbstractDerivedCRS._COMPARING.set(Boolean.TRUE);
                    boolean bl3 = AbstractCoordinateOperation.equals(this.targetCRS, abstractCoordinateOperation.targetCRS, bl);
                    return bl3;
                }
                finally {
                    AbstractDerivedCRS._COMPARING.set(Boolean.FALSE);
                }
            }
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = -598790243;
        if (this.sourceCRS != null) {
            n ^= this.sourceCRS.hashCode();
        }
        if (this.targetCRS != null) {
            n ^= this.targetCRS.hashCode();
        }
        if (this.transform != null) {
            n ^= this.transform.hashCode();
        }
        return n;
    }
}

