/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import javax.measure.unit.Unit;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.factory.ReferencingFactory;
import org.geotools.resources.XArray;
import org.geotools.resources.i18n.Loggings;
import org.geotools.util.LocalName;
import org.geotools.util.NameFactory;
import org.geotools.util.ScopedName;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.ImageDatum;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.util.GenericName;

public class DatumAliases
extends ReferencingFactory
implements DatumFactory {
    private static final String ALIAS_TABLE = "DatumAliasesTable.txt";
    private static final String SEPARATORS = ";";
    private static final Object[] NEED_LOADING = new Object[0];
    private final URL aliasURL;
    private final Map<String, Object[]> aliasMap = new HashMap<String, Object[]>();
    private LocalName[] authorities;
    private DatumFactory factory;

    public DatumAliases() {
        super(60);
        this.aliasURL = DatumAliases.class.getResource(ALIAS_TABLE);
        if (this.aliasURL == null) {
            throw new NoSuchElementException(ALIAS_TABLE);
        }
    }

    public DatumAliases(DatumFactory datumFactory) {
        this();
        this.factory = datumFactory;
        DatumAliases.ensureNonNull("factory", datumFactory);
    }

    public DatumAliases(DatumFactory datumFactory, URL uRL) {
        super(60);
        this.factory = datumFactory;
        this.aliasURL = uRL;
        DatumAliases.ensureNonNull("factory", datumFactory);
        DatumAliases.ensureNonNull("aliasURL", uRL);
    }

    private DatumFactory getDatumFactory() throws NoSuchElementException {
        assert (Thread.holdsLock(this));
        if (this.factory == null) {
            DatumFactory datumFactory;
            Iterator<DatumFactory> iterator = ReferencingFactoryFinder.getDatumFactories(null).iterator();
            while ((datumFactory = iterator.next()) == this) {
            }
            this.factory = datumFactory;
        }
        return this.factory;
    }

    private static String toCaseless(String string) {
        return string.replace('_', ' ').trim().toLowerCase();
    }

    private static String readLine(BufferedReader bufferedReader) throws IOException {
        String string;
        while ((string = bufferedReader.readLine()) != null && ((string = string.trim()).length() == 0 || string.charAt(0) == '#')) {
        }
        return string;
    }

    private void reload() throws IOException {
        assert (Thread.holdsLock(this));
        LogRecord logRecord = Loggings.format(Level.FINE, 27, this.aliasURL);
        logRecord.setLoggerName(LOGGER.getName());
        LOGGER.log(logRecord);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.aliasURL.openStream()));
        String string = DatumAliases.readLine(bufferedReader);
        if (string != null) {
            Object object;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, SEPARATORS);
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken().trim();
                arrayList.add(((String)object).length() != 0 ? new LocalName((CharSequence)object) : null);
            }
            this.authorities = arrayList.toArray(new LocalName[arrayList.size()]);
            object = new HashMap();
            while ((string = DatumAliases.readLine(bufferedReader)) != null) {
                arrayList.clear();
                object.clear();
                stringTokenizer = new StringTokenizer(string, SEPARATORS);
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken().trim();
                    if (string2.length() != 0) {
                        String string3 = object.put(string2, string2);
                        if (string3 != null) {
                            object.put(string3, string3);
                            string2 = string3;
                        }
                    } else {
                        string2 = null;
                    }
                    arrayList.add(string2);
                }
                int n = arrayList.size();
                while (--n >= 0 && arrayList.get(n) == null) {
                    arrayList.remove(n);
                }
                if (arrayList.isEmpty()) continue;
                Object[] objectArray = arrayList.toArray(new String[arrayList.size()]);
                for (int i = 0; i < objectArray.length; ++i) {
                    String string4 = objectArray[i];
                    String string5 = DatumAliases.toCaseless(string4);
                    Object[] objectArray2 = this.aliasMap.put(string5, objectArray);
                    if (objectArray2 == null || objectArray2 == NEED_LOADING) continue;
                    if (objectArray2 instanceof GenericName[]) {
                        this.aliasMap.put(string5, objectArray2);
                        continue;
                    }
                    if (Arrays.equals(objectArray2, objectArray)) continue;
                    LOGGER.warning("Inconsistent aliases for datum \"" + string4 + "\".");
                }
            }
        }
        bufferedReader.close();
    }

    private void log(IOException iOException) {
        LogRecord logRecord = Loggings.format(Level.WARNING, 9, this.aliasURL);
        logRecord.setSourceClassName(DatumAliases.class.getName());
        logRecord.setSourceMethodName("reload");
        logRecord.setThrown(iOException);
        logRecord.setLoggerName(LOGGER.getName());
        LOGGER.log(logRecord);
    }

    private GenericName[] getAliases(String string) {
        Object[] objectArray;
        CharSequence charSequence;
        int n;
        Object[] objectArray2;
        assert (Thread.holdsLock(this));
        if (this.aliasMap.isEmpty()) {
            try {
                this.reload();
            }
            catch (IOException iOException) {
                this.log(iOException);
            }
        }
        if ((objectArray2 = this.aliasMap.get(string = DatumAliases.toCaseless(string))) == null) {
            return null;
        }
        if (objectArray2 == NEED_LOADING) {
            try {
                this.reload();
            }
            catch (IOException iOException) {
                this.log(iOException);
            }
            objectArray2 = this.aliasMap.get(string);
            if (objectArray2 == NEED_LOADING) {
                return null;
            }
        }
        if (objectArray2 instanceof GenericName[]) {
            return (GenericName[])objectArray2;
        }
        int n2 = 0;
        GenericName[] genericNameArray = new GenericName[objectArray2.length];
        for (n = 0; n < objectArray2.length; ++n) {
            charSequence = (CharSequence)objectArray2[n];
            if (charSequence == null) continue;
            genericNameArray[n2++] = n2 < this.authorities.length && (objectArray = this.authorities[n2]) != null ? new ScopedName((GenericName)objectArray, charSequence) : new LocalName(charSequence);
        }
        genericNameArray = XArray.resize(genericNameArray, n2);
        for (n = 0; n < genericNameArray.length; ++n) {
            charSequence = ((Object)genericNameArray[n].tip()).toString();
            objectArray = this.aliasMap.put(DatumAliases.toCaseless((String)charSequence), genericNameArray);
            assert (objectArray == genericNameArray || Arrays.equals(objectArray2, objectArray)) : charSequence;
        }
        return genericNameArray;
    }

    private Map<String, ?> addAliases(Map<String, ?> hashMap) {
        DatumAliases.ensureNonNull("properties", hashMap);
        Object obj = hashMap.get("name");
        DatumAliases.ensureNonNull("name", obj);
        String string = obj instanceof Identifier ? ((Identifier)obj).getCode() : obj.toString();
        GenericName[] genericNameArray = this.getAliases(string);
        if (genericNameArray != null) {
            HashMap hashMap2;
            int n = genericNameArray.length;
            obj = hashMap.get("alias");
            if (obj != null) {
                hashMap2 = new LinkedHashMap<String, GenericName>();
                DatumAliases.putAll(NameFactory.toArray(obj), hashMap2);
                n -= DatumAliases.putAll(genericNameArray, hashMap2);
                Collection collection = hashMap2.values();
                genericNameArray = collection.toArray(new GenericName[collection.size()]);
            }
            if (n > 0) {
                hashMap2 = new HashMap(hashMap);
                hashMap2.put((String)"alias", (GenericName)genericNameArray);
                hashMap = hashMap2;
            }
        }
        return hashMap;
    }

    private static final int putAll(GenericName[] genericNameArray, Map<String, GenericName> map) {
        int n = 0;
        for (int i = 0; i < genericNameArray.length; ++i) {
            GenericName genericName = genericNameArray[i];
            GenericName genericName2 = genericName.toFullyQualifiedName();
            String string = DatumAliases.toCaseless(((Object)genericName2).toString());
            GenericName genericName3 = map.put(string, genericName);
            if (!(genericName3 instanceof org.opengis.util.ScopedName)) continue;
            map.put(string, genericName3);
            ++n;
        }
        return n;
    }

    @Override
    public synchronized EngineeringDatum createEngineeringDatum(Map<String, ?> map) throws FactoryException {
        return this.getDatumFactory().createEngineeringDatum(this.addAliases(map));
    }

    @Override
    public synchronized GeodeticDatum createGeodeticDatum(Map<String, ?> map, Ellipsoid ellipsoid, PrimeMeridian primeMeridian) throws FactoryException {
        return this.getDatumFactory().createGeodeticDatum(this.addAliases(map), ellipsoid, primeMeridian);
    }

    @Override
    public synchronized ImageDatum createImageDatum(Map<String, ?> map, PixelInCell pixelInCell) throws FactoryException {
        return this.getDatumFactory().createImageDatum(this.addAliases(map), pixelInCell);
    }

    @Override
    public synchronized TemporalDatum createTemporalDatum(Map<String, ?> map, Date date) throws FactoryException {
        return this.getDatumFactory().createTemporalDatum(this.addAliases(map), date);
    }

    @Override
    public synchronized VerticalDatum createVerticalDatum(Map<String, ?> map, VerticalDatumType verticalDatumType) throws FactoryException {
        return this.getDatumFactory().createVerticalDatum(this.addAliases(map), verticalDatumType);
    }

    @Override
    public synchronized Ellipsoid createEllipsoid(Map<String, ?> map, double d, double d2, Unit<Length> unit) throws FactoryException {
        return this.getDatumFactory().createEllipsoid(this.addAliases(map), d, d2, unit);
    }

    @Override
    public synchronized Ellipsoid createFlattenedSphere(Map<String, ?> map, double d, double d2, Unit<Length> unit) throws FactoryException {
        return this.getDatumFactory().createFlattenedSphere(this.addAliases(map), d, d2, unit);
    }

    @Override
    public synchronized PrimeMeridian createPrimeMeridian(Map<String, ?> map, double d, Unit<Angle> unit) throws FactoryException {
        return this.getDatumFactory().createPrimeMeridian(this.addAliases(map), d, unit);
    }

    public synchronized void freeUnused() {
        if (this.aliasMap != null) {
            for (Map.Entry<String, Object[]> entry : this.aliasMap.entrySet()) {
                Object[] objectArray = entry.getValue();
                if (objectArray instanceof GenericName[]) continue;
                entry.setValue(NEED_LOADING);
            }
        }
    }
}

