/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.cs;

import java.util.Map;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.geotools.measure.Measure;
import org.geotools.referencing.cs.AbstractCS;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.util.InternationalString;

public class DefaultTimeCS
extends AbstractCS
implements TimeCS {
    private static final long serialVersionUID = 5222911412381303989L;
    public static final DefaultTimeCS DAYS;

    public DefaultTimeCS(Map<String, ?> map, CoordinateSystemAxis coordinateSystemAxis) {
        super(map, new CoordinateSystemAxis[]{coordinateSystemAxis});
        DefaultTimeCS.ensureTimeUnit(this.getAxis(0).getUnit());
    }

    @Override
    protected boolean isCompatibleDirection(AxisDirection axisDirection) {
        return AxisDirection.FUTURE.equals(axisDirection.absolute());
    }

    @Override
    protected boolean isCompatibleUnit(AxisDirection axisDirection, Unit<?> unit) {
        return SI.SECOND.isCompatible(unit);
    }

    @Override
    public Measure distance(double[] dArray, double[] dArray2) throws MismatchedDimensionException {
        this.ensureDimensionMatch("coord1", dArray);
        this.ensureDimensionMatch("coord2", dArray2);
        return new Measure(Math.abs(dArray[0] - dArray2[0]), this.getDistanceUnit());
    }

    static {
        Map<String, Object> map = DefaultTimeCS.name(214);
        DefaultCoordinateSystemAxis defaultCoordinateSystemAxis = DefaultCoordinateSystemAxis.TIME;
        DAYS = new DefaultTimeCS(map, defaultCoordinateSystemAxis);
        InternationalString internationalString = defaultCoordinateSystemAxis.getAlias().iterator().next().toInternationalString();
        defaultCoordinateSystemAxis = new DefaultCoordinateSystemAxis(internationalString, "t", AxisDirection.FUTURE, SI.SECOND);
        defaultCoordinateSystemAxis = new DefaultCoordinateSystemAxis(internationalString, "t", AxisDirection.FUTURE, SI.MILLI(SI.SECOND));
    }
}

