/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.index.quadtree;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.shapefile.shp.IndexFile;
import org.geotools.index.CloseableIterator;
import org.geotools.index.Data;
import org.geotools.index.quadtree.LazySearchIterator;
import org.geotools.index.quadtree.Node;
import org.geotools.index.quadtree.StoreException;
import org.geotools.util.logging.Logging;

public class QuadTree {
    private static final double SPLITRATIO = 0.55;
    private static final Logger LOGGER = Logging.getLogger("org.geotools.index.quadtree");
    private Node root;
    private int maxDepth;
    private IndexFile indexfile;
    private Set iterators = new HashSet();

    public QuadTree(int n, int n2, Envelope envelope, IndexFile indexFile) {
        if (n2 > 65535) {
            throw new IllegalArgumentException("maxDepth must be <= 65535");
        }
        this.maxDepth = n2;
        if (envelope != null) {
            this.root = new Node(new Envelope(envelope));
        }
        if (n2 < 1) {
            int n3 = 1;
            this.maxDepth = 0;
            while (n3 * 4 < n) {
                ++this.maxDepth;
                n3 *= 2;
            }
        }
        this.indexfile = indexFile;
    }

    public QuadTree(int n, int n2, IndexFile indexFile) {
        this(n, n2, null, indexFile);
    }

    public void insert(int n, Envelope envelope) throws StoreException {
        this.insert(this.root, n, envelope, this.maxDepth);
    }

    public void insert(Node node, int n, Envelope envelope, int n2) throws StoreException {
        Node node2;
        if (n2 > 1 && node.getNumSubNodes() > 0) {
            node2 = null;
            for (int i = 0; i < node.getNumSubNodes(); ++i) {
                node2 = node.getSubNode(i);
                if (!node2.getBounds().contains(envelope)) continue;
                this.insert(node2, n, envelope, n2 - 1);
                return;
            }
        }
        if (n2 > 1 && node.getNumSubNodes() < 4) {
            Envelope[] envelopeArray = this.splitBounds(node.getBounds());
            node2 = envelopeArray[0];
            Envelope envelope2 = envelopeArray[1];
            envelopeArray = this.splitBounds((Envelope)node2);
            Envelope envelope3 = envelopeArray[0];
            Envelope envelope4 = envelopeArray[1];
            envelopeArray = this.splitBounds(envelope2);
            Envelope envelope5 = envelopeArray[0];
            Envelope envelope6 = envelopeArray[1];
            Node node3 = null;
            if (envelope3.contains(envelope)) {
                node3 = new Node(envelope3);
            } else if (envelope4.contains(envelope)) {
                node3 = new Node(envelope4);
            } else if (envelope5.contains(envelope)) {
                node3 = new Node(envelope5);
            } else if (envelope6.contains(envelope)) {
                node3 = new Node(envelope6);
            }
            if (node3 != null) {
                node.addSubNode(node3);
                this.insert(node3, n, envelope, n2 - 1);
                return;
            }
        }
        node.addShapeId(n);
    }

    public CloseableIterator<Data> search(Envelope envelope) throws StoreException {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Querying " + envelope);
        }
        try {
            return new LazySearchIterator(this, envelope);
        }
        catch (RuntimeException runtimeException) {
            LOGGER.warning("IOException occurred while reading root");
            return null;
        }
    }

    public void close(Iterator iterator) throws IOException {
        this.iterators.remove(iterator);
    }

    public boolean trim() throws StoreException {
        LOGGER.fine("Trimming the tree...");
        return this.trim(this.root);
    }

    private boolean trim(Node node) throws StoreException {
        int n;
        Node[] nodeArray = new Node[node.getNumSubNodes()];
        for (n = 0; n < node.getNumSubNodes(); ++n) {
            nodeArray[n] = node.getSubNode(n);
        }
        for (n = 0; n < nodeArray.length; ++n) {
            if (!this.trim(nodeArray[n])) continue;
            node.removeSubNode(nodeArray[n]);
        }
        if (node.getNumSubNodes() == 1 && node.getNumShapeIds() == 0) {
            Node node2 = node.getSubNode(0);
            node.clearSubNodes();
            for (int i = 0; i < node2.getNumSubNodes(); ++i) {
                node.addSubNode(node2.getSubNode(i));
            }
            node.setShapesId(node2.getShapesId());
            node.setBounds(node2.getBounds());
        }
        return node.getNumSubNodes() == 0 && node.getNumShapeIds() == 0;
    }

    private Envelope[] splitBounds(Envelope envelope) {
        Envelope[] envelopeArray = new Envelope[2];
        if (envelope.getMaxX() - envelope.getMinX() > envelope.getMaxY() - envelope.getMinY()) {
            double d = envelope.getMaxX() - envelope.getMinX();
            double d2 = envelope.getMinX() + d * 0.55;
            envelopeArray[0] = new Envelope(envelope.getMinX(), d2, envelope.getMinY(), envelope.getMaxY());
            d2 = envelope.getMaxX() - d * 0.55;
            envelopeArray[1] = new Envelope(d2, envelope.getMaxX(), envelope.getMinY(), envelope.getMaxY());
        } else {
            double d = envelope.getMaxY() - envelope.getMinY();
            double d3 = envelope.getMinY() + d * 0.55;
            envelopeArray[0] = new Envelope(envelope.getMinX(), envelope.getMaxX(), envelope.getMinY(), d3);
            d3 = envelope.getMaxY() - d * 0.55;
            envelopeArray[1] = new Envelope(envelope.getMinX(), envelope.getMaxX(), d3, envelope.getMaxY());
        }
        return envelopeArray;
    }

    public Node getRoot() {
        return this.root;
    }

    public void setRoot(Node node) {
        this.root = node;
    }

    public void close() throws StoreException {
        try {
            this.indexfile.close();
            this.root.close();
        }
        catch (IOException iOException) {
            throw new StoreException("error closing indexfile", iOException.getCause());
        }
        if (!this.iterators.isEmpty()) {
            throw new StoreException("There are still open iterators!!");
        }
    }

    public void registerIterator(Iterator iterator) {
        this.iterators.add(iterator);
    }

    public IndexFile getIndexfile() {
        return this.indexfile;
    }
}

