/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.index.quadtree;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geotools.data.shapefile.shp.IndexFile;
import org.geotools.index.CloseableIterator;
import org.geotools.index.Data;
import org.geotools.index.DataDefinition;
import org.geotools.index.quadtree.Node;
import org.geotools.index.quadtree.QuadTree;

public class LazySearchIterator
implements CloseableIterator<Data> {
    static final DataDefinition DATA_DEFINITION = new DataDefinition("US-ASCII");
    private static final int MAX_INDICES = 32768;
    Data next = null;
    Node current;
    int idIndex = 0;
    private boolean closed;
    private Envelope bounds;
    Iterator data;
    private IndexFile indexfile;
    ArrayList<Node> parents = new ArrayList();
    Indices indices = new Indices();
    QuadTree tree;

    public LazySearchIterator(QuadTree quadTree, Envelope envelope) {
        this.tree = quadTree;
        this.indexfile = quadTree.getIndexfile();
        quadTree.registerIterator(this);
        this.current = quadTree.getRoot();
        this.bounds = envelope;
        this.closed = false;
        this.next = null;
    }

    @Override
    public boolean hasNext() {
        if (this.closed) {
            throw new IllegalStateException("Iterator has been closed!");
        }
        if (this.next != null) {
            return true;
        }
        if (this.data != null && this.data.hasNext()) {
            this.next = (Data)this.data.next();
        } else {
            this.data = null;
            this.fillCache();
            if (this.data != null && this.data.hasNext()) {
                this.next = (Data)this.data.next();
            }
        }
        return this.next != null;
    }

    private void fillCache() {
        this.indices.clear();
        ArrayList<Data> arrayList = null;
        try {
            int n;
            int n2;
            while (this.indices.size() < 32768 && this.current != null) {
                if (this.idIndex < this.current.getNumShapeIds() && !this.current.isVisited() && this.current.getBounds().intersects(this.bounds)) {
                    this.indices.add(this.current.getShapeId(this.idIndex));
                    ++this.idIndex;
                    continue;
                }
                this.current.setShapesId(new int[0]);
                this.idIndex = 0;
                n2 = 0;
                for (n = 0; n < this.current.getNumSubNodes(); ++n) {
                    Node node = this.current.getSubNode(n);
                    if (node.isVisited() || !node.getBounds().intersects(this.bounds)) continue;
                    n2 = 1;
                    this.parents.add(this.current);
                    this.current = node;
                    break;
                }
                if (n2 != 0) continue;
                this.current.setVisited(true);
                this.current.clean();
                if (this.parents.isEmpty()) {
                    this.current = null;
                    continue;
                }
                this.current = this.parents.remove(this.parents.size() - 1);
            }
            this.indices.sort();
            n2 = this.indices.size();
            arrayList = new ArrayList<Data>(n2);
            for (n = 0; n < n2; ++n) {
                int n3 = this.indices.get(n);
                Data data = new Data(DATA_DEFINITION);
                data.addValue(n3 + 1);
                data.addValue(new Long(this.indexfile.getOffsetInBytes(n3)));
                arrayList.add(data);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.data = arrayList.iterator();
    }

    @Override
    public Data next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements available");
        }
        Data data = this.next;
        this.next = null;
        return data;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        this.tree.close(this);
        this.tree.close();
        this.closed = true;
    }

    static {
        DATA_DEFINITION.addField(Integer.class);
        DATA_DEFINITION.addField(Long.class);
    }

    class Indices {
        int curr = -1;
        int[] indices = new int[100];

        int size() {
            return this.curr + 1;
        }

        void add(int n) {
            ++this.curr;
            if (this.curr * 2 + 1 >= this.indices.length) {
                int n2 = this.indices.length * 3 / 2;
                if (n2 < 10) {
                    n2 = 10;
                }
                int[] nArray = new int[n2];
                System.arraycopy(this.indices, 0, nArray, 0, this.indices.length);
                this.indices = nArray;
            }
            this.indices[this.curr] = n;
        }

        void clear() {
            this.curr = -1;
        }

        int get(int n) {
            return this.indices[n];
        }

        void sort() {
            Arrays.sort(this.indices, 0, this.curr + 1);
        }
    }
}

