/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry;

import java.io.Serializable;
import java.util.Arrays;
import org.geotools.geometry.AbstractDirectPosition;
import org.geotools.geometry.AbstractEnvelope;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.referencing.CRS;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Utilities;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.MismatchedReferenceSystemException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.Cloneable;

public class GeneralEnvelope
extends AbstractEnvelope
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1752330560227688940L;
    private double[] ordinates;
    private CoordinateReferenceSystem crs;

    public GeneralEnvelope(double[] dArray, double[] dArray2) throws IllegalArgumentException {
        GeneralEnvelope.ensureNonNull("minDP", dArray);
        GeneralEnvelope.ensureNonNull("maxDP", dArray2);
        GeneralEnvelope.ensureSameDimension(dArray.length, dArray2.length);
        this.ordinates = new double[dArray.length + dArray2.length];
        System.arraycopy(dArray, 0, this.ordinates, 0, dArray.length);
        System.arraycopy(dArray2, 0, this.ordinates, dArray.length, dArray2.length);
        GeneralEnvelope.checkCoordinates(this.ordinates);
    }

    public GeneralEnvelope(GeneralDirectPosition generalDirectPosition, GeneralDirectPosition generalDirectPosition2) throws MismatchedReferenceSystemException, IllegalArgumentException {
        this(generalDirectPosition.ordinates, generalDirectPosition2.ordinates);
        this.crs = GeneralEnvelope.getCoordinateReferenceSystem(generalDirectPosition, generalDirectPosition2);
        AbstractDirectPosition.checkCoordinateReferenceSystemDimension(this.crs, this.ordinates.length / 2);
    }

    public GeneralEnvelope(Envelope envelope) {
        GeneralEnvelope.ensureNonNull("envelope", envelope);
        if (envelope instanceof GeneralEnvelope) {
            GeneralEnvelope generalEnvelope = (GeneralEnvelope)envelope;
            this.ordinates = (double[])generalEnvelope.ordinates.clone();
            this.crs = generalEnvelope.crs;
        } else {
            this.crs = envelope.getCoordinateReferenceSystem();
            int n = envelope.getDimension();
            this.ordinates = new double[2 * n];
            for (int i = 0; i < n; ++i) {
                this.ordinates[i] = envelope.getMinimum(i);
                this.ordinates[i + n] = envelope.getMaximum(i);
            }
            GeneralEnvelope.checkCoordinates(this.ordinates);
        }
    }

    private static void ensureNonNull(String string, Object object) throws IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException(Errors.format(143, string));
        }
    }

    private static void ensureSameDimension(int n, int n2) throws MismatchedDimensionException {
        if (n != n2) {
            throw new MismatchedDimensionException(Errors.format(93, n, n2));
        }
    }

    private static void checkCoordinates(double[] dArray) throws IllegalArgumentException {
        if (GeneralEnvelope.isNilCoordinates(dArray)) {
            return;
        }
        if (GeneralEnvelope.isEmptyOrdinates(dArray)) {
            return;
        }
        int n = dArray.length / 2;
        for (int i = 0; i < n; ++i) {
            if (dArray[i] <= dArray[n + i]) continue;
            throw new IllegalArgumentException(Errors.format(66, i));
        }
    }

    @Override
    public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
        assert (this.crs == null || this.crs.getCoordinateSystem().getDimension() == this.getDimension());
        return this.crs;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem coordinateReferenceSystem) throws MismatchedDimensionException {
        AbstractDirectPosition.checkCoordinateReferenceSystemDimension(coordinateReferenceSystem, this.getDimension());
        this.crs = coordinateReferenceSystem;
    }

    @Override
    public final int getDimension() {
        return this.ordinates.length / 2;
    }

    @Override
    public DirectPosition getLowerCorner() {
        int n = this.ordinates.length / 2;
        GeneralDirectPosition generalDirectPosition = new GeneralDirectPosition(n);
        System.arraycopy(this.ordinates, 0, generalDirectPosition.ordinates, 0, n);
        generalDirectPosition.setCoordinateReferenceSystem(this.crs);
        return generalDirectPosition;
    }

    @Override
    public DirectPosition getUpperCorner() {
        int n = this.ordinates.length / 2;
        GeneralDirectPosition generalDirectPosition = new GeneralDirectPosition(n);
        System.arraycopy(this.ordinates, n, generalDirectPosition.ordinates, 0, n);
        generalDirectPosition.setCoordinateReferenceSystem(this.crs);
        return generalDirectPosition;
    }

    private static IndexOutOfBoundsException indexOutOfBounds(int n) {
        return new IndexOutOfBoundsException(Errors.format(79, n));
    }

    @Override
    public final double getMinimum(int n) throws IndexOutOfBoundsException {
        if (n < this.ordinates.length / 2) {
            return this.ordinates[n];
        }
        throw GeneralEnvelope.indexOutOfBounds(n);
    }

    @Override
    public final double getMaximum(int n) throws IndexOutOfBoundsException {
        if (n >= 0) {
            return this.ordinates[n + this.ordinates.length / 2];
        }
        throw GeneralEnvelope.indexOutOfBounds(n);
    }

    @Override
    @Deprecated
    public final double getCenter(int n) {
        return this.getMedian(n);
    }

    @Override
    public final double getMedian(int n) throws IndexOutOfBoundsException {
        return 0.5 * (this.ordinates[n] + this.ordinates[n + this.ordinates.length / 2]);
    }

    @Override
    @Deprecated
    public final double getLength(int n) {
        return this.getSpan(n);
    }

    @Override
    public final double getSpan(int n) throws IndexOutOfBoundsException {
        return this.ordinates[n + this.ordinates.length / 2] - this.ordinates[n];
    }

    public boolean isNull() {
        if (!GeneralEnvelope.isNilCoordinates(this.ordinates)) {
            return false;
        }
        assert (this.isEmpty()) : this;
        return true;
    }

    private static boolean isNilCoordinates(double[] dArray) throws IllegalArgumentException {
        for (int i = 0; i < dArray.length; ++i) {
            if (Double.isNaN(dArray[i])) continue;
            return false;
        }
        return true;
    }

    public boolean isEmpty() {
        if (GeneralEnvelope.isEmptyOrdinates(this.ordinates)) {
            return true;
        }
        assert (!this.isNull()) : this;
        return false;
    }

    private static boolean isEmptyOrdinates(double[] dArray) {
        int n = dArray.length / 2;
        if (n == 0) {
            return true;
        }
        for (int i = 0; i < n; ++i) {
            if (dArray[i] < dArray[i + n]) continue;
            return true;
        }
        return false;
    }

    private static boolean equalsIgnoreMetadata(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) {
        return coordinateReferenceSystem == null || coordinateReferenceSystem2 == null || CRS.equalsIgnoreMetadata(coordinateReferenceSystem, coordinateReferenceSystem2);
    }

    public void add(DirectPosition directPosition) throws MismatchedDimensionException {
        GeneralEnvelope.ensureNonNull("position", directPosition);
        int n = this.ordinates.length / 2;
        AbstractDirectPosition.ensureDimensionMatch("position", directPosition.getDimension(), n);
        assert (GeneralEnvelope.equalsIgnoreMetadata(this.crs, directPosition.getCoordinateReferenceSystem())) : directPosition;
        for (int i = 0; i < n; ++i) {
            double d = directPosition.getOrdinate(i);
            if (d < this.ordinates[i]) {
                this.ordinates[i] = d;
            }
            if (!(d > this.ordinates[i + n])) continue;
            this.ordinates[i + n] = d;
        }
        assert (this.isEmpty() || this.contains(directPosition));
    }

    public boolean contains(DirectPosition directPosition) throws MismatchedDimensionException {
        GeneralEnvelope.ensureNonNull("position", directPosition);
        int n = this.ordinates.length / 2;
        AbstractDirectPosition.ensureDimensionMatch("point", directPosition.getDimension(), n);
        assert (GeneralEnvelope.equalsIgnoreMetadata(this.crs, directPosition.getCoordinateReferenceSystem())) : directPosition;
        for (int i = 0; i < n; ++i) {
            double d = directPosition.getOrdinate(i);
            if (!(d >= this.ordinates[i])) {
                return false;
            }
            if (d <= this.ordinates[i + n]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n = Arrays.hashCode(this.ordinates);
        if (this.crs != null) {
            n += this.crs.hashCode();
        }
        assert (n == super.hashCode());
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            GeneralEnvelope generalEnvelope = (GeneralEnvelope)object;
            return Arrays.equals(this.ordinates, generalEnvelope.ordinates) && Utilities.equals(this.crs, generalEnvelope.crs);
        }
        return false;
    }

    @Override
    public GeneralEnvelope clone() {
        try {
            GeneralEnvelope generalEnvelope = (GeneralEnvelope)super.clone();
            generalEnvelope.ordinates = (double[])generalEnvelope.ordinates.clone();
            return generalEnvelope;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }
}

