/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry;

import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.Arrays;
import org.geotools.geometry.AbstractDirectPosition;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.Cloneable;

public class GeneralDirectPosition
extends AbstractDirectPosition
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 9071833698385715524L;
    public final double[] ordinates;
    private CoordinateReferenceSystem crs;

    public GeneralDirectPosition(int n) throws NegativeArraySizeException {
        this.ordinates = new double[n];
    }

    public GeneralDirectPosition(double[] dArray) {
        this.ordinates = (double[])dArray.clone();
    }

    public GeneralDirectPosition(double d, double d2) {
        this.ordinates = new double[]{d, d2};
    }

    public GeneralDirectPosition(Point2D point2D) {
        this(point2D.getX(), point2D.getY());
    }

    public GeneralDirectPosition(DirectPosition directPosition) {
        this.ordinates = directPosition.getCoordinate();
        this.crs = directPosition.getCoordinateReferenceSystem();
    }

    @Override
    public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem coordinateReferenceSystem) throws MismatchedDimensionException {
        GeneralDirectPosition.checkCoordinateReferenceSystemDimension(coordinateReferenceSystem, this.getDimension());
        this.crs = coordinateReferenceSystem;
    }

    @Override
    public final int getDimension() {
        return this.ordinates.length;
    }

    @Override
    public final double[] getCoordinate() {
        return (double[])this.ordinates.clone();
    }

    @Override
    public final double getOrdinate(int n) throws IndexOutOfBoundsException {
        return this.ordinates[n];
    }

    @Override
    public final void setOrdinate(int n, double d) throws IndexOutOfBoundsException {
        this.ordinates[n] = d;
    }

    @Override
    public int hashCode() {
        int n = Arrays.hashCode(this.ordinates);
        if (this.crs != null) {
            n += this.crs.hashCode();
        }
        assert (n == super.hashCode());
        return n;
    }

    @Override
    public GeneralDirectPosition clone() {
        return new GeneralDirectPosition(this.ordinates);
    }
}

