/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.visitor;

import java.util.ArrayList;
import java.util.List;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.opengis.filter.And;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.NilExpression;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;

public class DuplicatingFilterVisitor
implements FilterVisitor,
ExpressionVisitor {
    protected final FilterFactory2 ff;

    public DuplicatingFilterVisitor() {
        this(CommonFactoryFinder.getFilterFactory2(GeoTools.getDefaultHints()));
    }

    public DuplicatingFilterVisitor(FilterFactory2 filterFactory2) {
        this.ff = filterFactory2;
    }

    protected FilterFactory2 getFactory(Object object) {
        if (object instanceof FilterFactory2) {
            return (FilterFactory2)object;
        }
        return this.ff;
    }

    @Override
    public Object visit(ExcludeFilter excludeFilter, Object object) {
        return excludeFilter;
    }

    @Override
    public Object visit(IncludeFilter includeFilter, Object object) {
        return includeFilter;
    }

    Expression visit(Expression expression, Object object) {
        if (expression == null) {
            return null;
        }
        return (Expression)expression.accept(this, object);
    }

    @Override
    public Object visit(And and, Object object) {
        List<Filter> list = and.getChildren();
        ArrayList<Filter> arrayList = new ArrayList<Filter>();
        for (Filter filter : list) {
            if (filter == null) continue;
            arrayList.add((Filter)filter.accept(this, object));
        }
        return this.getFactory(object).and(arrayList);
    }

    @Override
    public Object visit(Id id, Object object) {
        return this.getFactory(object).id(id.getIdentifiers());
    }

    @Override
    public Object visit(Not not, Object object) {
        return this.getFactory(object).not((Filter)not.getFilter().accept(this, object));
    }

    @Override
    public Object visit(Or or, Object object) {
        List<Filter> list = or.getChildren();
        ArrayList<Filter> arrayList = new ArrayList<Filter>();
        for (Filter filter : list) {
            if (filter == null) continue;
            arrayList.add((Filter)filter.accept(this, object));
        }
        return this.getFactory(object).or(arrayList);
    }

    @Override
    public Object visit(NilExpression nilExpression, Object object) {
        return nilExpression;
    }

    @Override
    public Object visit(Add add, Object object) {
        Expression expression = this.visit(add.getExpression1(), object);
        Expression expression2 = this.visit(add.getExpression2(), object);
        return this.getFactory(object).add(expression, expression2);
    }

    @Override
    public Object visit(Divide divide, Object object) {
        Expression expression = this.visit(divide.getExpression1(), object);
        Expression expression2 = this.visit(divide.getExpression2(), object);
        return this.getFactory(object).divide(expression, expression2);
    }

    @Override
    public Object visit(Function function, Object object) {
        List<Expression> list = function.getParameters();
        Expression[] expressionArray = new Expression[list.size()];
        int n = 0;
        for (Expression expression : list) {
            expressionArray[n] = this.visit(expression, object);
            ++n;
        }
        return this.getFactory(object).function(function.getName(), expressionArray);
    }

    @Override
    public Object visit(Literal literal, Object object) {
        return this.getFactory(object).literal(literal.getValue());
    }

    @Override
    public Object visit(Multiply multiply, Object object) {
        Expression expression = this.visit(multiply.getExpression1(), object);
        Expression expression2 = this.visit(multiply.getExpression2(), object);
        return this.getFactory(object).multiply(expression, expression2);
    }

    @Override
    public Object visit(PropertyName propertyName, Object object) {
        return this.getFactory(object).property(propertyName.getPropertyName(), propertyName.getNamespaceContext());
    }

    @Override
    public Object visit(Subtract subtract, Object object) {
        Expression expression = this.visit(subtract.getExpression1(), object);
        Expression expression2 = this.visit(subtract.getExpression2(), object);
        return this.getFactory(object).subtract(expression, expression2);
    }
}

