/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.Envelope;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.factory.Hints;
import org.geotools.filter.AndImpl;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.BBoxExpression;
import org.geotools.filter.BBoxExpressionImpl;
import org.geotools.filter.FidFilterImpl;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterFactory;
import org.geotools.filter.FunctionFinder;
import org.geotools.filter.IllegalFilterException;
import org.geotools.filter.LiteralExpressionImpl;
import org.geotools.filter.NotImpl;
import org.geotools.filter.OrImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.filter.expression.AddImpl;
import org.geotools.filter.expression.DivideImpl;
import org.geotools.filter.expression.MultiplyImpl;
import org.geotools.filter.expression.SubtractImpl;
import org.geotools.filter.identity.FeatureIdImpl;
import org.opengis.filter.And;
import org.opengis.filter.Id;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.capability.FunctionName;
import org.opengis.filter.expression.Add;
import org.opengis.filter.expression.Divide;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.filter.expression.Multiply;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.expression.Subtract;
import org.opengis.filter.identity.FeatureId;
import org.xml.sax.helpers.NamespaceSupport;

public class FilterFactoryImpl
implements FilterFactory {
    private FunctionFinder functionFinder = new FunctionFinder(null);

    public FilterFactoryImpl() {
        this(null);
    }

    public FilterFactoryImpl(Hints hints) {
    }

    @Override
    public FeatureId featureId(String string) {
        return new FeatureIdImpl(string);
    }

    @Override
    public And and(org.opengis.filter.Filter filter, org.opengis.filter.Filter filter2) {
        ArrayList<org.opengis.filter.Filter> arrayList = new ArrayList<org.opengis.filter.Filter>(2);
        arrayList.add(filter);
        arrayList.add(filter2);
        return new AndImpl(this, arrayList);
    }

    public And and(List list) {
        return new AndImpl(this, list);
    }

    @Override
    public Or or(org.opengis.filter.Filter filter, org.opengis.filter.Filter filter2) {
        ArrayList<org.opengis.filter.Filter> arrayList = new ArrayList<org.opengis.filter.Filter>(2);
        arrayList.add(filter);
        arrayList.add(filter2);
        return new OrImpl(this, arrayList);
    }

    public Or or(List list) {
        return new OrImpl(this, list);
    }

    @Override
    public Not not(org.opengis.filter.Filter filter) {
        return new NotImpl((org.opengis.filter.FilterFactory)this, filter);
    }

    public Id id(Set set) {
        return new FidFilterImpl(set);
    }

    @Override
    public PropertyName property(String string) {
        return new AttributeExpressionImpl(string);
    }

    @Override
    public Add add(Expression expression, Expression expression2) {
        return new AddImpl(expression, expression2);
    }

    @Override
    public Divide divide(Expression expression, Expression expression2) {
        return new DivideImpl(expression, expression2);
    }

    @Override
    public Multiply multiply(Expression expression, Expression expression2) {
        return new MultiplyImpl(expression, expression2);
    }

    @Override
    public Subtract subtract(Expression expression, Expression expression2) {
        return new SubtractImpl(expression, expression2);
    }

    @Override
    public Function function(String string, Expression[] expressionArray) {
        Function function = this.functionFinder.findFunction(string, Arrays.asList(expressionArray));
        return function;
    }

    @Override
    public Literal literal(Object object) {
        try {
            return new LiteralExpressionImpl(object);
        }
        catch (IllegalFilterException illegalFilterException) {
            new IllegalArgumentException().initCause(illegalFilterException);
            return null;
        }
    }

    public BBoxExpression createBBoxExpression(Envelope envelope) throws IllegalFilterException {
        return new BBoxExpressionImpl(envelope);
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }

    @Override
    public Filter and(Filter filter, Filter filter2) {
        return (Filter)((Object)this.and((org.opengis.filter.Filter)filter, (org.opengis.filter.Filter)filter2));
    }

    @Override
    public Filter not(Filter filter) {
        return (Filter)((Object)this.not((org.opengis.filter.Filter)filter));
    }

    @Override
    public Filter or(Filter filter, Filter filter2) {
        return (Filter)((Object)this.or((org.opengis.filter.Filter)filter, (org.opengis.filter.Filter)filter2));
    }

    @Override
    public PropertyName property(String string, NamespaceSupport namespaceSupport) {
        if (namespaceSupport == null) {
            return this.property(string);
        }
        return new AttributeExpressionImpl(string, namespaceSupport);
    }

    @Override
    public FunctionName functionName(String string, int n) {
        return new FunctionNameImpl(string, n);
    }
}

