/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.geotools.filter.visitor.DefaultFilterVisitor;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.expression.PropertyName;

public class FilterAttributeExtractor
extends DefaultFilterVisitor {
    protected Set<String> attributeNames = new HashSet<String>();
    protected SimpleFeatureType featureType;

    public FilterAttributeExtractor() {
        this(null);
    }

    public FilterAttributeExtractor(SimpleFeatureType simpleFeatureType) {
        this.featureType = simpleFeatureType;
    }

    public Set<String> getAttributeNameSet() {
        return Collections.unmodifiableSet(this.attributeNames);
    }

    public String[] getAttributeNames() {
        return this.attributeNames.toArray(new String[this.attributeNames.size()]);
    }

    @Override
    public Object visit(PropertyName propertyName, Object object) {
        if (object != null && object != this.attributeNames) {
            this.attributeNames = (Set)object;
        }
        if (this.featureType != null) {
            AttributeDescriptor attributeDescriptor = (AttributeDescriptor)propertyName.evaluate(this.featureType);
            if (attributeDescriptor != null) {
                this.attributeNames.add(attributeDescriptor.getLocalName());
            } else {
                this.attributeNames.add(propertyName.getPropertyName());
            }
        } else {
            this.attributeNames.add(propertyName.getPropertyName());
        }
        return this.attributeNames;
    }
}

