/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.factory.Hints;
import org.geotools.filter.AttributeExpression;
import org.geotools.filter.DefaultExpression;
import org.geotools.filter.expression.PropertyAccessor;
import org.geotools.filter.expression.PropertyAccessorFactory;
import org.geotools.filter.expression.PropertyAccessors;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.expression.ExpressionVisitor;
import org.xml.sax.helpers.NamespaceSupport;

public class AttributeExpressionImpl
extends DefaultExpression
implements AttributeExpression {
    private static final Logger LOGGER = Logging.getLogger("org.geotools.core");
    protected String attPath;
    protected SimpleFeatureType schema = null;
    NamespaceSupport namespaceSupport;
    protected boolean lenient = true;
    private Hints hints;
    private PropertyAccessor lastAccessor;

    public AttributeExpressionImpl(String string) {
        this.attPath = string;
        this.schema = null;
        this.namespaceSupport = null;
        this.hints = null;
        this.expressionType = (short)113;
    }

    public AttributeExpressionImpl(String string, NamespaceSupport namespaceSupport) {
        this.attPath = string;
        this.schema = null;
        this.namespaceSupport = namespaceSupport;
        this.expressionType = (short)113;
    }

    @Override
    public NamespaceSupport getNamespaceContext() {
        return this.namespaceSupport;
    }

    @Override
    public final String getAttributePath() {
        return this.getPropertyName();
    }

    @Override
    public String getPropertyName() {
        return this.attPath;
    }

    @Override
    public Object evaluate(SimpleFeature simpleFeature) {
        return this.evaluate((Object)simpleFeature, (Class)null);
    }

    @Override
    public Object evaluate(Object object) {
        return this.evaluate(object, (Class)null);
    }

    @Override
    public Object evaluate(Object object, Class clazz) {
        PropertyAccessor propertyAccessor = this.getLastPropertyAccessor();
        AtomicReference<Object> atomicReference = new AtomicReference<Object>();
        AtomicReference<Exception> atomicReference2 = new AtomicReference<Exception>();
        if (propertyAccessor == null || !propertyAccessor.canHandle(object, this.attPath, clazz) || !this.tryAccessor(propertyAccessor, object, clazz, atomicReference, atomicReference2)) {
            List<PropertyAccessor> list;
            boolean bl = false;
            if (this.namespaceSupport != null && this.hints == null) {
                this.hints = new Hints(PropertyAccessorFactory.NAMESPACE_CONTEXT, this.namespaceSupport);
            }
            if ((list = PropertyAccessors.findPropertyAccessors(object, this.attPath, clazz, this.hints)) != null) {
                Iterator<PropertyAccessor> iterator = list.iterator();
                while (!bl && iterator.hasNext()) {
                    propertyAccessor = iterator.next();
                    bl = this.tryAccessor(propertyAccessor, object, clazz, atomicReference, atomicReference2);
                }
            }
            if (!bl) {
                if (this.lenient) {
                    return null;
                }
                throw new IllegalArgumentException("Could not find working property accessor for attribute (" + this.attPath + ") in object (" + object + ")", atomicReference2.get());
            }
            this.setLastPropertyAccessor(propertyAccessor);
        }
        if (clazz == null) {
            return atomicReference.get();
        }
        return Converters.convert(atomicReference.get(), clazz);
    }

    private boolean tryAccessor(PropertyAccessor propertyAccessor, Object object, Class clazz, AtomicReference<Object> atomicReference, AtomicReference<Exception> atomicReference2) {
        try {
            atomicReference.set(propertyAccessor.get(object, this.attPath, clazz));
            return true;
        }
        catch (Exception exception) {
            atomicReference2.set(exception);
            return false;
        }
    }

    private synchronized PropertyAccessor getLastPropertyAccessor() {
        return this.lastAccessor;
    }

    private synchronized void setLastPropertyAccessor(PropertyAccessor propertyAccessor) {
        this.lastAccessor = propertyAccessor;
    }

    public String toString() {
        return this.attPath;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() == this.getClass()) {
            boolean bl;
            AttributeExpressionImpl attributeExpressionImpl = (AttributeExpressionImpl)object;
            boolean bl2 = bl = attributeExpressionImpl.getType() == this.expressionType;
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("expression type match:" + bl + "; in:" + attributeExpressionImpl.getType() + "; out:" + this.expressionType);
            }
            boolean bl3 = attributeExpressionImpl.attPath != null ? bl && attributeExpressionImpl.attPath.equals(this.attPath) : (bl = bl && this.attPath == null);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("attribute match:" + bl + "; in:" + attributeExpressionImpl.getAttributePath() + "; out:" + this.attPath);
            }
            boolean bl4 = attributeExpressionImpl.schema != null ? bl && attributeExpressionImpl.schema.equals(this.schema) : (bl = bl && this.schema == null);
            if (LOGGER.isLoggable(Level.FINEST)) {
                LOGGER.finest("schema match:" + bl + "; in:" + attributeExpressionImpl.schema + "; out:" + this.schema);
            }
            return bl;
        }
        return false;
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + (this.attPath == null ? 0 : this.attPath.hashCode());
        n = 37 * n + (this.schema == null ? 0 : this.schema.hashCode());
        return n;
    }

    @Override
    public Object accept(ExpressionVisitor expressionVisitor, Object object) {
        return expressionVisitor.visit(this, object);
    }
}

