/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import org.geotools.feature.PropertyImpl;
import org.geotools.feature.type.Types;
import org.geotools.util.Converters;
import org.geotools.util.Utilities;
import org.opengis.feature.Attribute;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.filter.identity.Identifier;

public class AttributeImpl
extends PropertyImpl
implements Attribute {
    protected Identifier id = null;

    public AttributeImpl(Object object, AttributeDescriptor attributeDescriptor, Identifier identifier) {
        super(object, attributeDescriptor);
        this.id = identifier;
    }

    @Override
    public Identifier getIdentifier() {
        return this.id;
    }

    @Override
    public AttributeDescriptor getDescriptor() {
        return (AttributeDescriptor)super.getDescriptor();
    }

    @Override
    public AttributeType getType() {
        return (AttributeType)super.getType();
    }

    @Override
    public void setValue(Object object) throws IllegalArgumentException, IllegalStateException {
        object = this.parse(object);
        super.setValue(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + 37 * (this.id == null ? 0 : ((Object)this.id).hashCode());
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Attribute)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        Attribute attribute = (Attribute)object;
        return Utilities.equals(this.id, attribute.getIdentifier());
    }

    @Override
    public void validate() {
        Types.validate(this, this.getValue());
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getSimpleName()).append(":");
        stringBuffer.append(this.getDescriptor().getName().getLocalPart());
        if (!this.getDescriptor().getName().getLocalPart().equals(this.getDescriptor().getType().getName().getLocalPart()) || this.id != null) {
            stringBuffer.append("<");
            stringBuffer.append(this.getDescriptor().getType().getName().getLocalPart());
            if (this.id != null) {
                stringBuffer.append(" id=");
                stringBuffer.append(this.id);
            }
            stringBuffer.append(">");
        }
        stringBuffer.append("=");
        stringBuffer.append(this.value);
        return stringBuffer.toString();
    }

    protected Object parse(Object object) throws IllegalArgumentException {
        Object obj;
        Class<?> clazz;
        if (object != null && !(clazz = this.getType().getBinding()).isAssignableFrom(object.getClass()) && (obj = Converters.convert(object, clazz)) != null) {
            object = obj;
        }
        return object;
    }
}

