/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.factory;

import java.awt.RenderingHints;
import java.lang.ref.Reference;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.imageio.spi.ServiceRegistry;
import org.geotools.factory.Factory;
import org.geotools.factory.FactoryIteratorProvider;
import org.geotools.factory.FactoryIteratorProviders;
import org.geotools.factory.FactoryNotFoundException;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.factory.Hints;
import org.geotools.factory.OptionalFactory;
import org.geotools.factory.RecursionCheckingHelper;
import org.geotools.factory.RecursiveSearchException;
import org.geotools.resources.Classes;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Loggings;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;

public class FactoryRegistry
extends ServiceRegistry {
    protected static final Logger LOGGER = Logging.getLogger("org.geotools.factory");
    private static final Level DEBUG_LEVEL = Level.FINEST;
    private final FactoryIteratorProviders globalConfiguration = new FactoryIteratorProviders();
    private Set<Class<?>> needScanForPlugins;
    private final RecursionCheckingHelper scanningCategories = new RecursionCheckingHelper();
    private final RecursionCheckingHelper testingAvailability = new RecursionCheckingHelper();
    private final RecursionCheckingHelper testingHints = new RecursionCheckingHelper();

    public FactoryRegistry(Class<?>[] classArray) {
        this(Arrays.asList(classArray));
    }

    public FactoryRegistry(Collection<Class<?>> collection) {
        super(collection.iterator());
        Iterator<Class<?>> iterator = this.getCategories();
        while (iterator.hasNext()) {
            if (this.needScanForPlugins == null) {
                this.needScanForPlugins = new HashSet();
            }
            this.needScanForPlugins.add(iterator.next());
        }
    }

    public synchronized <T> Iterator<T> getServiceProviders(final Class<T> clazz, final ServiceRegistry.Filter filter, final Hints hints) {
        if (this.scanningCategories.contains(clazz)) {
            throw new RecursiveSearchException(clazz);
        }
        ServiceRegistry.Filter filter2 = new ServiceRegistry.Filter(){

            @Override
            public boolean filter(Object object) {
                return FactoryRegistry.this.isAcceptable(clazz.cast(object), clazz, hints, filter);
            }
        };
        this.synchronizeIteratorProviders();
        this.scanForPluginsIfNeeded(clazz);
        return this.getServiceProviders(clazz, filter2, true);
    }

    final <T> Iterator<T> getUnfilteredProviders(Class<T> clazz) {
        if (this.scanningCategories.contains(clazz)) {
            throw new RecursiveSearchException(clazz);
        }
        this.scanForPluginsIfNeeded(clazz);
        return this.getServiceProviders(clazz, true);
    }

    public <T> T getServiceProvider(Class<T> clazz, ServiceRegistry.Filter filter, Hints hints, Hints.Key key) throws FactoryRegistryException {
        Class<Object> clazz2;
        this.synchronizeIteratorProviders();
        boolean bl = LOGGER.isLoggable(DEBUG_LEVEL);
        if (bl) {
            FactoryRegistry.debug("ENTRY", clazz, key, null, null);
        }
        Class clazz3 = null;
        if (key != null) {
            Object object;
            clazz2 = key.getValueClass();
            if (!clazz.isAssignableFrom(clazz2)) {
                if (bl) {
                    FactoryRegistry.debug("THROW", clazz, key, "unexpected type:", clazz2);
                }
                throw new IllegalArgumentException(Errors.format(69, key));
            }
            if (hints != null && (object = hints.get(key)) != null) {
                if (bl) {
                    FactoryRegistry.debug("CHECK", clazz, key, "user provided a", object.getClass());
                }
                if (clazz.isInstance(object)) {
                    if (bl) {
                        FactoryRegistry.debug("RETURN", clazz, key, "return hint as provided.", null);
                    }
                    return clazz.cast(object);
                }
                if ((hints = new Hints(hints)).remove(key) != object) {
                    throw new AssertionError(key);
                }
                if (object instanceof Class[]) {
                    Class[] classArray = (Class[])object;
                    int n = classArray.length;
                    for (int i = 0; i < n - 1; ++i) {
                        T t;
                        Class clazz4 = classArray[i];
                        if (bl) {
                            FactoryRegistry.debug("CHECK", clazz, key, "consider hint[" + i + ']', clazz4);
                        }
                        if ((t = this.getServiceImplementation(clazz, clazz4, filter, hints)) == null) continue;
                        if (bl) {
                            FactoryRegistry.debug("RETURN", clazz, key, "found implementation", t.getClass());
                        }
                        return t;
                    }
                    if (n != 0) {
                        clazz3 = classArray[n - 1];
                    }
                } else {
                    clazz3 = (Class)object;
                }
            }
        }
        if (bl && clazz3 != null) {
            FactoryRegistry.debug("CHECK", clazz, key, "consider hint[last]", clazz3);
        }
        if ((clazz2 = this.getServiceImplementation(clazz, clazz3, filter, hints)) != null) {
            if (bl) {
                FactoryRegistry.debug("RETURN", clazz, key, "found implementation", clazz2.getClass());
            }
            return (T)clazz2;
        }
        if (bl) {
            FactoryRegistry.debug("THROW", clazz, key, "could not find implementation.", null);
        }
        throw new FactoryNotFoundException(Errors.format(49, clazz3 != null ? clazz3 : clazz));
    }

    private static void debug(String string, Class<?> clazz, Hints.Key key, String string2, Class clazz2) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(Utilities.spaces(Math.max(1, 7 - string.length()))).append('(').append(Classes.getShortName(clazz));
        if (key != null) {
            stringBuilder.append(", ").append(key);
        }
        stringBuilder.append(')');
        if (string2 != null) {
            stringBuilder.append(": ").append(string2);
        }
        if (clazz2 != null) {
            stringBuilder.append(' ').append(Classes.getShortName(clazz2)).append('.');
        }
        LogRecord logRecord = new LogRecord(DEBUG_LEVEL, stringBuilder.toString());
        logRecord.setSourceClassName(FactoryRegistry.class.getName());
        logRecord.setSourceMethodName("getServiceProvider");
        logRecord.setLoggerName(LOGGER.getName());
        LOGGER.log(logRecord);
    }

    private <T> T getServiceImplementation(Class<T> clazz, Class<?> clazz2, ServiceRegistry.Filter filter, Hints hints) {
        Object object;
        List<Reference<T>> list = this.getUnfilteredProviders(clazz);
        while (list.hasNext()) {
            object = list.next();
            if (clazz2 != null && !clazz2.isInstance(object) || !this.isAcceptable(object, clazz, hints, filter)) continue;
            return (T)object;
        }
        list = this.getCachedProviders(clazz);
        if (list != null) {
            object = list.iterator();
            while (object.hasNext()) {
                Object t = ((Reference)object.next()).get();
                if (t == null) {
                    object.remove();
                    continue;
                }
                if (clazz2 != null && !clazz2.isInstance(t) || !this.isAcceptable(t, clazz, hints, filter)) continue;
                return t;
            }
        }
        return null;
    }

    <T> List<Reference<T>> getCachedProviders(Class<T> clazz) {
        return null;
    }

    final <T> boolean isAcceptable(T t, Class<T> clazz, Hints hints, ServiceRegistry.Filter filter) {
        if (filter != null && !filter.filter(t)) {
            return false;
        }
        if (!this.isAvailable(t)) {
            return false;
        }
        if (hints != null && t instanceof Factory && !this.usesAcceptableHints((Factory)t, clazz, hints, null)) {
            return false;
        }
        return this.isAcceptable(t, clazz, hints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean usesAcceptableHints(Factory factory, Class<?> clazz, Hints hints, Set<Factory> set) {
        Map<RenderingHints.Key, Object> map;
        if (!this.testingHints.addAndCheck(factory)) {
            return false;
        }
        try {
            map = Hints.stripNonKeys(factory.getImplementationHints());
        }
        finally {
            this.testingHints.removeAndCheck(factory);
        }
        if (map == null) {
            return true;
        }
        Hints hints2 = null;
        for (Map.Entry<RenderingHints.Key, Object> entry : map.entrySet()) {
            Class clazz2;
            Class[] classArray;
            RenderingHints.Key key = entry.getKey();
            Object object = entry.getValue();
            Object object2 = hints.get(key);
            if (object2 != null) {
                if (object2 instanceof Class) {
                    if (!((Class)object2).isInstance(object)) {
                        return false;
                    }
                } else if (object2 instanceof Class[]) {
                    classArray = (Class[])object2;
                    int n = 0;
                    do {
                        if (n < classArray.length) continue;
                        return false;
                    } while (!classArray[n++].isInstance(object));
                } else if (!object2.equals(object)) {
                    return false;
                }
            }
            if (!(object instanceof Factory)) continue;
            classArray = (Class[])object;
            if (set == null) {
                set = new HashSet<Factory>();
            }
            if (set.contains(classArray)) continue;
            set.add(factory);
            if (hints2 == null) {
                hints2 = new Hints(hints);
                hints2.keySet().removeAll(map.keySet());
            }
            if (this.usesAcceptableHints((Factory)classArray, clazz2 = key instanceof Hints.Key ? ((Hints.Key)key).getValueClass() : Factory.class, hints2, set)) continue;
            return false;
        }
        return true;
    }

    protected <T> boolean isAcceptable(T t, Class<T> clazz, Hints hints) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAvailable(Object object) {
        if (!(object instanceof OptionalFactory)) {
            return true;
        }
        OptionalFactory optionalFactory = (OptionalFactory)object;
        Class<?> clazz = optionalFactory.getClass();
        if (!this.testingAvailability.addAndCheck(clazz)) {
            throw new RecursiveSearchException(clazz);
        }
        try {
            boolean bl = optionalFactory.isAvailable();
            return bl;
        }
        finally {
            this.testingAvailability.removeAndCheck(clazz);
        }
    }

    public final Set<ClassLoader> getClassLoaders() {
        HashSet<ClassLoader> hashSet = new HashSet<ClassLoader>();
        for (int i = 0; i < 4; ++i) {
            ClassLoader classLoader;
            try {
                switch (i) {
                    case 0: {
                        classLoader = this.getClass().getClassLoader();
                        break;
                    }
                    case 1: {
                        classLoader = FactoryRegistry.class.getClassLoader();
                        break;
                    }
                    case 2: {
                        classLoader = Thread.currentThread().getContextClassLoader();
                        break;
                    }
                    case 3: {
                        classLoader = ClassLoader.getSystemClassLoader();
                        break;
                    }
                    default: {
                        throw new AssertionError(i);
                    }
                }
            }
            catch (SecurityException securityException) {
                continue;
            }
            hashSet.add(classLoader);
        }
        hashSet.remove(null);
        ClassLoader[] classLoaderArray = hashSet.toArray(new ClassLoader[hashSet.size()]);
        for (int i = 0; i < classLoaderArray.length; ++i) {
            ClassLoader classLoader = classLoaderArray[i];
            try {
                while ((classLoader = classLoader.getParent()) != null) {
                    hashSet.remove(classLoader);
                }
                continue;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (hashSet.isEmpty()) {
            LOGGER.warning("No class loaders available.");
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void scanForPlugins(Collection<ClassLoader> collection, Class<T> clazz) {
        if (!this.scanningCategories.addAndCheck(clazz)) {
            throw new RecursiveSearchException(clazz);
        }
        try {
            StringBuilder stringBuilder = FactoryRegistry.getLogHeader(clazz);
            boolean bl = false;
            for (ClassLoader classLoader : collection) {
                bl |= this.register(FactoryRegistry.lookupProviders(clazz, classLoader), clazz, stringBuilder);
                bl |= this.registerFromSystemProperty(classLoader, clazz, stringBuilder);
            }
            FactoryIteratorProvider[] factoryIteratorProviderArray = FactoryIteratorProviders.getIteratorProviders();
            for (int i = 0; i < factoryIteratorProviderArray.length; ++i) {
                Iterator<T> iterator = factoryIteratorProviderArray[i].iterator(clazz);
                if (iterator == null) continue;
                bl |= this.register(iterator, clazz, stringBuilder);
            }
            if (bl) {
                FactoryRegistry.log("scanForPlugins", stringBuilder);
            }
        }
        finally {
            this.scanningCategories.removeAndCheck(clazz);
        }
    }

    private <T> void scanForPluginsIfNeeded(Class<?> clazz) {
        if (this.needScanForPlugins != null && this.needScanForPlugins.remove(clazz)) {
            if (this.needScanForPlugins.isEmpty()) {
                this.needScanForPlugins = null;
            }
            this.scanForPlugins(this.getClassLoaders(), clazz);
        }
    }

    private <T> boolean register(Iterator<T> iterator, Class<T> clazz, StringBuilder stringBuilder) {
        boolean bl = false;
        String string = System.getProperty("line.separator", "\n");
        while (iterator.hasNext()) {
            Throwable throwable;
            Object object;
            try {
                object = iterator.next();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw outOfMemoryError;
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                FactoryRegistry.loadingFailure(clazz, noClassDefFoundError, false);
                continue;
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
                throwable = exceptionInInitializerError.getCause();
                if (throwable != null) {
                    FactoryRegistry.loadingFailure(clazz, throwable, true);
                }
                throw exceptionInInitializerError;
            }
            catch (Error error) {
                if (!Classes.getShortClassName(error).equals("ServiceConfigurationError")) {
                    throw error;
                }
                FactoryRegistry.loadingFailure(clazz, error, true);
                continue;
            }
            Class<T> clazz2 = object.getClass().asSubclass(clazz);
            throwable = this.getServiceProviderByClass(clazz2);
            if (throwable != null) {
                object = throwable;
            }
            if (!this.registerServiceProvider(object, clazz)) continue;
            stringBuilder.append(string);
            stringBuilder.append("  ");
            stringBuilder.append(clazz2.getName());
            bl = true;
        }
        return bl;
    }

    private <T> boolean registerFromSystemProperty(ClassLoader classLoader, Class<T> clazz, StringBuilder stringBuilder) {
        boolean bl;
        block10: {
            bl = false;
            try {
                String string = System.getProperty(clazz.getName());
                if (string == null) break block10;
                try {
                    Class<?> clazz2 = classLoader.loadClass(string);
                    if (!clazz.isAssignableFrom(clazz2)) break block10;
                    Class<T> clazz3 = clazz2.asSubclass(clazz);
                    T t = this.getServiceProviderByClass(clazz3);
                    if (t == null) {
                        try {
                            t = clazz3.newInstance();
                            if (this.registerServiceProvider(t, clazz)) {
                                stringBuilder.append(System.getProperty("line.separator", "\n"));
                                stringBuilder.append("  ");
                                stringBuilder.append(clazz3.getName());
                                bl = true;
                            }
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            throw new FactoryRegistryException(Errors.format(23, string), illegalAccessException);
                        }
                        catch (InstantiationException instantiationException) {
                            throw new FactoryRegistryException(Errors.format(23, string), instantiationException);
                        }
                    }
                    Iterator<T> iterator = this.getServiceProviders(clazz, false);
                    while (iterator.hasNext()) {
                        T t2 = iterator.next();
                        if (t2 == t) continue;
                        this.setOrdering(clazz, t, t2);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return bl;
    }

    private static void loadingFailure(Class<?> clazz, Throwable throwable, boolean bl) {
        String string = Classes.getShortName(clazz);
        StringBuilder stringBuilder = new StringBuilder(Classes.getShortClassName(throwable));
        String string2 = throwable.getLocalizedMessage();
        if (string2 != null) {
            stringBuilder.append(": ");
            stringBuilder.append(string2);
        }
        LogRecord logRecord = Loggings.format(Level.WARNING, 8, string, stringBuilder.toString());
        if (bl) {
            logRecord.setThrown(throwable);
        }
        logRecord.setSourceClassName(FactoryRegistry.class.getName());
        logRecord.setSourceMethodName("scanForPlugins");
        logRecord.setLoggerName(LOGGER.getName());
        LOGGER.log(logRecord);
    }

    private static StringBuilder getLogHeader(Class<?> clazz) {
        return new StringBuilder(Loggings.getResources(null).getString(21, clazz));
    }

    private static void log(String string, StringBuilder stringBuilder) {
        LogRecord logRecord = new LogRecord(Level.CONFIG, stringBuilder.toString());
        logRecord.setSourceClassName(FactoryRegistry.class.getName());
        logRecord.setSourceMethodName(string);
        logRecord.setLoggerName(LOGGER.getName());
        LOGGER.log(logRecord);
    }

    private void synchronizeIteratorProviders() {
        FactoryIteratorProvider[] factoryIteratorProviderArray = this.globalConfiguration.synchronizeIteratorProviders();
        if (factoryIteratorProviderArray == null) {
            return;
        }
        Iterator<Class<?>> iterator = this.getCategories();
        while (iterator.hasNext()) {
            Class<?> clazz = iterator.next();
            if (this.needScanForPlugins != null && this.needScanForPlugins.contains(clazz)) continue;
            for (int i = 0; i < factoryIteratorProviderArray.length; ++i) {
                this.register(factoryIteratorProviderArray[i], clazz);
            }
        }
    }

    private <T> void register(FactoryIteratorProvider factoryIteratorProvider, Class<T> clazz) {
        StringBuilder stringBuilder;
        Iterator<T> iterator = factoryIteratorProvider.iterator(clazz);
        if (iterator != null && this.register(iterator, clazz, stringBuilder = FactoryRegistry.getLogHeader(clazz))) {
            FactoryRegistry.log("synchronizeIteratorProviders", stringBuilder);
        }
    }
}

