/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.Iterator;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.store.ReprojectingIterator;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.SchemaException;
import org.geotools.feature.collection.DecoratingSimpleFeatureCollection;
import org.geotools.feature.collection.DelegateSimpleFeatureIterator;
import org.geotools.geometry.jts.GeometryCoordinateSequenceTransformer;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class ReprojectingFeatureCollection
extends DecoratingSimpleFeatureCollection {
    MathTransform transform;
    SimpleFeatureType schema;
    CoordinateReferenceSystem target;
    GeometryCoordinateSequenceTransformer transformer;

    public ReprojectingFeatureCollection(SimpleFeatureCollection simpleFeatureCollection, CoordinateReferenceSystem coordinateReferenceSystem) {
        this(simpleFeatureCollection, ((SimpleFeatureType)simpleFeatureCollection.getSchema()).getGeometryDescriptor().getCoordinateReferenceSystem(), coordinateReferenceSystem);
    }

    public ReprojectingFeatureCollection(SimpleFeatureCollection simpleFeatureCollection, CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) {
        super(simpleFeatureCollection);
        this.target = coordinateReferenceSystem2;
        SimpleFeatureType simpleFeatureType = (SimpleFeatureType)simpleFeatureCollection.getSchema();
        this.schema = this.reType(simpleFeatureType, coordinateReferenceSystem2);
        if (coordinateReferenceSystem == null) {
            throw new NullPointerException("source crs");
        }
        if (coordinateReferenceSystem2 == null) {
            throw new NullPointerException("destination crs");
        }
        this.transform = this.transform(coordinateReferenceSystem, coordinateReferenceSystem2);
        this.transformer = new GeometryCoordinateSequenceTransformer();
    }

    private MathTransform transform(CoordinateReferenceSystem coordinateReferenceSystem, CoordinateReferenceSystem coordinateReferenceSystem2) {
        try {
            return CRS.findMathTransform(coordinateReferenceSystem, coordinateReferenceSystem2);
        }
        catch (FactoryException factoryException) {
            throw new IllegalArgumentException("Could not create math transform");
        }
    }

    private SimpleFeatureType reType(SimpleFeatureType simpleFeatureType, CoordinateReferenceSystem coordinateReferenceSystem) {
        try {
            return FeatureTypes.transform(simpleFeatureType, coordinateReferenceSystem);
        }
        catch (SchemaException schemaException) {
            throw new IllegalArgumentException("Could not transform source schema", schemaException);
        }
    }

    @Override
    public SimpleFeatureIterator features() {
        return new DelegateSimpleFeatureIterator(this, this.iterator());
    }

    @Override
    public Iterator<SimpleFeature> iterator() {
        try {
            return new ReprojectingIterator(this.delegate.iterator(), this.transform, this.schema, this.transformer);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public void close(Iterator iterator) {
        Iterator iterator2 = ((ReprojectingIterator)iterator).getDelegate();
        this.delegate.close(iterator2);
    }

    @Override
    public SimpleFeatureType getSchema() {
        return this.schema;
    }

    @Override
    public SimpleFeatureCollection subCollection(Filter filter) {
        Filter filter2 = this.unFilter(filter);
        return new ReprojectingFeatureCollection(this.delegate.subCollection(filter2), this.target);
    }

    private Filter unFilter(Filter filter) {
        return filter;
    }

    public SimpleFeatureCollection sort(SortBy sortBy) {
        throw new UnsupportedOperationException("Not yet");
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray(Object[] objectArray) {
        ArrayList<SimpleFeature> arrayList = new ArrayList<SimpleFeature>();
        Iterator<SimpleFeature> iterator = this.iterator();
        try {
            while (iterator.hasNext()) {
                arrayList.add(iterator.next());
            }
            Object[] objectArray2 = arrayList.toArray(objectArray);
            return objectArray2;
        }
        finally {
            this.close((Iterator)iterator);
        }
    }

    @Override
    public boolean add(SimpleFeature simpleFeature) {
        throw new UnsupportedOperationException("Not yet");
    }

    @Override
    public ReferencedEnvelope getBounds() {
        SimpleFeatureIterator simpleFeatureIterator = this.features();
        try {
            ReferencedEnvelope referencedEnvelope;
            Envelope envelope = new Envelope();
            while (simpleFeatureIterator.hasNext()) {
                SimpleFeature simpleFeature = (SimpleFeature)simpleFeatureIterator.next();
                referencedEnvelope = (Geometry)simpleFeature.getDefaultGeometry();
                if (referencedEnvelope == null) continue;
                Envelope envelope2 = referencedEnvelope.getEnvelopeInternal();
                envelope.expandToInclude(envelope2);
            }
            referencedEnvelope = ReferencedEnvelope.reference(envelope);
            return referencedEnvelope;
        }
        catch (Exception exception) {
            throw new RuntimeException("Exception occurred while computing reprojected bounds", exception);
        }
        finally {
            simpleFeatureIterator.close();
        }
    }
}

