/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import java.util.Iterator;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;

public class ReTypingIterator
implements Iterator {
    Iterator delegate;
    AttributeDescriptor[] types;
    SimpleFeatureBuilder builder;

    public ReTypingIterator(Iterator iterator, SimpleFeatureType simpleFeatureType, SimpleFeatureType simpleFeatureType2) {
        this.delegate = iterator;
        this.types = this.typeAttributes(simpleFeatureType, simpleFeatureType2);
        this.builder = new SimpleFeatureBuilder(simpleFeatureType2);
    }

    public Iterator getDelegate() {
        return this.delegate;
    }

    @Override
    public void remove() {
        this.delegate.remove();
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    public Object next() {
        SimpleFeature simpleFeature = (SimpleFeature)this.delegate.next();
        String string = simpleFeature.getID();
        try {
            for (int i = 0; i < this.types.length; ++i) {
                String string2 = this.types[i].getLocalName();
                this.builder.add(simpleFeature.getAttribute(string2));
            }
            return this.builder.buildFeature(string);
        }
        catch (IllegalAttributeException illegalAttributeException) {
            throw new RuntimeException(illegalAttributeException);
        }
    }

    protected AttributeDescriptor[] typeAttributes(SimpleFeatureType simpleFeatureType, SimpleFeatureType simpleFeatureType2) {
        if (simpleFeatureType2.equals(simpleFeatureType)) {
            throw new IllegalArgumentException("FeatureReader allready produces contents with the correct schema");
        }
        if (simpleFeatureType2.getAttributeCount() > simpleFeatureType.getAttributeCount()) {
            throw new IllegalArgumentException("Unable to retype  FeatureReader<SimpleFeatureType, SimpleFeature> (origional does not cover requested type)");
        }
        AttributeDescriptor[] attributeDescriptorArray = new AttributeDescriptor[simpleFeatureType2.getAttributeCount()];
        for (int i = 0; i < simpleFeatureType2.getAttributeCount(); ++i) {
            AttributeDescriptor attributeDescriptor = simpleFeatureType2.getDescriptor(i);
            String string = attributeDescriptor.getLocalName();
            attributeDescriptorArray[i] = attributeDescriptor;
            if (attributeDescriptor.equals(simpleFeatureType.getDescriptor(string))) continue;
            throw new IllegalArgumentException("Unable to retype  FeatureReader<SimpleFeatureType, SimpleFeature> (origional does not cover " + string + ")");
        }
        return attributeDescriptorArray;
    }
}

