/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.List;
import java.util.NoSuchElementException;
import org.geotools.data.AbstractAttributeIO;
import org.geotools.data.shapefile.dbf.DbaseFileHeader;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.geotools.data.shapefile.indexed.RecordNumberTracker;
import org.geotools.data.shapefile.shp.ShapefileReader;
import org.opengis.feature.type.AttributeDescriptor;

public class ShapefileAttributeReader
extends AbstractAttributeIO
implements RecordNumberTracker {
    protected ShapefileReader shp;
    protected DbaseFileReader dbf;
    protected DbaseFileReader.Row row;
    protected ShapefileReader.Record record;
    protected int[] dbfindexes;
    protected Envelope targetBBox;
    protected Object geometry;
    protected boolean featureAvailable = false;

    public ShapefileAttributeReader(List<AttributeDescriptor> list, ShapefileReader shapefileReader, DbaseFileReader dbaseFileReader) {
        this(list.toArray(new AttributeDescriptor[0]), shapefileReader, dbaseFileReader);
    }

    public void setTargetBBox(Envelope envelope) {
        this.targetBBox = envelope;
    }

    public void setSimplificationDistance(double d) {
    }

    public ShapefileAttributeReader(AttributeDescriptor[] attributeDescriptorArray, ShapefileReader shapefileReader, DbaseFileReader dbaseFileReader) {
        super(attributeDescriptorArray);
        this.shp = shapefileReader;
        this.dbf = dbaseFileReader;
        if (dbaseFileReader != null) {
            this.dbfindexes = new int[attributeDescriptorArray.length];
            DbaseFileHeader dbaseFileHeader = dbaseFileReader.getHeader();
            block0: for (int i = 0; i < attributeDescriptorArray.length; ++i) {
                String string = attributeDescriptorArray[i].getLocalName();
                int n = 0;
                if (attributeDescriptorArray[i].getUserData().get("original") != null) {
                    string = (String)attributeDescriptorArray[i].getUserData().get("original");
                    n = (Integer)attributeDescriptorArray[i].getUserData().get("count");
                }
                for (int j = 0; j < dbaseFileHeader.getNumFields(); ++j) {
                    if (!dbaseFileHeader.getFieldName(j).equals(string) || n-- > 0) continue;
                    this.dbfindexes[i] = j;
                    continue block0;
                }
                this.dbfindexes[i] = -1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            if (this.shp != null) {
                this.shp.close();
            }
            if (this.dbf != null) {
                this.dbf.close();
            }
        }
        finally {
            this.row = null;
            this.record = null;
            this.shp = null;
            this.dbf = null;
        }
    }

    boolean internalReadersHaveNext() throws IOException {
        int n;
        int n2 = n = this.shp.hasNext() ? 1 : 0;
        if (this.dbf != null) {
            n += this.dbf.hasNext() ? 2 : 0;
        }
        if (n == 3 || n == 1 && this.dbf == null) {
            return true;
        }
        if (n == 0) {
            return false;
        }
        throw new IOException((n == 1 ? "Shp" : "Dbf") + " has extra record");
    }

    @Override
    public boolean hasNext() throws IOException {
        while (!this.featureAvailable && this.internalReadersHaveNext()) {
            this.record = this.shp.nextRecord();
            Envelope envelope = this.record.envelope();
            boolean bl = false;
            if (this.targetBBox != null && !this.targetBBox.isNull() && !this.targetBBox.intersects(envelope)) {
                this.geometry = null;
                bl = true;
            } else {
                this.geometry = this.record.shape();
            }
            if (this.dbf != null) {
                if (bl) {
                    this.dbf.skip();
                    this.row = null;
                } else {
                    this.row = this.dbf.readRow();
                }
            } else {
                this.row = null;
            }
            this.featureAvailable = !bl;
        }
        return this.featureAvailable;
    }

    @Override
    public void next() throws IOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException("hasNext() returned false");
        }
        this.featureAvailable = false;
    }

    @Override
    public Object read(int n) throws IOException, ArrayIndexOutOfBoundsException {
        int n2 = this.dbfindexes != null ? this.dbfindexes[n] : -1;
        switch (n2) {
            case -1: {
                return this.geometry;
            }
        }
        if (this.row != null) {
            return this.row.read(n2);
        }
        return null;
    }

    @Override
    public int getRecordNumber() {
        return this.record.number;
    }
}

