/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.Map;
import org.geotools.resources.i18n.Errors;

public final class Classes {
    public static final byte DOUBLE = 8;
    public static final byte FLOAT = 7;
    public static final byte LONG = 6;
    public static final byte INTEGER = 5;
    public static final byte SHORT = 4;
    public static final byte BYTE = 3;
    public static final byte CHARACTER = 2;
    public static final byte BOOLEAN = 1;
    public static final byte OTHER = 0;
    private static final Map<Class<?>, Classes> MAPPING = new HashMap(16);
    private final Class<?> wrapper;
    private final boolean isInteger;

    private Classes(Class<?> clazz, Class<?> clazz2, boolean bl, boolean bl2, byte by, byte by2) {
        this.wrapper = clazz2;
        this.isInteger = bl2;
        if (MAPPING.put(clazz, this) != null || MAPPING.put(clazz2, this) != null) {
            throw new AssertionError();
        }
    }

    public static Class<?> boundOfParameterizedAttribute(Method method) {
        Type[] typeArray;
        Class<?> clazz = Classes.getActualTypeArgument(method.getGenericReturnType());
        if (clazz == null && (typeArray = method.getGenericParameterTypes()) != null && typeArray.length == 1) {
            clazz = Classes.getActualTypeArgument(typeArray[0]);
        }
        return clazz;
    }

    private static Class<?> getActualTypeArgument(Type type) {
        if (type instanceof ParameterizedType) {
            Type[] typeArray = ((ParameterizedType)type).getActualTypeArguments();
            while (typeArray != null && typeArray.length == 1) {
                type = typeArray[0];
                if (type instanceof Class) {
                    return (Class)type;
                }
                if (!(type instanceof WildcardType)) break;
                typeArray = ((WildcardType)type).getUpperBounds();
            }
        }
        return null;
    }

    public static <T> Class<? extends T> getClass(T t) {
        return t != null ? t.getClass() : null;
    }

    public static <T> boolean sameInterfaces(Class<? extends T> clazz, Class<? extends T> clazz2, Class<T> clazz3) {
        Class<?> clazz4;
        int n;
        if (clazz == clazz2) {
            return true;
        }
        if (clazz == null || clazz2 == null) {
            return false;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        Class<?>[] classArray2 = clazz2.getInterfaces();
        int n2 = 0;
        for (n = 0; n < classArray2.length; ++n) {
            clazz4 = classArray2[n];
            if (!clazz3.isAssignableFrom(clazz4)) continue;
            classArray2[n2++] = clazz4;
        }
        block1: for (n = 0; n < classArray.length; ++n) {
            clazz4 = classArray[n];
            if (!clazz3.isAssignableFrom(clazz4)) continue;
            for (int i = 0; i < n2; ++i) {
                if (!clazz4.equals(classArray2[i])) continue;
                System.arraycopy(classArray2, i + 1, classArray2, i, --n2 - i);
                continue block1;
            }
            return false;
        }
        return n2 == 0;
    }

    public static boolean isInteger(Class<?> clazz) {
        Classes classes = MAPPING.get(clazz);
        return classes != null && classes.isInteger;
    }

    public static Class<?> primitiveToWrapper(Class<?> clazz) {
        Classes classes = MAPPING.get(clazz);
        return classes != null ? classes.wrapper : clazz;
    }

    public static <T> T valueOf(Class<T> clazz, String string) throws IllegalArgumentException, NumberFormatException {
        if (string == null) {
            return null;
        }
        if (Double.class.equals(clazz)) {
            return (T)Double.valueOf(string);
        }
        if (Float.class.equals(clazz)) {
            return (T)Float.valueOf(string);
        }
        if (Long.class.equals(clazz)) {
            return (T)Long.valueOf(string);
        }
        if (Integer.class.equals(clazz)) {
            return (T)Integer.valueOf(string);
        }
        if (Short.class.equals(clazz)) {
            return (T)Short.valueOf(string);
        }
        if (Byte.class.equals(clazz)) {
            return (T)Byte.valueOf(string);
        }
        if (Boolean.class.equals(clazz)) {
            return (T)Boolean.valueOf(string);
        }
        if (Character.class.equals(clazz)) {
            return (T)Character.valueOf(string.length() != 0 ? string.charAt(0) : (char)'\u0000');
        }
        if (String.class.equals(clazz)) {
            return (T)string;
        }
        throw new IllegalArgumentException(Errors.format(187, clazz));
    }

    public static String getShortName(Class<?> clazz) {
        if (clazz == null) {
            return "<*>";
        }
        String string = clazz.getSimpleName();
        Class<?> clazz2 = clazz.getEnclosingClass();
        if (clazz2 != null) {
            StringBuilder stringBuilder = new StringBuilder();
            do {
                stringBuilder.insert(0, '.').insert(0, clazz2.getSimpleName());
            } while ((clazz2 = clazz2.getEnclosingClass()) != null);
            string = stringBuilder.append(string).toString();
        }
        return string;
    }

    public static String getShortClassName(Object object) {
        return Classes.getShortName(Classes.getClass(object));
    }

    static {
        new Classes(Double.TYPE, Double.class, true, false, 64, 8);
        new Classes(Float.TYPE, Float.class, true, false, 32, 7);
        new Classes(Long.TYPE, Long.class, false, true, 64, 6);
        new Classes(Integer.TYPE, Integer.class, false, true, 32, 5);
        new Classes(Short.TYPE, Short.class, false, true, 16, 4);
        new Classes(Byte.TYPE, Byte.class, false, true, 8, 3);
        new Classes(Character.TYPE, Character.class, false, false, 16, 2);
        new Classes(Boolean.TYPE, Boolean.class, false, false, 1, 1);
        new Classes(Void.TYPE, Void.class, false, false, 0, 0);
    }
}

