/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import org.geotools.referencing.operation.transform.ConcatenatedTransformDirect;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

final class ConcatenatedTransformDirect1D
extends ConcatenatedTransformDirect
implements MathTransform1D {
    private static final long serialVersionUID = 1064398659892864966L;
    private final MathTransform1D transform1;
    private final MathTransform1D transform2;

    public ConcatenatedTransformDirect1D(MathTransform1D mathTransform1D, MathTransform1D mathTransform1D2) {
        super(mathTransform1D, mathTransform1D2);
        this.transform1 = mathTransform1D;
        this.transform2 = mathTransform1D2;
    }

    @Override
    boolean isValid() {
        return super.isValid() && this.getSourceDimensions() == 1 && this.getTargetDimensions() == 1;
    }

    @Override
    public double transform(double d) throws TransformException {
        return this.transform2.transform(this.transform1.transform(d));
    }

    @Override
    public double derivative(double d) throws TransformException {
        double d2 = this.transform1.derivative(d);
        double d3 = this.transform2.derivative(this.transform1.transform(d));
        return d3 * d2;
    }

    @Override
    public MathTransform1D inverse() throws NoninvertibleTransformException {
        return (MathTransform1D)super.inverse();
    }
}

