/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.Serializable;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.geotools.referencing.operation.matrix.Matrix3;
import org.geotools.referencing.operation.matrix.XMatrix;
import org.geotools.referencing.operation.transform.AbstractMathTransform;
import org.geotools.referencing.operation.transform.ConcatenatedTransform1D;
import org.geotools.referencing.operation.transform.ConcatenatedTransform2D;
import org.geotools.referencing.operation.transform.ConcatenatedTransformDirect;
import org.geotools.referencing.operation.transform.ConcatenatedTransformDirect1D;
import org.geotools.referencing.operation.transform.ConcatenatedTransformDirect2D;
import org.geotools.referencing.operation.transform.IdentityTransform;
import org.geotools.referencing.operation.transform.ProjectiveTransform;
import org.geotools.resources.Classes;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Utilities;
import org.opengis.geometry.DirectPosition;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

public class ConcatenatedTransform
extends AbstractMathTransform
implements Serializable {
    private static final long serialVersionUID = 5772066656987558634L;
    private static final double EPSILON = 1.0E-10;
    private static final int TEMPORARY_ARRAY_LENGTH = 256;
    public final MathTransform transform1;
    public final MathTransform transform2;
    private ConcatenatedTransform inverse;

    protected ConcatenatedTransform(MathTransform mathTransform, MathTransform mathTransform2) {
        this.transform1 = mathTransform;
        this.transform2 = mathTransform2;
        if (!this.isValid()) {
            throw new IllegalArgumentException(Errors.format(20, ConcatenatedTransform.getName(mathTransform), ConcatenatedTransform.getName(mathTransform2)));
        }
    }

    private static XMatrix getMatrix(MathTransform mathTransform) {
        if (mathTransform instanceof LinearTransform) {
            return ConcatenatedTransform.toXMatrix(((LinearTransform)mathTransform).getMatrix());
        }
        if (mathTransform instanceof AffineTransform) {
            return new Matrix3((AffineTransform)((Object)mathTransform));
        }
        return null;
    }

    private static boolean areInverse(MathTransform mathTransform, MathTransform mathTransform2) {
        if (mathTransform2 instanceof AbstractMathTransform.Inverse) {
            return mathTransform.equals(((AbstractMathTransform.Inverse)mathTransform2).inverse());
        }
        return false;
    }

    public static MathTransform create(MathTransform mathTransform, MathTransform mathTransform2) {
        int n;
        int n2 = mathTransform.getTargetDimensions();
        if (n2 != (n = mathTransform2.getSourceDimensions())) {
            throw new IllegalArgumentException(Errors.format(20, ConcatenatedTransform.getName(mathTransform), ConcatenatedTransform.getName(mathTransform2)) + ' ' + Errors.format(93, n2, n));
        }
        MathTransform mathTransform3 = ConcatenatedTransform.createOptimized(mathTransform, mathTransform2);
        if (mathTransform3 != null) {
            return mathTransform3;
        }
        int n3 = ConcatenatedTransform.getStepCount(mathTransform) + ConcatenatedTransform.getStepCount(mathTransform2);
        boolean bl = true;
        int n4 = 0;
        while (true) {
            MathTransform mathTransform4;
            MathTransform mathTransform5 = mathTransform;
            MathTransform mathTransform6 = mathTransform2;
            boolean bl2 = !(n4 & true);
            MathTransform mathTransform7 = mathTransform4 = bl2 ? mathTransform5 : mathTransform6;
            while (mathTransform4 instanceof ConcatenatedTransform) {
                int n5;
                ConcatenatedTransform concatenatedTransform = (ConcatenatedTransform)mathTransform4;
                if (bl2) {
                    mathTransform5 = mathTransform4 = concatenatedTransform.transform1;
                    mathTransform6 = ConcatenatedTransform.create(concatenatedTransform.transform2, mathTransform6);
                } else {
                    mathTransform5 = ConcatenatedTransform.create(mathTransform5, concatenatedTransform.transform1);
                    mathTransform6 = mathTransform4 = concatenatedTransform.transform2;
                }
                if ((n5 = ConcatenatedTransform.getStepCount(mathTransform5) + ConcatenatedTransform.getStepCount(mathTransform6)) >= n3) continue;
                mathTransform = mathTransform5;
                mathTransform2 = mathTransform6;
                n3 = n5;
                bl = true;
            }
            if (!bl) break;
            bl = false;
            ++n4;
        }
        mathTransform3 = ConcatenatedTransform.createOptimized(mathTransform, mathTransform2);
        if (mathTransform3 != null) {
            return mathTransform3;
        }
        return ConcatenatedTransform.createConcatenatedTransform(mathTransform, mathTransform2);
    }

    private static MathTransform createOptimized(MathTransform mathTransform, MathTransform mathTransform2) {
        Object object;
        if (mathTransform.isIdentity()) {
            return mathTransform2;
        }
        if (mathTransform2.isIdentity()) {
            return mathTransform;
        }
        XMatrix xMatrix = ConcatenatedTransform.getMatrix(mathTransform);
        if (xMatrix != null && (object = ConcatenatedTransform.getMatrix(mathTransform2)) != null) {
            XMatrix xMatrix2;
            int n = object.getNumRow();
            int n2 = xMatrix.getNumCol();
            if (n2 == object.getNumCol()) {
                xMatrix2 = object;
                object.multiply(xMatrix);
            } else {
                GeneralMatrix generalMatrix = new GeneralMatrix(n, n2);
                generalMatrix.mul(ConcatenatedTransform.toGMatrix((Matrix)object), ConcatenatedTransform.toGMatrix(xMatrix));
                xMatrix2 = generalMatrix;
            }
            if (xMatrix2.isIdentity(1.0E-10)) {
                xMatrix2.setIdentity();
            }
            return ProjectiveTransform.create(xMatrix2);
        }
        if (ConcatenatedTransform.areInverse(mathTransform, mathTransform2) || ConcatenatedTransform.areInverse(mathTransform2, mathTransform)) {
            assert (mathTransform.getSourceDimensions() == mathTransform2.getTargetDimensions());
            assert (mathTransform.getTargetDimensions() == mathTransform2.getSourceDimensions());
            return IdentityTransform.create(mathTransform.getSourceDimensions());
        }
        if (mathTransform instanceof AbstractMathTransform && (object = ((AbstractMathTransform)mathTransform).concatenate(mathTransform2, false)) != null) {
            return object;
        }
        if (mathTransform2 instanceof AbstractMathTransform && (object = ((AbstractMathTransform)mathTransform2).concatenate(mathTransform, true)) != null) {
            return object;
        }
        return null;
    }

    static ConcatenatedTransform createConcatenatedTransform(MathTransform mathTransform, MathTransform mathTransform2) {
        int n = mathTransform.getSourceDimensions();
        int n2 = mathTransform2.getTargetDimensions();
        if (n == 1 && n2 == 1) {
            if (mathTransform instanceof MathTransform1D && mathTransform2 instanceof MathTransform1D) {
                return new ConcatenatedTransformDirect1D((MathTransform1D)mathTransform, (MathTransform1D)mathTransform2);
            }
            return new ConcatenatedTransform1D(mathTransform, mathTransform2);
        }
        if (n == 2 && n2 == 2) {
            if (mathTransform instanceof MathTransform2D && mathTransform2 instanceof MathTransform2D) {
                return new ConcatenatedTransformDirect2D((MathTransform2D)mathTransform, (MathTransform2D)mathTransform2);
            }
            return new ConcatenatedTransform2D(mathTransform, mathTransform2);
        }
        if (n == mathTransform.getTargetDimensions() && mathTransform2.getSourceDimensions() == n2) {
            return new ConcatenatedTransformDirect(mathTransform, mathTransform2);
        }
        return new ConcatenatedTransform(mathTransform, mathTransform2);
    }

    private static final String getName(MathTransform mathTransform) {
        String string;
        ParameterValueGroup parameterValueGroup;
        if (mathTransform instanceof AbstractMathTransform && (parameterValueGroup = ((AbstractMathTransform)mathTransform).getParameterValues()) != null && (string = parameterValueGroup.getDescriptor().getName().getCode()) != null && (string = string.trim()).length() != 0) {
            return string;
        }
        return Classes.getShortClassName(mathTransform);
    }

    boolean isValid() {
        return this.transform1.getTargetDimensions() == this.transform2.getSourceDimensions();
    }

    @Override
    public final int getSourceDimensions() {
        return this.transform1.getSourceDimensions();
    }

    @Override
    public final int getTargetDimensions() {
        return this.transform2.getTargetDimensions();
    }

    public final int getStepCount() {
        return ConcatenatedTransform.getStepCount(this.transform1) + ConcatenatedTransform.getStepCount(this.transform2);
    }

    private static int getStepCount(MathTransform mathTransform) {
        if (mathTransform.isIdentity()) {
            return 0;
        }
        if (!(mathTransform instanceof ConcatenatedTransform)) {
            return 1;
        }
        return ((ConcatenatedTransform)mathTransform).getStepCount();
    }

    @Override
    public DirectPosition transform(DirectPosition directPosition, DirectPosition directPosition2) throws TransformException {
        assert (this.isValid());
        return this.transform2.transform(this.transform1.transform(directPosition, null), directPosition2);
    }

    @Override
    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) throws TransformException {
        int n4;
        assert (this.isValid());
        int n5 = this.transform1.getTargetDimensions();
        if (n5 <= (n4 = this.getTargetDimensions())) {
            this.transform1.transform(dArray, n, dArray2, n2, n3);
            this.transform2.transform(dArray2, n2, dArray2, n2, n3);
            return;
        }
        if (n3 <= 0) {
            return;
        }
        int n6 = n3;
        int n7 = n6 * n5;
        if (n7 > 256) {
            n6 = Math.max(1, 256 / n5);
            n7 = n6 * n5;
        }
        double[] dArray3 = new double[n7];
        int n8 = this.getSourceDimensions();
        do {
            if (n6 > n3) {
                n6 = n3;
            }
            this.transform1.transform(dArray, n, dArray3, 0, n6);
            this.transform2.transform(dArray3, 0, dArray2, n2, n6);
            n += n6 * n8;
            n2 += n6 * n4;
        } while ((n3 -= n6) != 0);
    }

    @Override
    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) throws TransformException {
        assert (this.isValid());
        if (n3 <= 0) {
            return;
        }
        int n4 = this.getSourceDimensions();
        int n5 = this.getTargetDimensions();
        int n6 = this.transform1.getTargetDimensions();
        int n7 = n3;
        int n8 = Math.max(Math.max(n4, n5), n6);
        int n9 = n7 * n8;
        if (n9 > 256) {
            n7 = Math.max(1, 256 / n8);
            n9 = n7 * n8;
        }
        double[] dArray = new double[n9];
        do {
            int n10;
            if (n7 > n3) {
                n7 = n3;
            }
            n9 = n7 * n4;
            for (n10 = 0; n10 < n9; ++n10) {
                dArray[n10] = fArray[n++];
            }
            this.transform1.transform(dArray, 0, dArray, 0, n7);
            this.transform2.transform(dArray, 0, dArray, 0, n7);
            n9 = n7 * n5;
            for (n10 = 0; n10 < n9; ++n10) {
                fArray2[n2++] = (float)dArray[n10];
            }
        } while ((n3 -= n7) != 0);
    }

    @Override
    public synchronized MathTransform inverse() throws NoninvertibleTransformException {
        assert (this.isValid());
        if (this.inverse == null) {
            this.inverse = ConcatenatedTransform.createConcatenatedTransform(this.transform2.inverse(), this.transform1.inverse());
            this.inverse.inverse = this;
        }
        return this.inverse;
    }

    @Override
    public Matrix derivative(Point2D point2D) throws TransformException {
        return this.derivative(new GeneralDirectPosition(point2D));
    }

    @Override
    public Matrix derivative(DirectPosition directPosition) throws TransformException {
        XMatrix xMatrix;
        Matrix matrix = this.transform1.derivative(directPosition);
        Matrix matrix2 = this.transform2.derivative(this.transform1.transform(directPosition, null));
        int n = matrix2.getNumRow();
        int n2 = matrix.getNumCol();
        if (n2 == matrix2.getNumCol()) {
            xMatrix = ConcatenatedTransform.toXMatrix(matrix2);
            xMatrix.multiply(matrix);
        } else {
            GeneralMatrix generalMatrix = new GeneralMatrix(n, n2);
            generalMatrix.mul(ConcatenatedTransform.toGMatrix(matrix2), ConcatenatedTransform.toGMatrix(matrix));
            xMatrix = generalMatrix;
        }
        return xMatrix;
    }

    @Override
    public final boolean isIdentity() {
        return this.transform1.isIdentity() && this.transform2.isIdentity();
    }

    @Override
    public final int hashCode() {
        return this.transform1.hashCode() + 37 * this.transform2.hashCode();
    }

    @Override
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            ConcatenatedTransform concatenatedTransform = (ConcatenatedTransform)object;
            return Utilities.equals(this.transform1, concatenatedTransform.transform1) && Utilities.equals(this.transform2, concatenatedTransform.transform2);
        }
        return false;
    }
}

