/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.transform;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.IllegalPathStateException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.io.Serializable;
import javax.vecmath.SingularMatrixException;
import org.geotools.geometry.GeneralDirectPosition;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.geotools.referencing.operation.matrix.Matrix1;
import org.geotools.referencing.operation.matrix.MatrixFactory;
import org.geotools.referencing.operation.matrix.XMatrix;
import org.geotools.referencing.wkt.Formattable;
import org.geotools.resources.Classes;
import org.geotools.resources.geometry.ShapeUtilities;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Vocabulary;
import org.geotools.util.Utilities;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform1D;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

public abstract class AbstractMathTransform
extends Formattable
implements MathTransform {
    protected AbstractMathTransform() {
    }

    public String getName() {
        String string;
        ReferenceIdentifier referenceIdentifier;
        ParameterDescriptorGroup parameterDescriptorGroup = this.getParameterDescriptors();
        if (parameterDescriptorGroup != null && (referenceIdentifier = parameterDescriptorGroup.getName()) != null && (string = referenceIdentifier.getCode()) != null) {
            return string;
        }
        return Classes.getShortClassName(this);
    }

    @Override
    public abstract int getSourceDimensions();

    @Override
    public abstract int getTargetDimensions();

    public ParameterDescriptorGroup getParameterDescriptors() {
        return null;
    }

    public ParameterValueGroup getParameterValues() {
        return null;
    }

    @Override
    public boolean isIdentity() {
        return false;
    }

    private static String constructMessage(String string, int n, int n2) {
        return Errors.format(94, string, n, n2);
    }

    public Point2D transform(Point2D point2D, Point2D point2D2) throws TransformException {
        int n = this.getSourceDimensions();
        if (n != 2) {
            throw new MismatchedDimensionException(AbstractMathTransform.constructMessage("ptSrc", 2, n));
        }
        n = this.getTargetDimensions();
        if (n != 2) {
            throw new MismatchedDimensionException(AbstractMathTransform.constructMessage("ptDst", 2, n));
        }
        double[] dArray = new double[]{point2D.getX(), point2D.getY()};
        this.transform(dArray, 0, dArray, 0, 1);
        if (point2D2 != null) {
            point2D2.setLocation(dArray[0], dArray[1]);
            return point2D2;
        }
        return new Point2D.Double(dArray[0], dArray[1]);
    }

    @Override
    public DirectPosition transform(DirectPosition directPosition, DirectPosition directPosition2) throws TransformException {
        int n = directPosition.getDimension();
        int n2 = this.getSourceDimensions();
        int n3 = this.getTargetDimensions();
        if (n != n2) {
            throw new MismatchedDimensionException(AbstractMathTransform.constructMessage("ptSrc", n, n2));
        }
        if (directPosition2 != null) {
            int n4;
            double[] dArray;
            n = directPosition2.getDimension();
            if (n != n3) {
                throw new MismatchedDimensionException(AbstractMathTransform.constructMessage("ptDst", n, n3));
            }
            if (n2 >= n3) {
                dArray = directPosition.getCoordinate();
            } else {
                dArray = new double[n3];
                n4 = n2;
                while (--n4 >= 0) {
                    dArray[n4] = directPosition.getOrdinate(n4);
                }
            }
            this.transform(dArray, 0, dArray, 0, 1);
            n4 = n3;
            while (--n4 >= 0) {
                directPosition2.setOrdinate(n4, dArray[n4]);
            }
        } else {
            double[] dArray;
            GeneralDirectPosition generalDirectPosition = new GeneralDirectPosition(n3);
            directPosition2 = generalDirectPosition;
            if (n2 <= n3) {
                dArray = generalDirectPosition.ordinates;
                int n5 = n2;
                while (--n5 >= 0) {
                    dArray[n5] = directPosition.getOrdinate(n5);
                }
            } else {
                dArray = directPosition.getCoordinate();
            }
            this.transform(dArray, 0, generalDirectPosition.ordinates, 0, 1);
        }
        return directPosition2;
    }

    @Override
    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) throws TransformException {
        int n4 = this.getSourceDimensions();
        int n5 = this.getTargetDimensions();
        double[] dArray = new double[n3 * Math.max(n4, n5)];
        int n6 = n3 * n4;
        while (--n6 >= 0) {
            dArray[n6] = fArray[n + n6];
        }
        this.transform(dArray, 0, dArray, 0, n3);
        n6 = n3 * n5;
        while (--n6 >= 0) {
            fArray2[n2 + n6] = (float)dArray[n6];
        }
    }

    @Override
    public void transform(double[] dArray, int n, float[] fArray, int n2, int n3) throws TransformException {
        int n4 = this.getSourceDimensions();
        int n5 = this.getTargetDimensions();
        double[] dArray2 = new double[n3 * Math.max(n4, n5)];
        System.arraycopy(dArray, n, dArray2, 0, n3 * n4);
        this.transform(dArray2, 0, dArray2, 0, n3);
        int n6 = n3 * n5;
        while (--n6 >= 0) {
            fArray[n2 + n6] = (float)dArray2[n6];
        }
    }

    @Override
    public void transform(float[] fArray, int n, double[] dArray, int n2, int n3) throws TransformException {
        int n4;
        int n5 = this.getSourceDimensions();
        if (n5 == (n4 = this.getTargetDimensions())) {
            int n6 = n3 * n5;
            for (int i = 0; i < n6; ++i) {
                dArray[n2 + i] = fArray[n + i];
            }
            this.transform(dArray, n2, dArray, n2, n3);
        } else {
            double[] dArray2 = new double[n3 * n5];
            int n7 = dArray2.length;
            while (--n7 >= 0) {
                dArray2[n7] = fArray[n + n7];
            }
            this.transform(dArray2, 0, dArray, 0, n3);
        }
    }

    public Shape createTransformedShape(Shape shape) throws TransformException {
        return this.isIdentity() ? shape : this.createTransformedShape(shape, null, null, 0);
    }

    final Shape createTransformedShape(Shape shape, AffineTransform affineTransform, AffineTransform affineTransform2, int n) throws TransformException {
        int n2 = this.getSourceDimensions();
        if (n2 != 2 || (n2 = this.getTargetDimensions()) != 2) {
            throw new MismatchedDimensionException(AbstractMathTransform.constructMessage("shape", 2, n2));
        }
        PathIterator pathIterator = shape.getPathIterator(affineTransform);
        GeneralPath generalPath = new GeneralPath(pathIterator.getWindingRule());
        Point2D.Float float_ = new Point2D.Float();
        double[] dArray = new double[6];
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        while (!pathIterator.isDone()) {
            block13: {
                switch (pathIterator.currentSegment(dArray)) {
                    default: {
                        throw new IllegalPathStateException();
                    }
                    case 4: {
                        generalPath.closePath();
                        break block13;
                    }
                    case 0: {
                        d = dArray[0];
                        d2 = dArray[1];
                        this.transform(dArray, 0, dArray, 0, 1);
                        d3 = dArray[0];
                        d4 = dArray[1];
                        generalPath.moveTo((float)d3, (float)d4);
                        break block13;
                    }
                    case 1: {
                        double d5 = d;
                        d = dArray[0];
                        dArray[0] = 0.5 * (d5 + d);
                        double d6 = d2;
                        d2 = dArray[1];
                        dArray[1] = 0.5 * (d6 + d2);
                        dArray[2] = d;
                        dArray[3] = d2;
                        break;
                    }
                    case 2: {
                        double d7 = d;
                        d = dArray[2];
                        dArray[0] = 0.5 * (dArray[0] + 0.5 * (d7 + d));
                        double d8 = d2;
                        d2 = dArray[3];
                        dArray[1] = 0.5 * (dArray[1] + 0.5 * (d8 + d2));
                        break;
                    }
                    case 3: {
                        double d9 = d;
                        d = dArray[4];
                        dArray[0] = 0.25 * (1.5 * (dArray[0] + dArray[2]) + 0.5 * (d9 + d));
                        double d10 = d2;
                        d2 = dArray[5];
                        dArray[1] = 0.25 * (1.5 * (dArray[1] + dArray[3]) + 0.5 * (d10 + d2));
                        dArray[2] = d;
                        dArray[3] = d2;
                    }
                }
                this.transform(dArray, 0, dArray, 0, 2);
                Point2D point2D = ShapeUtilities.parabolicControlPoint(d3, d4, dArray[0], dArray[1], dArray[2], dArray[3], n, float_);
                d3 = dArray[2];
                d4 = dArray[3];
                if (point2D != null) {
                    assert (float_ == point2D);
                    generalPath.quadTo(float_.x, float_.y, (float)d3, (float)d4);
                } else {
                    generalPath.lineTo((float)d3, (float)d4);
                }
            }
            pathIterator.next();
        }
        if (affineTransform2 != null) {
            generalPath.transform(affineTransform2);
        }
        return ShapeUtilities.toPrimitive(generalPath);
    }

    public Matrix derivative(Point2D point2D) throws TransformException {
        int n = this.getSourceDimensions();
        if (n != 2) {
            throw new MismatchedDimensionException(AbstractMathTransform.constructMessage("point", 2, n));
        }
        throw new TransformException(Errors.format(19));
    }

    @Override
    public Matrix derivative(DirectPosition directPosition) throws TransformException {
        int n = this.getSourceDimensions();
        if (directPosition == null) {
            if (n == 2) {
                return this.derivative((Point2D)null);
            }
        } else {
            int n2 = directPosition.getDimension();
            if (n2 != n) {
                throw new MismatchedDimensionException(AbstractMathTransform.constructMessage("point", n2, n));
            }
            if (n == 2) {
                if (directPosition instanceof Point2D) {
                    return this.derivative((Point2D)((Object)directPosition));
                }
                return this.derivative(new Point2D.Double(directPosition.getOrdinate(0), directPosition.getOrdinate(1)));
            }
            if (this instanceof MathTransform1D) {
                return new Matrix1(((MathTransform1D)((Object)this)).derivative(directPosition.getOrdinate(0)));
            }
        }
        throw new TransformException(Errors.format(19));
    }

    @Override
    public MathTransform inverse() throws NoninvertibleTransformException {
        if (this.isIdentity()) {
            return this;
        }
        throw new NoninvertibleTransformException(Errors.format(105));
    }

    MathTransform concatenate(MathTransform mathTransform, boolean bl) {
        return null;
    }

    public int hashCode() {
        return this.getSourceDimensions() + 37 * this.getTargetDimensions();
    }

    public boolean equals(Object object) {
        if (object != null && this.getClass().equals(object.getClass())) {
            AbstractMathTransform abstractMathTransform = (AbstractMathTransform)object;
            return Utilities.equals(this.getParameterDescriptors(), abstractMathTransform.getParameterDescriptors());
        }
        return false;
    }

    protected static boolean needCopy(int n, int n2, int n3, int n4, int n5) {
        if (n5 <= 1 || n >= n3 && n2 >= n4) {
            return false;
        }
        return n < n3 + n5 * n4 && n3 < n + n5 * n2;
    }

    protected static double rollLongitude(double d) {
        return d - Math.PI * 2 * Math.floor(d / (Math.PI * 2) + 0.5);
    }

    static XMatrix toXMatrix(Matrix matrix) {
        if (matrix instanceof XMatrix) {
            return (XMatrix)matrix;
        }
        return MatrixFactory.create(matrix);
    }

    static GeneralMatrix toGMatrix(Matrix matrix) {
        if (matrix instanceof GeneralMatrix) {
            return (GeneralMatrix)matrix;
        }
        return new GeneralMatrix(matrix);
    }

    static Matrix invert(Matrix matrix) throws NoninvertibleTransformException {
        try {
            XMatrix xMatrix = AbstractMathTransform.toXMatrix(matrix);
            xMatrix.invert();
            return xMatrix;
        }
        catch (SingularMatrixException singularMatrixException) {
            NoninvertibleTransformException noninvertibleTransformException = new NoninvertibleTransformException(Errors.format(105));
            noninvertibleTransformException.initCause(singularMatrixException);
            throw noninvertibleTransformException;
        }
    }

    protected abstract class Inverse
    extends AbstractMathTransform
    implements Serializable {
        private static final long serialVersionUID = 3528274816628012283L;

        protected Inverse() {
        }

        @Override
        public String getName() {
            return AbstractMathTransform.this.getName() + " (" + Vocabulary.format(114) + ')';
        }

        @Override
        public int getSourceDimensions() {
            return AbstractMathTransform.this.getTargetDimensions();
        }

        @Override
        public int getTargetDimensions() {
            return AbstractMathTransform.this.getSourceDimensions();
        }

        @Override
        public Matrix derivative(Point2D point2D) throws TransformException {
            return Inverse.invert(AbstractMathTransform.this.derivative(this.transform(point2D, null)));
        }

        @Override
        public Matrix derivative(DirectPosition directPosition) throws TransformException {
            return Inverse.invert(AbstractMathTransform.this.derivative(this.transform(directPosition, null)));
        }

        @Override
        public MathTransform inverse() {
            return AbstractMathTransform.this;
        }

        @Override
        public boolean isIdentity() {
            return AbstractMathTransform.this.isIdentity();
        }

        @Override
        public int hashCode() {
            return ~AbstractMathTransform.this.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof Inverse) {
                Inverse inverse = (Inverse)object;
                return Utilities.equals(this.inverse(), inverse.inverse());
            }
            return false;
        }
    }
}

