/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.operation.AbstractCoordinateOperation;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.resources.Classes;
import org.geotools.resources.UnmodifiableArrayList;
import org.geotools.resources.i18n.Errors;
import org.opengis.metadata.quality.PositionalAccuracy;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.operation.ConcatenatedOperation;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.SingleOperation;
import org.opengis.referencing.operation.Transformation;

public class DefaultConcatenatedOperation
extends AbstractCoordinateOperation
implements ConcatenatedOperation {
    private static final long serialVersionUID = 4199619838029045700L;
    private final List<SingleOperation> operations;

    public DefaultConcatenatedOperation(Map<String, ?> map, CoordinateOperation[] coordinateOperationArray, MathTransformFactory mathTransformFactory) throws FactoryException {
        this(map, new ArrayList<SingleOperation>(coordinateOperationArray != null ? coordinateOperationArray.length : 4), coordinateOperationArray, mathTransformFactory);
    }

    private DefaultConcatenatedOperation(Map<String, ?> map, ArrayList<SingleOperation> arrayList, CoordinateOperation[] coordinateOperationArray, MathTransformFactory mathTransformFactory) throws FactoryException {
        this(map, DefaultConcatenatedOperation.expand(coordinateOperationArray, arrayList, mathTransformFactory, true), arrayList);
    }

    private DefaultConcatenatedOperation(Map<String, ?> map, MathTransform mathTransform, List<SingleOperation> list) {
        super(DefaultConcatenatedOperation.mergeAccuracy(map, list), list.get(0).getSourceCRS(), list.get(list.size() - 1).getTargetCRS(), mathTransform);
        this.operations = UnmodifiableArrayList.wrap(list.toArray(new SingleOperation[list.size()]));
    }

    private static MathTransform expand(CoordinateOperation[] coordinateOperationArray, List<SingleOperation> list, MathTransformFactory mathTransformFactory, boolean bl) throws FactoryException {
        int n;
        Object object = null;
        DefaultConcatenatedOperation.ensureNonNull("operations", coordinateOperationArray);
        for (n = 0; n < coordinateOperationArray.length; ++n) {
            Object object2;
            Object object3;
            DefaultConcatenatedOperation.ensureNonNull("operations", coordinateOperationArray, n);
            CoordinateOperation coordinateOperation = coordinateOperationArray[n];
            if (coordinateOperation instanceof SingleOperation) {
                list.add((SingleOperation)coordinateOperation);
            } else if (coordinateOperation instanceof ConcatenatedOperation) {
                object3 = (ConcatenatedOperation)coordinateOperation;
                object2 = object3.getOperations();
                DefaultConcatenatedOperation.expand(object2.toArray(new CoordinateOperation[object2.size()]), list, mathTransformFactory, false);
            } else {
                throw new IllegalArgumentException(Errors.format(61, Classes.getClass(coordinateOperation), SingleOperation.class));
            }
            if (n != 0) {
                int n2;
                int n3;
                object3 = coordinateOperationArray[n - 1].getTargetCRS();
                object2 = coordinateOperation.getSourceCRS();
                if (object3 != null && object2 != null && (n3 = object3.getCoordinateSystem().getDimension()) != (n2 = object2.getCoordinateSystem().getDimension())) {
                    throw new IllegalArgumentException(Errors.format(93, n3, n2));
                }
            }
            if (!bl) continue;
            object3 = coordinateOperation.getMathTransform();
            object = object == null ? object3 : (mathTransformFactory != null ? mathTransformFactory.createConcatenatedTransform((MathTransform)object, (MathTransform)object3) : ConcatenatedTransform.create((MathTransform)object, (MathTransform)object3));
        }
        if (bl && (n = list.size()) <= 1) {
            throw new IllegalArgumentException(Errors.format(99, "operations[" + n + ']'));
        }
        return object;
    }

    private static Map<String, ?> mergeAccuracy(Map<String, ?> map, List<? extends CoordinateOperation> list) {
        if (!map.containsKey("coordinateOperationAccuracy")) {
            LinkedHashSet<PositionalAccuracy> linkedHashSet = null;
            for (CoordinateOperation coordinateOperation : list) {
                Collection<PositionalAccuracy> collection;
                if (!(coordinateOperation instanceof Transformation) || (collection = coordinateOperation.getCoordinateOperationAccuracy()) == null || collection.isEmpty()) continue;
                if (linkedHashSet == null) {
                    linkedHashSet = new LinkedHashSet<PositionalAccuracy>();
                }
                linkedHashSet.addAll(collection);
            }
            if (linkedHashSet != null) {
                HashMap<String, ?> hashMap = new HashMap(map);
                hashMap.put("coordinateOperationAccuracy", linkedHashSet.toArray(new PositionalAccuracy[linkedHashSet.size()]));
                return hashMap;
            }
        }
        return map;
    }

    @Override
    public List<SingleOperation> getOperations() {
        return this.operations;
    }

    @Override
    public boolean equals(AbstractIdentifiedObject abstractIdentifiedObject, boolean bl) {
        if (abstractIdentifiedObject == this) {
            return true;
        }
        if (super.equals(abstractIdentifiedObject, bl)) {
            DefaultConcatenatedOperation defaultConcatenatedOperation = (DefaultConcatenatedOperation)abstractIdentifiedObject;
            return DefaultConcatenatedOperation.equals(this.operations, defaultConcatenatedOperation.operations, bl);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return ((Object)this.operations).hashCode() ^ 0xFD679FC4;
    }
}

