/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.geotools.factory.Factory;
import org.geotools.factory.FactoryCreator;
import org.geotools.factory.FactoryRegistry;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultCompoundCRS;
import org.geotools.referencing.cs.AbstractCS;
import org.geotools.referencing.factory.ReferencingFactory;
import org.geotools.referencing.operation.DefiningConversion;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.crs.CompoundCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;

public class ReferencingFactoryContainer
extends ReferencingFactory {
    private static FactoryRegistry cache;
    private DatumFactory datumFactory;
    private CSFactory csFactory;
    private CRSFactory crsFactory;
    private MathTransformFactory mtFactory;

    public ReferencingFactoryContainer(Hints hints) {
        Hints hints2 = new Hints(hints);
        this.datumFactory = (DatumFactory)((Object)ReferencingFactoryContainer.extract(hints2, Hints.DATUM_FACTORY));
        this.csFactory = (CSFactory)((Object)ReferencingFactoryContainer.extract(hints2, Hints.CS_FACTORY));
        this.crsFactory = (CRSFactory)((Object)ReferencingFactoryContainer.extract(hints2, Hints.CRS_FACTORY));
        this.mtFactory = (MathTransformFactory)((Object)ReferencingFactoryContainer.extract(hints2, Hints.MATH_TRANSFORM_FACTORY));
        if (!hints2.isEmpty()) {
            this.setHintsInto(hints2);
            this.addImplementationHints(hints2);
            this.initialize();
            this.hints.clear();
        }
    }

    private static Factory extract(Map<?, ?> map, Hints.Key key) {
        Object obj;
        if (map != null && (obj = map.get(key)) instanceof Factory) {
            map.remove(key);
            return (Factory)obj;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReferencingFactoryContainer instance(Hints hints) {
        Hints hints2 = GeoTools.getDefaultHints();
        if (hints != null) {
            hints2.add(hints);
        }
        Class<ReferencingFactoryFinder> clazz = ReferencingFactoryFinder.class;
        synchronized (ReferencingFactoryFinder.class) {
            if (cache == null) {
                cache = new FactoryCreator(Arrays.asList(ReferencingFactoryContainer.class));
                cache.registerServiceProvider(new ReferencingFactoryContainer(null), ReferencingFactoryContainer.class);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return cache.getServiceProvider(ReferencingFactoryContainer.class, null, hints2, null);
        }
    }

    private void initialize() {
        this.mtFactory = this.getMathTransformFactory();
        this.datumFactory = this.getDatumFactory();
        this.csFactory = this.getCSFactory();
        this.crsFactory = this.getCRSFactory();
    }

    private void setHintsInto(Map<? super RenderingHints.Key, Object> map) {
        if (this.crsFactory != null) {
            map.put(Hints.CRS_FACTORY, this.crsFactory);
        }
        if (this.csFactory != null) {
            map.put(Hints.CS_FACTORY, this.csFactory);
        }
        if (this.datumFactory != null) {
            map.put(Hints.DATUM_FACTORY, this.datumFactory);
        }
        if (this.mtFactory != null) {
            map.put(Hints.MATH_TRANSFORM_FACTORY, this.mtFactory);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<RenderingHints.Key, ?> getImplementationHints() {
        Map map = this.hints;
        synchronized (map) {
            if (this.hints.isEmpty()) {
                this.initialize();
                this.setHintsInto(this.hints);
            }
        }
        return super.getImplementationHints();
    }

    private Hints hints() {
        Hints hints = new Hints(this.hints);
        this.setHintsInto(hints);
        return hints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatumFactory getDatumFactory() {
        if (this.datumFactory == null) {
            Map map = this.hints;
            synchronized (map) {
                this.datumFactory = ReferencingFactoryFinder.getDatumFactory(this.hints());
            }
        }
        return this.datumFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CSFactory getCSFactory() {
        if (this.csFactory == null) {
            Map map = this.hints;
            synchronized (map) {
                this.csFactory = ReferencingFactoryFinder.getCSFactory(this.hints());
            }
        }
        return this.csFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CRSFactory getCRSFactory() {
        if (this.crsFactory == null) {
            Map map = this.hints;
            synchronized (map) {
                this.crsFactory = ReferencingFactoryFinder.getCRSFactory(this.hints());
            }
        }
        return this.crsFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MathTransformFactory getMathTransformFactory() {
        if (this.mtFactory == null) {
            Map map = this.hints;
            synchronized (map) {
                this.mtFactory = ReferencingFactoryFinder.getMathTransformFactory(this.hints());
            }
        }
        return this.mtFactory;
    }

    public CoordinateReferenceSystem toGeodetic3D(CompoundCRS compoundCRS) throws FactoryException {
        SingleCRS singleCRS;
        int n;
        List<SingleCRS> list = DefaultCompoundCRS.getSingleCRS(compoundCRS);
        int n2 = list.size();
        SingleCRS singleCRS2 = null;
        VerticalCRS verticalCRS = null;
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < n2; ++n) {
            singleCRS = list.get(n);
            if (singleCRS instanceof VerticalCRS) {
                if (verticalCRS == null && VerticalDatumType.ELLIPSOIDAL.equals((verticalCRS = (VerticalCRS)singleCRS).getDatum().getVerticalDatumType())) {
                    n4 = n;
                    continue;
                }
                return compoundCRS;
            }
            if (!(singleCRS instanceof GeographicCRS) && !(singleCRS instanceof ProjectedCRS)) continue;
            if (singleCRS2 == null && (singleCRS2 = singleCRS).getCoordinateSystem().getDimension() == 2) {
                n3 = n;
                continue;
            }
            return compoundCRS;
        }
        if (singleCRS2 != null && verticalCRS != null && Math.abs(n4 - n3) == 1) {
            n = n3 < n4 ? 1 : 0;
            singleCRS = this.toGeodetic3D(n2 == 2 ? compoundCRS : null, singleCRS2, verticalCRS, n != 0);
            if (n2 == 2) {
                return singleCRS;
            }
            int n5 = n != 0 ? n3 : n4;
            list = new ArrayList<SingleCRS>(list);
            list.remove(n5);
            list.set(n5, singleCRS);
            CoordinateReferenceSystem[] coordinateReferenceSystemArray = list.toArray(new SingleCRS[list.size()]);
            return this.crsFactory.createCompoundCRS(AbstractIdentifiedObject.getProperties(compoundCRS), coordinateReferenceSystemArray);
        }
        return compoundCRS;
    }

    private SingleCRS toGeodetic3D(CompoundCRS compoundCRS, SingleCRS singleCRS, VerticalCRS verticalCRS, boolean bl) throws FactoryException {
        Map<String, ?> map;
        Map<String, ?> map2;
        CoordinateSystemAxis[] coordinateSystemAxisArray = new CoordinateSystemAxis[3];
        CoordinateSystem coordinateSystem = singleCRS.getCoordinateSystem();
        coordinateSystemAxisArray[bl ? 0 : 1] = coordinateSystem.getAxis(0);
        coordinateSystemAxisArray[bl ? 1 : 2] = coordinateSystem.getAxis(1);
        coordinateSystemAxisArray[bl ? 2 : 0] = verticalCRS.getCoordinateSystem().getAxis(0);
        if (compoundCRS != null) {
            map2 = AbstractIdentifiedObject.getProperties(compoundCRS.getCoordinateSystem());
            map = AbstractIdentifiedObject.getProperties(compoundCRS);
        } else {
            map2 = ReferencingFactoryContainer.getTemporaryName(coordinateSystem);
            map = ReferencingFactoryContainer.getTemporaryName(singleCRS);
        }
        CSFactory cSFactory = this.getCSFactory();
        CRSFactory cRSFactory = this.getCRSFactory();
        if (singleCRS instanceof GeographicCRS) {
            GeographicCRS geographicCRS = (GeographicCRS)singleCRS;
            EllipsoidalCS ellipsoidalCS = cSFactory.createEllipsoidalCS(map2, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1], coordinateSystemAxisArray[2]);
            return cRSFactory.createGeographicCRS(map, geographicCRS.getDatum(), ellipsoidalCS);
        }
        if (singleCRS instanceof ProjectedCRS) {
            ProjectedCRS projectedCRS = (ProjectedCRS)singleCRS;
            CartesianCS cartesianCS = cSFactory.createCartesianCS(map2, coordinateSystemAxisArray[0], coordinateSystemAxisArray[1], coordinateSystemAxisArray[2]);
            GeographicCRS geographicCRS = projectedCRS.getBaseCRS();
            GeographicCRS geographicCRS2 = (GeographicCRS)this.toGeodetic3D(null, geographicCRS, verticalCRS, bl);
            Matrix matrix = ReferencingFactoryContainer.toStandard(geographicCRS, false);
            Matrix matrix2 = ReferencingFactoryContainer.toStandard(projectedCRS, true);
            Conversion conversion = projectedCRS.getConversionFromBase();
            if (!matrix.isIdentity() || !matrix2.isIdentity()) {
                MathTransformFactory mathTransformFactory = this.getMathTransformFactory();
                MathTransform mathTransform = conversion.getMathTransform();
                mathTransform = mathTransformFactory.createConcatenatedTransform(mathTransformFactory.createConcatenatedTransform(mathTransformFactory.createAffineTransform(matrix), mathTransform), mathTransformFactory.createAffineTransform(matrix2));
                conversion = new DefiningConversion(AbstractCS.getProperties(conversion), conversion.getMethod(), mathTransform);
            }
            return cRSFactory.createProjectedCRS(map, geographicCRS2, conversion, cartesianCS);
        }
        throw new AssertionError(singleCRS);
    }

    private static Matrix toStandard(CoordinateReferenceSystem coordinateReferenceSystem, boolean bl) {
        CoordinateSystem coordinateSystem = coordinateReferenceSystem.getCoordinateSystem();
        CoordinateSystem coordinateSystem2 = AbstractCS.standard(coordinateSystem);
        if (bl) {
            return AbstractCS.swapAndScaleAxis(coordinateSystem2, coordinateSystem);
        }
        return AbstractCS.swapAndScaleAxis(coordinateSystem, coordinateSystem2);
    }

    private static Map<String, ?> getTemporaryName(IdentifiedObject identifiedObject) {
        return Collections.singletonMap("name", identifiedObject.getName().getCode() + " (3D)");
    }
}

