/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.CRS;
import org.geotools.referencing.factory.AuthorityFactoryProxy;
import org.geotools.referencing.factory.ReferencingFactory;
import org.geotools.util.logging.Logging;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.util.GenericName;

public class IdentifiedObjectFinder {
    public static final Logger LOGGER = Logging.getLogger("org.geotools.referencing.factory.finder");
    private AuthorityFactoryProxy proxy;
    private boolean fullScan = true;

    protected IdentifiedObjectFinder() {
    }

    IdentifiedObjectFinder(IdentifiedObjectFinder identifiedObjectFinder) {
        this.setProxy(identifiedObjectFinder.getProxy());
    }

    protected IdentifiedObjectFinder(AuthorityFactory authorityFactory, Class clazz) {
        this.setProxy(AuthorityFactoryProxy.getInstance(authorityFactory, clazz));
    }

    protected AuthorityFactoryProxy getProxy() {
        return this.proxy;
    }

    public boolean isFullScanAllowed() {
        return this.fullScan;
    }

    public void setFullScanAllowed(boolean bl) {
        this.fullScan = bl;
    }

    public IdentifiedObject find(IdentifiedObject identifiedObject) throws FactoryException {
        IdentifiedObject identifiedObject2 = this.createFromIdentifiers(identifiedObject);
        if (identifiedObject2 != null) {
            return identifiedObject2;
        }
        identifiedObject2 = this.createFromNames(identifiedObject);
        if (identifiedObject2 != null) {
            return identifiedObject2;
        }
        return this.fullScan ? this.createFromCodes(identifiedObject) : null;
    }

    public String findIdentifier(IdentifiedObject identifiedObject) throws FactoryException {
        IdentifiedObject identifiedObject2 = this.find(identifiedObject);
        return identifiedObject2 != null ? this.getIdentifier(identifiedObject2) : null;
    }

    protected Citation getAuthority() {
        return this.getProxy().getAuthorityFactory().getAuthority();
    }

    final String getIdentifier(IdentifiedObject identifiedObject) {
        ReferenceIdentifier referenceIdentifier;
        Citation citation = this.getAuthority();
        if (ReferencingFactory.ALL.equals(citation)) {
            citation = null;
        }
        if ((referenceIdentifier = AbstractIdentifiedObject.getIdentifier(identifiedObject, citation)) == null) {
            referenceIdentifier = identifiedObject.getName();
        }
        String string = referenceIdentifier.getCodeSpace();
        String string2 = referenceIdentifier.getCode();
        if (string != null) {
            return string + ':' + string2;
        }
        return string2;
    }

    final IdentifiedObject createFromIdentifiers(IdentifiedObject identifiedObject) throws FactoryException {
        Citation citation = this.getProxy().getAuthorityFactory().getAuthority();
        boolean bl = ReferencingFactory.ALL.equals(citation);
        for (Identifier identifier : identifiedObject.getIdentifiers()) {
            IdentifiedObject identifiedObject2;
            if (!bl && !Citations.identifierMatches(citation, identifier.getAuthority())) continue;
            try {
                identifiedObject2 = this.getProxy().create(identifier.getCode());
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                continue;
            }
            if ((identifiedObject2 = this.deriveEquivalent(identifiedObject2, identifiedObject)) == null) continue;
            return identifiedObject2;
        }
        return null;
    }

    final IdentifiedObject createFromNames(IdentifiedObject identifiedObject) throws FactoryException {
        IdentifiedObject identifiedObject2;
        try {
            identifiedObject2 = this.getProxy().create(identifiedObject.getName().getCode());
            identifiedObject2 = this.deriveEquivalent(identifiedObject2, identifiedObject);
            if (identifiedObject2 != null) {
                return identifiedObject2;
            }
        }
        catch (FactoryException factoryException) {
            // empty catch block
        }
        for (GenericName genericName : identifiedObject.getAlias()) {
            try {
                identifiedObject2 = this.getProxy().create(((Object)genericName).toString());
            }
            catch (FactoryException factoryException) {
                continue;
            }
            if ((identifiedObject2 = this.deriveEquivalent(identifiedObject2, identifiedObject)) == null) continue;
            return identifiedObject2;
        }
        return null;
    }

    final IdentifiedObject createFromCodes(IdentifiedObject identifiedObject) throws FactoryException {
        Set set = this.getCodeCandidates(identifiedObject);
        for (String string : set) {
            IdentifiedObject identifiedObject2;
            try {
                identifiedObject2 = this.getProxy().create(string);
            }
            catch (FactoryException factoryException) {
                LOGGER.log(Level.FINEST, "Could not create '" + string + "':" + factoryException);
                continue;
            }
            catch (Exception exception) {
                LOGGER.log(Level.FINEST, "Could not create '" + string + "':" + exception, exception);
                continue;
            }
            if ((identifiedObject2 = this.deriveEquivalent(identifiedObject2, identifiedObject)) == null) continue;
            return identifiedObject2;
        }
        return null;
    }

    protected Set getCodeCandidates(IdentifiedObject identifiedObject) throws FactoryException {
        return this.getProxy().getAuthorityCodes();
    }

    protected IdentifiedObject deriveEquivalent(IdentifiedObject identifiedObject, IdentifiedObject identifiedObject2) throws FactoryException {
        return CRS.equalsIgnoreMetadata(identifiedObject, identifiedObject2) ? identifiedObject : null;
    }

    public String toString() {
        return this.getProxy().toString(IdentifiedObjectFinder.class);
    }

    public void setProxy(AuthorityFactoryProxy authorityFactoryProxy) {
        this.proxy = authorityFactoryProxy;
    }

    static class Adapter
    extends IdentifiedObjectFinder {
        protected final IdentifiedObjectFinder finder;

        protected Adapter(IdentifiedObjectFinder identifiedObjectFinder) {
            super(identifiedObjectFinder);
            this.finder = identifiedObjectFinder;
        }

        @Override
        public void setFullScanAllowed(boolean bl) {
            this.finder.setFullScanAllowed(bl);
            super.setFullScanAllowed(bl);
        }

        @Override
        protected Set getCodeCandidates(IdentifiedObject identifiedObject) throws FactoryException {
            return this.finder.getCodeCandidates(identifiedObject);
        }

        @Override
        protected IdentifiedObject deriveEquivalent(IdentifiedObject identifiedObject, IdentifiedObject identifiedObject2) throws FactoryException {
            return this.finder.deriveEquivalent(identifiedObject, identifiedObject2);
        }
    }
}

