/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.parameter;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.parameter.AbstractParameterDescriptor;
import org.geotools.parameter.ParameterGroup;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.resources.UnmodifiableArrayList;
import org.geotools.resources.i18n.Errors;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.InvalidParameterNameException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;

public class DefaultParameterDescriptorGroup
extends AbstractParameterDescriptor
implements ParameterDescriptorGroup {
    private static final long serialVersionUID = -4613190550542423839L;
    private final int maximumOccurs;
    private final GeneralParameterDescriptor[] parameters;
    private transient List<GeneralParameterDescriptor> asList;

    public DefaultParameterDescriptorGroup(String string, GeneralParameterDescriptor[] generalParameterDescriptorArray) {
        this(Collections.singletonMap("name", string), generalParameterDescriptorArray);
    }

    public DefaultParameterDescriptorGroup(Map<String, ?> map, GeneralParameterDescriptor[] generalParameterDescriptorArray) {
        this(map, 1, 1, generalParameterDescriptorArray);
    }

    public DefaultParameterDescriptorGroup(Map<String, ?> map, int n, int n2, GeneralParameterDescriptor[] generalParameterDescriptorArray) {
        super(map, n, n2);
        int n3;
        this.maximumOccurs = n2;
        DefaultParameterDescriptorGroup.ensureNonNull("parameters", generalParameterDescriptorArray);
        this.parameters = new GeneralParameterDescriptor[generalParameterDescriptorArray.length];
        for (n3 = 0; n3 < generalParameterDescriptorArray.length; ++n3) {
            this.parameters[n3] = generalParameterDescriptorArray[n3];
            DefaultParameterDescriptorGroup.ensureNonNull("parameters", generalParameterDescriptorArray, n3);
        }
        generalParameterDescriptorArray = this.parameters;
        for (n3 = 0; n3 < generalParameterDescriptorArray.length; ++n3) {
            String string = generalParameterDescriptorArray[n3].getName().getCode();
            for (int i = 0; i < generalParameterDescriptorArray.length; ++i) {
                if (n3 == i || !DefaultParameterDescriptorGroup.nameMatches((IdentifiedObject)generalParameterDescriptorArray[i], string)) continue;
                throw new InvalidParameterNameException(Errors.format(154, generalParameterDescriptorArray[i].getName().getCode(), i, string, n3), string);
            }
        }
    }

    @Override
    public int getMaximumOccurs() {
        return this.maximumOccurs;
    }

    @Override
    public ParameterValueGroup createValue() {
        return new ParameterGroup(this);
    }

    @Override
    public List<GeneralParameterDescriptor> descriptors() {
        if (this.asList == null) {
            if (this.parameters == null) {
                this.asList = Collections.emptyList();
            } else {
                switch (this.parameters.length) {
                    case 0: {
                        this.asList = Collections.emptyList();
                        break;
                    }
                    case 1: {
                        this.asList = Collections.singletonList(this.parameters[0]);
                        break;
                    }
                    case 2: 
                    case 3: {
                        this.asList = UnmodifiableArrayList.wrap(this.parameters);
                        break;
                    }
                    default: {
                        this.asList = new AsList(this.parameters);
                    }
                }
            }
        }
        return this.asList;
    }

    @Override
    public GeneralParameterDescriptor descriptor(String string) throws ParameterNotFoundException {
        DefaultParameterDescriptorGroup.ensureNonNull("name", string);
        string = string.trim();
        LinkedList<DefaultParameterDescriptorGroup> linkedList = null;
        List<GeneralParameterDescriptor> list = this.descriptors();
        while (list != null) {
            for (GeneralParameterDescriptor generalParameterDescriptor : list) {
                if (generalParameterDescriptor instanceof ParameterDescriptor) {
                    if (!DefaultParameterDescriptorGroup.nameMatches((IdentifiedObject)generalParameterDescriptor, string)) continue;
                    return generalParameterDescriptor;
                }
                if (!(generalParameterDescriptor instanceof DefaultParameterDescriptorGroup)) continue;
                if (linkedList == null) {
                    linkedList = new LinkedList<DefaultParameterDescriptorGroup>();
                }
                assert (!linkedList.contains(generalParameterDescriptor)) : generalParameterDescriptor;
                linkedList.add((DefaultParameterDescriptorGroup)generalParameterDescriptor);
            }
            if (linkedList == null || linkedList.isEmpty()) break;
            list = ((DefaultParameterDescriptorGroup)linkedList.remove(0)).descriptors();
        }
        throw new ParameterNotFoundException(Errors.format(99, string), string);
    }

    @Override
    public boolean equals(AbstractIdentifiedObject abstractIdentifiedObject, boolean bl) {
        if (abstractIdentifiedObject == this) {
            return true;
        }
        if (super.equals(abstractIdentifiedObject, bl)) {
            DefaultParameterDescriptorGroup defaultParameterDescriptorGroup = (DefaultParameterDescriptorGroup)abstractIdentifiedObject;
            return Arrays.equals(this.parameters, defaultParameterDescriptorGroup.parameters);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        for (int i = 0; i < this.parameters.length; ++i) {
            n = n * 37 + this.parameters[i].hashCode();
        }
        return n;
    }

    private static final class AsList
    extends UnmodifiableArrayList<GeneralParameterDescriptor> {
        private static final long serialVersionUID = -2116304004367396735L;
        private transient Set<GeneralParameterDescriptor> asSet;

        public AsList(GeneralParameterDescriptor[] generalParameterDescriptorArray) {
            super(generalParameterDescriptorArray);
        }

        @Override
        public boolean contains(Object object) {
            if (this.asSet == null) {
                this.asSet = new HashSet<GeneralParameterDescriptor>(this);
            }
            return this.asSet.contains(object);
        }
    }
}

