/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.citation;

import java.net.URI;
import java.net.URISyntaxException;
import org.geotools.metadata.iso.MetadataEntity;
import org.opengis.metadata.citation.OnLineFunction;
import org.opengis.metadata.citation.OnLineResource;
import org.opengis.util.InternationalString;

public class OnLineResourceImpl
extends MetadataEntity
implements OnLineResource {
    private static final long serialVersionUID = 5412370008274334799L;
    public static final OnLineResource OGC;
    public static final OnLineResource OPEN_GIS;
    public static final OnLineResource EPSG;
    public static final OnLineResource GEOTIFF;
    public static final OnLineResource ESRI;
    public static final OnLineResource ORACLE;
    public static final OnLineResource SUN_MICROSYSTEMS;
    public static final OnLineResource GEOTOOLS;
    public static final OnLineResource WMS;
    private String applicationProfile;
    private InternationalString description;
    private OnLineFunction function;
    private URI linkage;
    private String name;

    public OnLineResourceImpl() {
    }

    private OnLineResourceImpl(String string) {
        try {
            this.setLinkage(new URI(string));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException);
        }
        this.setFunction(OnLineFunction.INFORMATION);
    }

    public OnLineResourceImpl(URI uRI) {
        this.setLinkage(uRI);
    }

    public String getApplicationProfile() {
        return this.applicationProfile;
    }

    public synchronized void setApplicationProfile(String string) {
        this.checkWritePermission();
        this.applicationProfile = string;
    }

    public String getName() {
        return this.name;
    }

    public synchronized void setName(String string) {
        this.checkWritePermission();
        this.name = string;
    }

    public InternationalString getDescription() {
        return this.description;
    }

    public synchronized void setDescription(InternationalString internationalString) {
        this.checkWritePermission();
        this.description = internationalString;
    }

    public OnLineFunction getFunction() {
        return this.function;
    }

    public synchronized void setFunction(OnLineFunction onLineFunction) {
        this.checkWritePermission();
        this.function = onLineFunction;
    }

    public URI getLinkage() {
        return this.linkage;
    }

    public synchronized void setLinkage(URI uRI) {
        this.checkWritePermission();
        this.linkage = uRI;
    }

    public String getProtocol() {
        URI uRI = this.linkage;
        return uRI != null ? uRI.getScheme() : null;
    }

    static {
        OnLineResourceImpl onLineResourceImpl = new OnLineResourceImpl("http://www.opengeospatial.org/");
        OGC = onLineResourceImpl;
        onLineResourceImpl.freeze();
        onLineResourceImpl = new OnLineResourceImpl("http://www.opengis.org");
        OPEN_GIS = onLineResourceImpl;
        onLineResourceImpl.freeze();
        onLineResourceImpl = new OnLineResourceImpl("http://www.epsg.org");
        EPSG = onLineResourceImpl;
        onLineResourceImpl.freeze();
        onLineResourceImpl = new OnLineResourceImpl("http://www.remotesensing.org/geotiff");
        GEOTIFF = onLineResourceImpl;
        onLineResourceImpl.freeze();
        onLineResourceImpl = new OnLineResourceImpl("http://www.esri.com");
        ESRI = onLineResourceImpl;
        onLineResourceImpl.freeze();
        onLineResourceImpl = new OnLineResourceImpl("http://www.oracle.com");
        ORACLE = onLineResourceImpl;
        onLineResourceImpl.freeze();
        onLineResourceImpl = new OnLineResourceImpl("http://java.sun.com");
        SUN_MICROSYSTEMS = onLineResourceImpl;
        onLineResourceImpl.freeze();
        onLineResourceImpl = new OnLineResourceImpl("http://www.geotools.org");
        GEOTOOLS = onLineResourceImpl;
        onLineResourceImpl.freeze();
        onLineResourceImpl = new OnLineResourceImpl("http://portal.opengis.org/files/?artifact_id=5316");
        WMS = onLineResourceImpl;
        onLineResourceImpl.setFunction(OnLineFunction.DOWNLOAD);
        onLineResourceImpl.freeze();
    }
}

