/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.simple;

import com.vividsolutions.jts.geom.Geometry;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleSchema;
import org.geotools.feature.type.BasicFeatureTypes;
import org.geotools.feature.type.FeatureTypeFactoryImpl;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.AttributeType;
import org.opengis.feature.type.FeatureTypeFactory;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.Schema;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.InternationalString;

public class SimpleFeatureTypeBuilder {
    protected FeatureTypeFactory factory;
    protected Map bindings;
    protected String local;
    protected String uri;
    protected InternationalString description;
    protected List<AttributeDescriptor> attributes;
    protected List<Filter> restrictions;
    protected String defaultGeometry;
    protected CoordinateReferenceSystem crs;
    protected boolean isAbstract = false;
    protected SimpleFeatureType superType;
    protected AttributeTypeBuilder attributeBuilder;

    public SimpleFeatureTypeBuilder() {
        this(new FeatureTypeFactoryImpl());
    }

    public SimpleFeatureTypeBuilder(FeatureTypeFactory featureTypeFactory) {
        this.factory = featureTypeFactory;
        this.attributeBuilder = new AttributeTypeBuilder();
        this.setBindings(new SimpleSchema());
        this.reset();
    }

    public void init(SimpleFeatureType simpleFeatureType) {
        this.init();
        if (simpleFeatureType == null) {
            return;
        }
        this.uri = simpleFeatureType.getName().getNamespaceURI();
        this.local = simpleFeatureType.getName().getLocalPart();
        this.description = simpleFeatureType.getDescription();
        this.restrictions = null;
        this.restrictions().addAll(simpleFeatureType.getRestrictions());
        this.attributes = null;
        this.attributes().addAll(simpleFeatureType.getAttributeDescriptors());
        this.isAbstract = simpleFeatureType.isAbstract();
        this.superType = (SimpleFeatureType)simpleFeatureType.getSuper();
    }

    protected void init() {
        this.attributes = null;
    }

    protected void reset() {
        this.uri = "http://www.opengis.net/gml";
        this.local = null;
        this.description = null;
        this.restrictions = null;
        this.attributes = null;
        this.crs = null;
        this.isAbstract = false;
        this.superType = BasicFeatureTypes.FEATURE;
    }

    public void setNamespaceURI(String string) {
        this.uri = string;
    }

    public void setNamespaceURI(URI uRI) {
        if (uRI != null) {
            this.setNamespaceURI(uRI.toString());
        } else {
            this.setNamespaceURI((String)null);
        }
    }

    public void setName(String string) {
        this.local = string;
    }

    public void setName(Name name) {
        this.setName(name.getLocalPart());
        this.setNamespaceURI(name.getNamespaceURI());
    }

    public void setDefaultGeometry(String string) {
        this.defaultGeometry = string;
    }

    public void setAbstract(boolean bl) {
        this.isAbstract = bl;
    }

    public void setSuperType(SimpleFeatureType simpleFeatureType) {
        this.superType = simpleFeatureType;
    }

    public void addBinding(AttributeType attributeType) {
        this.bindings().put(attributeType.getBinding(), attributeType);
    }

    public void addBindings(Schema schema) {
        for (AttributeType attributeType : schema.values()) {
            this.addBinding(attributeType);
        }
    }

    public void setBindings(Schema schema) {
        this.bindings().clear();
        this.addBindings(schema);
    }

    public SimpleFeatureTypeBuilder minOccurs(int n) {
        this.attributeBuilder.setMinOccurs(n);
        return this;
    }

    public SimpleFeatureTypeBuilder maxOccurs(int n) {
        this.attributeBuilder.setMaxOccurs(n);
        return this;
    }

    public SimpleFeatureTypeBuilder nillable(boolean bl) {
        this.attributeBuilder.setNillable(bl);
        return this;
    }

    public SimpleFeatureTypeBuilder defaultValue(Object object) {
        this.attributeBuilder.setDefaultValue(object);
        return this;
    }

    public SimpleFeatureTypeBuilder crs(CoordinateReferenceSystem coordinateReferenceSystem) {
        this.attributeBuilder.setCRS(coordinateReferenceSystem);
        return this;
    }

    public SimpleFeatureTypeBuilder descriptor(AttributeDescriptor attributeDescriptor) {
        this.minOccurs(attributeDescriptor.getMinOccurs());
        this.maxOccurs(attributeDescriptor.getMaxOccurs());
        this.nillable(attributeDescriptor.isNillable());
        this.defaultValue(attributeDescriptor.getDefaultValue());
        if (attributeDescriptor instanceof GeometryDescriptor) {
            this.crs(((GeometryDescriptor)attributeDescriptor).getCoordinateReferenceSystem());
        }
        return this;
    }

    public void add(String string, Class clazz) {
        AttributeDescriptor attributeDescriptor = null;
        this.attributeBuilder.setBinding(clazz);
        this.attributeBuilder.setName(string);
        if (this.defaultGeometry != null && this.defaultGeometry.equals(string) || Geometry.class.isAssignableFrom(clazz)) {
            if (!this.attributeBuilder.isCRSSet()) {
                this.attributeBuilder.setCRS(this.crs);
            }
            GeometryType geometryType = this.attributeBuilder.buildGeometryType();
            attributeDescriptor = this.attributeBuilder.buildDescriptor(string, geometryType);
        } else {
            AttributeType attributeType = this.attributeBuilder.buildType();
            attributeDescriptor = this.attributeBuilder.buildDescriptor(string, attributeType);
        }
        this.attributes().add(attributeDescriptor);
    }

    public void add(AttributeDescriptor attributeDescriptor) {
        this.attributes().add(attributeDescriptor);
    }

    public void addAll(List<AttributeDescriptor> list) {
        if (list != null) {
            for (AttributeDescriptor attributeDescriptor : list) {
                this.add(attributeDescriptor);
            }
        }
    }

    public void addAll(AttributeDescriptor[] attributeDescriptorArray) {
        if (attributeDescriptorArray != null) {
            for (AttributeDescriptor attributeDescriptor : attributeDescriptorArray) {
                this.add(attributeDescriptor);
            }
        }
    }

    public SimpleFeatureType buildFeatureType() {
        Object object;
        GeometryDescriptor geometryDescriptor = null;
        if (this.defaultGeometry != null) {
            object = this.attributes();
            for (int i = 0; i < object.size(); ++i) {
                AttributeDescriptor attributeDescriptor = (AttributeDescriptor)object.get(i);
                if (!this.defaultGeometry.equals(attributeDescriptor.getName().getLocalPart())) continue;
                if (!(attributeDescriptor instanceof GeometryDescriptor)) {
                    this.attributeBuilder.init(attributeDescriptor);
                    this.attributeBuilder.setCRS(this.crs);
                    GeometryType geometryType = this.attributeBuilder.buildGeometryType();
                    attributeDescriptor = this.attributeBuilder.buildDescriptor(attributeDescriptor.getName(), geometryType);
                    object.set(i, attributeDescriptor);
                }
                geometryDescriptor = (GeometryDescriptor)attributeDescriptor;
                break;
            }
            if (geometryDescriptor == null) {
                String string = "'" + this.defaultGeometry + " specified as default" + " but could find no such attribute.";
                throw new IllegalArgumentException(string);
            }
        }
        if (geometryDescriptor == null) {
            for (AttributeDescriptor attributeDescriptor : this.attributes()) {
                if (!(attributeDescriptor instanceof GeometryDescriptor)) continue;
                geometryDescriptor = (GeometryDescriptor)attributeDescriptor;
                break;
            }
        }
        object = this.factory.createSimpleFeatureType(this.name(), this.attributes(), geometryDescriptor, this.isAbstract, this.restrictions(), this.superType, this.description);
        this.init();
        return object;
    }

    protected List newList() {
        return new ArrayList();
    }

    protected Map newMap() {
        return new HashMap();
    }

    protected Name name() {
        if (this.local == null) {
            return null;
        }
        return new NameImpl(this.uri, this.local);
    }

    protected List<AttributeDescriptor> attributes() {
        if (this.attributes == null) {
            this.attributes = this.newList();
        }
        return this.attributes;
    }

    protected List<Filter> restrictions() {
        if (this.restrictions == null) {
            this.restrictions = this.newList();
        }
        return this.restrictions;
    }

    protected Map bindings() {
        if (this.bindings == null) {
            this.bindings = this.newMap();
        }
        return this.bindings;
    }

    public static SimpleFeatureType retype(SimpleFeatureType simpleFeatureType, String[] stringArray) {
        SimpleFeatureTypeBuilder simpleFeatureTypeBuilder = new SimpleFeatureTypeBuilder();
        simpleFeatureTypeBuilder.init(simpleFeatureType);
        simpleFeatureTypeBuilder.attributes().clear();
        for (int i = 0; i < stringArray.length; ++i) {
            simpleFeatureTypeBuilder.add(simpleFeatureType.getDescriptor(stringArray[i]));
        }
        return simpleFeatureTypeBuilder.buildFeatureType();
    }
}

