/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.factory;

import java.awt.RenderingHints;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.naming.Name;
import javax.sql.DataSource;
import org.geotools.factory.AbstractFactory;
import org.geotools.factory.GeoTools;
import org.geotools.factory.StrictHints;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.util.InternationalString;

public class Hints
extends RenderingHints {
    private static final Hints GLOBAL = new Hints();
    private static boolean needScan = true;
    public static final ClassKey CRS_AUTHORITY_FACTORY = new ClassKey("org.opengis.referencing.crs.CRSAuthorityFactory");
    public static final ClassKey CS_AUTHORITY_FACTORY = new ClassKey("org.opengis.referencing.cs.CSAuthorityFactory");
    public static final ClassKey DATUM_AUTHORITY_FACTORY = new ClassKey("org.opengis.referencing.datum.DatumAuthorityFactory");
    public static final ClassKey CRS_FACTORY = new ClassKey("org.opengis.referencing.crs.CRSFactory");
    public static final ClassKey CS_FACTORY = new ClassKey("org.opengis.referencing.cs.CSFactory");
    public static final ClassKey DATUM_FACTORY = new ClassKey("org.opengis.referencing.datum.DatumFactory");
    public static final ClassKey COORDINATE_OPERATION_FACTORY = new ClassKey("org.opengis.referencing.operation.CoordinateOperationFactory");
    public static final ClassKey COORDINATE_OPERATION_AUTHORITY_FACTORY = new ClassKey("org.opengis.referencing.operation.CoordinateOperationAuthorityFactory");
    public static final ClassKey MATH_TRANSFORM_FACTORY = new ClassKey("org.opengis.referencing.operation.MathTransformFactory");
    public static final FileKey CRS_AUTHORITY_EXTRA_DIRECTORY = new FileKey(false);
    public static final Key EPSG_DATA_SOURCE = new DataSourceKey();
    public static final OptionKey DATUM_SHIFT_METHOD = new OptionKey("Molodenski", "Abridged_Molodenski", "Geocentric", "*");
    public static final Key LENIENT_DATUM_SHIFT = new Key(Boolean.class);
    public static final Key FORCE_LONGITUDE_FIRST_AXIS_ORDER = new Key(Boolean.class);
    public static final Key FORCE_STANDARD_AXIS_DIRECTIONS = new Key(Boolean.class);
    public static final Key FORCE_STANDARD_AXIS_UNITS = new Key(Boolean.class);
    public static final Key USE_PROVIDED_FID = new Key("org.geotools.fidPolicy.UseExisting");
    public static final ClassKey JTS_GEOMETRY_FACTORY = new ClassKey("com.vividsolutions.jts.geom.GeometryFactory");
    public static final ClassKey JTS_COORDINATE_SEQUENCE_FACTORY = new ClassKey("com.vividsolutions.jts.geom.CoordinateSequenceFactory");
    public static ClassKey FEATURE_FACTORY = new ClassKey("org.opengis.feature.FeatureFactory");
    public static final Key FEATURE_DETACHED = new Key(Boolean.class);
    public static final Key FEATURE_2D = new Key(Boolean.class);
    public static final Key GEOMETRY_DISTANCE = new Key(Double.class);
    public static final ClassKey FILTER_FACTORY = new ClassKey("org.opengis.filter.FilterFactory");
    public static final Key RESAMPLE_TOLERANCE = new Key(Double.class);
    public static final OptionKey CACHE_POLICY = new OptionKey("weak", "all", "fixed", "none", "default", "soft");
    public static final IntegerKey CACHE_LIMIT = new IntegerKey(50);
    public static final DoubleKey COMPARISON_TOLERANCE = new DoubleKey(0.0);

    public Hints() {
        super(null);
    }

    public Hints(RenderingHints.Key key, Object object) {
        super(null);
        super.put(key, object);
    }

    public Hints(Map<? extends RenderingHints.Key, ?> map) {
        super(Hints.stripNonKeys(map));
    }

    public Hints(RenderingHints renderingHints) {
        super(Hints.stripNonKeys(renderingHints));
    }

    static Map<RenderingHints.Key, Object> stripNonKeys(Map<?, ?> map) {
        if (map == null) {
            return null;
        }
        Map<RenderingHints.Key, Object> map2 = map;
        for (Object obj : map.keySet()) {
            if (obj instanceof RenderingHints.Key) continue;
            if (map2 == map) {
                map2 = new HashMap<RenderingHints.Key, Object>(map2);
            }
            map2.remove(obj);
        }
        return map2;
    }

    @Override
    public Hints clone() {
        return (Hints)super.clone();
    }

    private static boolean ensureSystemDefaultLoaded() {
        assert (Thread.holdsLock(GLOBAL));
        if (needScan) {
            needScan = false;
            return GeoTools.scanForSystemHints(GLOBAL);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Hints getDefaults(boolean bl) {
        Hints hints;
        boolean bl2;
        Hints hints2 = GLOBAL;
        synchronized (hints2) {
            bl2 = Hints.ensureSystemDefaultLoaded();
            hints = bl ? new StrictHints(GLOBAL) : new Hints(GLOBAL);
        }
        if (bl2) {
            GeoTools.fireConfigurationChanged();
        }
        return hints;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getSystemDefault(RenderingHints.Key key) {
        Object object;
        boolean bl;
        Hints hints = GLOBAL;
        synchronized (hints) {
            bl = Hints.ensureSystemDefaultLoaded();
            object = GLOBAL.get(key);
        }
        if (bl) {
            GeoTools.fireConfigurationChanged();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object putSystemDefault(RenderingHints.Key key, Object object) {
        Object object2;
        boolean bl;
        Hints hints = GLOBAL;
        synchronized (hints) {
            bl = Hints.ensureSystemDefaultLoaded();
            object2 = GLOBAL.put(key, object);
        }
        if (bl || !Utilities.equals(object, object2)) {
            GeoTools.fireConfigurationChanged();
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object removeSystemDefault(RenderingHints.Key key) {
        Object object;
        boolean bl;
        Hints hints = GLOBAL;
        synchronized (hints) {
            bl = Hints.ensureSystemDefaultLoaded();
            object = GLOBAL.remove(key);
        }
        if (bl || object != null) {
            GeoTools.fireConfigurationChanged();
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        boolean bl;
        String string = System.getProperty("line.separator", "\n");
        StringBuilder stringBuilder = new StringBuilder("Hints:");
        stringBuilder.append(string).append(AbstractFactory.toString(this));
        HashMap<Object, Object> hashMap = null;
        Hints hints = GLOBAL;
        synchronized (hints) {
            bl = Hints.ensureSystemDefaultLoaded();
            if (!GLOBAL.isEmpty()) {
                hashMap = new HashMap<Object, Object>(GLOBAL);
            }
        }
        if (bl) {
            GeoTools.fireConfigurationChanged();
        }
        if (hashMap != null) {
            hashMap.keySet().removeAll(this.keySet());
            if (!hashMap.isEmpty()) {
                stringBuilder.append("System defaults:").append(string).append(AbstractFactory.toString(hashMap));
            }
        }
        return stringBuilder.toString();
    }

    static String nameOf(RenderingHints.Key key) {
        String string;
        if (key instanceof Key) {
            return key.toString();
        }
        int n = 0;
        block7: while (true) {
            Class clazz;
            switch (n++) {
                case 0: {
                    clazz = RenderingHints.class;
                    break;
                }
                case 1: {
                    try {
                        clazz = Class.forName("javax.media.jai.JAI");
                        break;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        continue block7;
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {
                        continue block7;
                    }
                }
                default: {
                    return key.toString();
                }
            }
            if ((string = Hints.nameOf(clazz, key)) != null) break;
        }
        return string;
    }

    private static String nameOf(Class<?> clazz, RenderingHints.Key key) {
        Field[] fieldArray = clazz.getFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            Object object;
            Field field = fieldArray[i];
            if (!Modifier.isStatic(field.getModifiers())) continue;
            try {
                object = field.get(null);
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            if (object != key) continue;
            return field.getName();
        }
        return null;
    }

    static final class DataSourceKey
    extends Key {
        public DataSourceKey() {
            super(DataSource.class);
        }

        @Override
        public boolean isCompatibleValue(Object object) {
            return object instanceof DataSource || object instanceof String || object instanceof Name;
        }
    }

    public static final class OptionKey
    extends Key {
        private final Set<String> options;
        private final boolean wildcard;

        public OptionKey(String ... stringArray) {
            super(String.class);
            TreeSet<String> treeSet = new TreeSet<String>(Arrays.asList(stringArray));
            this.wildcard = treeSet.remove("*");
            this.options = Collections.unmodifiableSet(treeSet);
        }

        @Override
        public boolean isCompatibleValue(Object object) {
            return this.wildcard ? object instanceof String : this.options.contains(object);
        }
    }

    public static final class DoubleKey
    extends Key {
        private final double number;

        public DoubleKey(double d) {
            super(Integer.class);
            this.number = d;
        }

        public double getDefault() {
            return this.number;
        }

        @Override
        public boolean isCompatibleValue(Object object) {
            if (object instanceof Float || object instanceof Double) {
                return true;
            }
            if (object instanceof String || object instanceof InternationalString) {
                try {
                    Double.parseDouble(object.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    Logging.getLogger(DoubleKey.class).finer(numberFormatException.toString());
                }
            }
            return false;
        }
    }

    public static final class IntegerKey
    extends Key {
        public IntegerKey(int n) {
            super(Integer.class);
        }

        @Override
        public boolean isCompatibleValue(Object object) {
            if (object instanceof Short || object instanceof Integer) {
                return true;
            }
            if (object instanceof String || object instanceof InternationalString) {
                try {
                    Integer.parseInt(object.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    Logging.getLogger(IntegerKey.class).finer(numberFormatException.toString());
                }
            }
            return false;
        }
    }

    public static final class FileKey
    extends Key {
        private final boolean writable;

        public FileKey(boolean bl) {
            super(File.class);
            this.writable = bl;
        }

        @Override
        public boolean isCompatibleValue(Object object) {
            File file;
            if (object instanceof File) {
                file = (File)object;
            } else if (object instanceof String) {
                file = new File((String)object);
            } else {
                return false;
            }
            if (file.exists()) {
                return !this.writable || file.canWrite();
            }
            File file2 = file.getParentFile();
            return file2 != null && file2.canWrite();
        }
    }

    public static final class ClassKey
    extends Key {
        ClassKey(String string) {
            super(string);
        }

        @Override
        public boolean isCompatibleValue(Object object) {
            if (object == null) {
                return false;
            }
            if (object instanceof Class[]) {
                Class[] classArray = (Class[])object;
                for (int i = 0; i < classArray.length; ++i) {
                    if (this.isCompatibleValue(classArray[i])) continue;
                    return false;
                }
                return classArray.length != 0;
            }
            if (object instanceof Class) {
                int n;
                Class clazz = (Class)object;
                Class<?> clazz2 = this.getValueClass();
                if (clazz2.isAssignableFrom(clazz)) {
                    return true;
                }
                return clazz2.isInterface() && !clazz.isInterface() && Modifier.isAbstract(n = clazz.getModifiers()) && !Modifier.isFinal(n);
            }
            return super.isCompatibleValue(object);
        }
    }

    public static class Key
    extends RenderingHints.Key {
        private static int count;
        private final String className;
        private transient Class<?> valueClass;

        public Key(Class<?> clazz) {
            this(clazz.getName());
            this.valueClass = clazz;
        }

        Key(String string) {
            super(Key.count());
            this.className = string;
        }

        private static synchronized int count() {
            return count++;
        }

        public Class<?> getValueClass() {
            if (this.valueClass == null) {
                try {
                    this.valueClass = Class.forName(this.className);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Logging.unexpectedException(Key.class, "getValueClass", classNotFoundException);
                    this.valueClass = Object.class;
                }
            }
            return this.valueClass;
        }

        @Override
        public boolean isCompatibleValue(Object object) {
            return this.getValueClass().isInstance(object);
        }

        public String toString() {
            Class clazz;
            String string;
            int n = 0;
            do {
                switch (n++) {
                    case 0: {
                        clazz = Hints.class;
                        break;
                    }
                    case 1: {
                        clazz = this.getValueClass();
                        break;
                    }
                    default: {
                        return super.toString();
                    }
                }
            } while ((string = Hints.nameOf(clazz, this)) == null);
            return string;
        }
    }
}

