/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.shp;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geotools.data.shapefile.shp.ShapeHandler;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileException;
import org.geotools.geometry.jts.coordinatesequence.CoordinateSequences;

public class PolygonHandler
implements ShapeHandler {
    GeometryFactory geometryFactory;
    final ShapeType shapeType;

    public PolygonHandler(ShapeType shapeType, GeometryFactory geometryFactory) throws ShapefileException {
        if (shapeType != ShapeType.POLYGON && shapeType != ShapeType.POLYGONM && shapeType != ShapeType.POLYGONZ) {
            throw new ShapefileException("PolygonHandler constructor - expected type to be 5, 15, or 25.");
        }
        this.shapeType = shapeType;
        this.geometryFactory = geometryFactory;
    }

    boolean pointInList(Coordinate coordinate, Coordinate[] coordinateArray) {
        for (int i = coordinateArray.length - 1; i >= 0; --i) {
            Coordinate coordinate2 = coordinateArray[i];
            if (coordinate.x != coordinate2.x || coordinate.y != coordinate2.y || coordinate.z != coordinate2.z && coordinate.z == coordinate.z) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object read(ByteBuffer byteBuffer, ShapeType shapeType, boolean bl) {
        if (shapeType == ShapeType.NULL) {
            return this.createNull();
        }
        byteBuffer.position(byteBuffer.position() + 32);
        int n = byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        int n3 = this.shapeType == ShapeType.POLYGONZ && !bl ? 3 : 2;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = byteBuffer.getInt();
        }
        ArrayList<LinearRing> arrayList = new ArrayList<LinearRing>();
        ArrayList<LinearRing> arrayList2 = new ArrayList<LinearRing>();
        CoordinateSequence coordinateSequence = this.readCoordinates(byteBuffer, n2, n3);
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            int n5 = nArray[i];
            int n6 = i == n - 1 ? n2 : nArray[i + 1];
            int n7 = n6 - n5;
            int n8 = 0;
            if (coordinateSequence.getOrdinate(n5, 0) != coordinateSequence.getOrdinate(n6 - 1, 0) || coordinateSequence.getOrdinate(n5, 1) != coordinateSequence.getOrdinate(n6 - 1, 1)) {
                n8 = 1;
            }
            if (n3 == 3 && coordinateSequence.getOrdinate(n5, 2) != coordinateSequence.getOrdinate(n6 - 1, 2)) {
                n8 = 1;
            }
            CoordinateSequence coordinateSequence2 = this.geometryFactory.getCoordinateSequenceFactory().create(n7 + n8, n3);
            for (int j = 0; j < n7; ++j) {
                coordinateSequence2.setOrdinate(j, 0, coordinateSequence.getOrdinate(n4, 0));
                coordinateSequence2.setOrdinate(j, 1, coordinateSequence.getOrdinate(n4, 1));
                if (n3 == 3) {
                    coordinateSequence2.setOrdinate(j, 2, coordinateSequence.getOrdinate(n4, 2));
                }
                ++n4;
            }
            if (n8 == 1) {
                coordinateSequence2.setOrdinate(n7, 0, coordinateSequence.getOrdinate(n5, 0));
                coordinateSequence2.setOrdinate(n7, 1, coordinateSequence.getOrdinate(n5, 1));
                if (n3 == 3) {
                    coordinateSequence2.setOrdinate(n7, 2, coordinateSequence.getOrdinate(n5, 2));
                }
            }
            if (coordinateSequence2.size() != 0 && coordinateSequence2.size() <= 3) continue;
            LinearRing linearRing = this.geometryFactory.createLinearRing(coordinateSequence2);
            if (CoordinateSequences.isCCW(coordinateSequence2)) {
                arrayList2.add(linearRing);
                continue;
            }
            arrayList.add(linearRing);
        }
        if (arrayList.size() == 1) {
            return this.createMulti((LinearRing)arrayList.get(0), arrayList2);
        }
        if (arrayList2.size() == 1 && arrayList.size() == 0) {
            return this.createMulti((LinearRing)arrayList2.get(0));
        }
        ArrayList arrayList3 = this.assignHolesToShells(arrayList, arrayList2);
        Geometry geometry = this.buildGeometries(arrayList, arrayList2, arrayList3);
        return geometry;
    }

    private CoordinateSequence readCoordinates(ByteBuffer byteBuffer, int n, int n2) {
        int n3;
        CoordinateSequence coordinateSequence = this.geometryFactory.getCoordinateSequenceFactory().create(n, n2);
        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
        double[] dArray = new double[n * 2];
        doubleBuffer.get(dArray);
        for (n3 = 0; n3 < n; ++n3) {
            coordinateSequence.setOrdinate(n3, 0, dArray[n3 * 2]);
            coordinateSequence.setOrdinate(n3, 1, dArray[n3 * 2 + 1]);
        }
        if (n2 > 2) {
            doubleBuffer.position(doubleBuffer.position() + 2);
            doubleBuffer.get(dArray, 0, n);
            for (n3 = 0; n3 < n; ++n3) {
                coordinateSequence.setOrdinate(n3, 2, dArray[n3]);
            }
        }
        return coordinateSequence;
    }

    private Geometry buildGeometries(List list, List list2, List list3) {
        int n;
        Polygon[] polygonArray = list.size() > 0 ? new Polygon[list.size()] : new Polygon[list2.size()];
        for (n = 0; n < list.size(); ++n) {
            polygonArray[n] = this.geometryFactory.createPolygon((LinearRing)list.get(n), ((ArrayList)list3.get(n)).toArray(new LinearRing[0]));
        }
        if (list.size() == 0) {
            int n2 = list2.size();
            for (n = 0; n < n2; ++n) {
                LinearRing linearRing = (LinearRing)list2.get(n);
                polygonArray[n] = this.geometryFactory.createPolygon(linearRing, null);
            }
        }
        MultiPolygon multiPolygon = this.geometryFactory.createMultiPolygon(polygonArray);
        return multiPolygon;
    }

    ArrayList assignHolesToShells(ArrayList arrayList, ArrayList arrayList2) {
        int n;
        ArrayList arrayList3 = new ArrayList(arrayList.size());
        for (n = 0; n < arrayList.size(); ++n) {
            arrayList3.add(new ArrayList());
        }
        for (n = 0; n < arrayList2.size(); ++n) {
            LinearRing linearRing = (LinearRing)arrayList2.get(n);
            LinearRing linearRing2 = null;
            Envelope envelope = null;
            Envelope envelope2 = linearRing.getEnvelopeInternal();
            Coordinate coordinate = linearRing.getCoordinateN(0);
            for (int i = 0; i < arrayList.size(); ++i) {
                LinearRing linearRing3 = (LinearRing)arrayList.get(i);
                Envelope envelope3 = linearRing3.getEnvelopeInternal();
                if (linearRing2 != null) {
                    envelope = linearRing2.getEnvelopeInternal();
                }
                boolean bl = false;
                Coordinate[] coordinateArray = linearRing3.getCoordinates();
                if (envelope3.contains(envelope2) && (CGAlgorithms.isPointInRing((Coordinate)coordinate, (Coordinate[])coordinateArray) || this.pointInList(coordinate, coordinateArray))) {
                    bl = true;
                }
                if (!bl || linearRing2 != null && !envelope.contains(envelope3)) continue;
                linearRing2 = linearRing3;
            }
            if (linearRing2 == null) {
                arrayList.add(linearRing);
                arrayList3.add(new ArrayList());
                continue;
            }
            ((ArrayList)arrayList3.get(arrayList.indexOf(linearRing2))).add(linearRing);
        }
        return arrayList3;
    }

    private MultiPolygon createMulti(LinearRing linearRing) {
        return this.createMulti(linearRing, Collections.EMPTY_LIST);
    }

    private MultiPolygon createMulti(LinearRing linearRing, List list) {
        return this.geometryFactory.createMultiPolygon(new Polygon[]{this.geometryFactory.createPolygon(linearRing, list.toArray(new LinearRing[list.size()]))});
    }

    private MultiPolygon createNull() {
        return this.geometryFactory.createMultiPolygon(null);
    }
}

