/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.shp;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import org.geotools.data.shapefile.shp.ShapeHandler;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileException;

public class MultiLineHandler
implements ShapeHandler {
    final ShapeType shapeType;
    GeometryFactory geometryFactory;

    public MultiLineHandler(ShapeType shapeType, GeometryFactory geometryFactory) throws ShapefileException {
        if (shapeType != ShapeType.ARC && shapeType != ShapeType.ARCM && shapeType != ShapeType.ARCZ) {
            throw new ShapefileException("MultiLineHandler constructor - expected type to be 3,13 or 23");
        }
        this.shapeType = shapeType;
        this.geometryFactory = geometryFactory;
    }

    private Object createNull() {
        return this.geometryFactory.createMultiLineString((LineString[])null);
    }

    @Override
    public Object read(ByteBuffer byteBuffer, ShapeType shapeType, boolean bl) {
        Object object;
        int n;
        int n2;
        if (shapeType == ShapeType.NULL) {
            return this.createNull();
        }
        int n3 = this.shapeType == ShapeType.ARCZ && !bl ? 3 : 2;
        byteBuffer.position(byteBuffer.position() + 32);
        int n4 = byteBuffer.getInt();
        int n5 = byteBuffer.getInt();
        int[] nArray = new int[n4];
        for (int i = 0; i < n4; ++i) {
            nArray[i] = byteBuffer.getInt();
        }
        CoordinateSequence[] coordinateSequenceArray = new CoordinateSequence[n4];
        int n6 = 0;
        int n7 = 0;
        boolean bl2 = false;
        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
        for (n2 = 0; n2 < n4; ++n2) {
            n = n2 == n4 - 1 ? n5 : nArray[n2 + 1];
            n7 = n - (n6 = nArray[n2]);
            if (n7 == 1) {
                n7 = 2;
                bl2 = true;
            } else {
                bl2 = false;
            }
            object = this.geometryFactory.getCoordinateSequenceFactory().create(n7, n3);
            double[] dArray = new double[n7 * 2];
            doubleBuffer.get(dArray);
            for (int i = 0; i < n7; ++i) {
                object.setOrdinate(i, 0, dArray[i * 2]);
                object.setOrdinate(i, 1, dArray[i * 2 + 1]);
            }
            if (bl2) {
                object.setOrdinate(1, 0, object.getOrdinate(0, 0));
                object.setOrdinate(1, 1, object.getOrdinate(0, 1));
            }
            coordinateSequenceArray[n2] = object;
        }
        if (n3 == 3) {
            doubleBuffer.position(doubleBuffer.position() + 2);
            for (n2 = 0; n2 < n4; ++n2) {
                n = n2 == n4 - 1 ? n5 : nArray[n2 + 1];
                n7 = n - (n6 = nArray[n2]);
                if (n7 == 1) {
                    n7 = 2;
                    bl2 = true;
                } else {
                    bl2 = false;
                }
                object = new double[n7];
                doubleBuffer.get((double[])object);
                for (int i = 0; i < n7; ++i) {
                    coordinateSequenceArray[n2].setOrdinate(i, 2, (double)object[i]);
                }
            }
        }
        LineString[] lineStringArray = new LineString[n4];
        for (int i = 0; i < n4; ++i) {
            lineStringArray[i] = this.geometryFactory.createLineString(coordinateSequenceArray[i]);
        }
        return this.geometryFactory.createMultiLineString(lineStringArray);
    }
}

