/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.dbf;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.geotools.resources.NIOUtilities;

public class DbaseFileHeader {
    private static final int FILE_DESCRIPTOR_SIZE = 32;
    private static final byte MAGIC = 3;
    private Date date = new Date();
    private int recordCnt = 0;
    private int fieldCnt = 0;
    private int recordLength = 1;
    private int headerLength = -1;
    private int largestFieldSize = 0;
    public static long MILLIS_SINCE_4713 = -210866803200000L;
    private DbaseField[] fields = new DbaseField[0];

    private void read(ByteBuffer byteBuffer, ReadableByteChannel readableByteChannel) throws IOException {
        while (byteBuffer.remaining() > 0) {
            if (readableByteChannel.read(byteBuffer) != -1) continue;
            throw new EOFException("Premature end of file");
        }
    }

    public Class getFieldClass(int n) {
        Class clazz = null;
        switch (this.fields[n].fieldType) {
            case 'C': {
                clazz = String.class;
                break;
            }
            case 'N': {
                if (this.fields[n].decimalCount == 0) {
                    if (this.fields[n].fieldLength < 10) {
                        clazz = Integer.class;
                        break;
                    }
                    clazz = Long.class;
                    break;
                }
                clazz = Double.class;
                break;
            }
            case 'F': {
                clazz = Double.class;
                break;
            }
            case 'L': {
                clazz = Boolean.class;
                break;
            }
            case 'D': {
                clazz = Date.class;
                break;
            }
            case '@': {
                clazz = Timestamp.class;
                break;
            }
            default: {
                clazz = String.class;
            }
        }
        return clazz;
    }

    public int getFieldLength(int n) {
        return this.fields[n].fieldLength;
    }

    public String getFieldName(int n) {
        return this.fields[n].fieldName;
    }

    public char getFieldType(int n) {
        return this.fields[n].fieldType;
    }

    public Date getLastUpdateDate() {
        return this.date;
    }

    public int getNumFields() {
        return this.fields.length;
    }

    public int getNumRecords() {
        return this.recordCnt;
    }

    public int getRecordLength() {
        return this.recordLength;
    }

    public int getHeaderLength() {
        return this.headerLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readHeader(ReadableByteChannel readableByteChannel, Charset charset) throws IOException {
        ByteBuffer byteBuffer = NIOUtilities.allocate(1024);
        try {
            byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            byteBuffer.limit(10);
            this.read(byteBuffer, readableByteChannel);
            byteBuffer.position(0);
            byte by = byteBuffer.get();
            if (by != 3) {
                throw new IOException("Unsupported DBF file Type " + Integer.toHexString(by));
            }
            int n = byteBuffer.get();
            byte by2 = byteBuffer.get();
            byte by3 = byteBuffer.get();
            n = n > 90 ? (n += 1900) : (n += 2000);
            Calendar calendar = Calendar.getInstance();
            calendar.set(1, n);
            calendar.set(2, by2 - 1);
            calendar.set(5, by3);
            this.date = calendar.getTime();
            this.recordCnt = byteBuffer.getInt();
            this.headerLength = byteBuffer.get() & 0xFF | (byteBuffer.get() & 0xFF) << 8;
            if (this.headerLength > byteBuffer.capacity()) {
                NIOUtilities.clean(byteBuffer, false);
                byteBuffer = NIOUtilities.allocate(this.headerLength - 10);
            }
            byteBuffer.limit(this.headerLength - 10);
            byteBuffer.position(0);
            this.read(byteBuffer, readableByteChannel);
            byteBuffer.position(0);
            this.recordLength = byteBuffer.get() & 0xFF | (byteBuffer.get() & 0xFF) << 8;
            byteBuffer.position(byteBuffer.position() + 20);
            this.fieldCnt = (this.headerLength - 32 - 1) / 32;
            ArrayList<DbaseField> arrayList = new ArrayList<DbaseField>();
            for (int i = 0; i < this.fieldCnt; ++i) {
                DbaseField dbaseField = new DbaseField();
                byte[] byArray = new byte[11];
                byteBuffer.get(byArray);
                String string = new String(byArray, charset.name());
                int n2 = string.indexOf(0);
                if (n2 != -1) {
                    string = string.substring(0, n2);
                }
                dbaseField.fieldName = string.trim();
                dbaseField.fieldType = (char)byteBuffer.get();
                dbaseField.fieldDataAddress = byteBuffer.getInt();
                int n3 = byteBuffer.get();
                if (n3 < 0) {
                    n3 += 256;
                }
                dbaseField.fieldLength = n3;
                if (n3 > this.largestFieldSize) {
                    this.largestFieldSize = n3;
                }
                dbaseField.decimalCount = byteBuffer.get();
                byteBuffer.position(byteBuffer.position() + 14);
                if (dbaseField.fieldLength <= 0) continue;
                arrayList.add(dbaseField);
            }
            byteBuffer.position(byteBuffer.position() + 1);
            this.fields = new DbaseField[arrayList.size()];
            this.fields = arrayList.toArray(this.fields);
        }
        finally {
            NIOUtilities.clean(byteBuffer, false);
        }
    }

    public void readHeader(ByteBuffer byteBuffer) throws IOException {
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        byte by = byteBuffer.get();
        if (by != 3) {
            throw new IOException("Unsupported DBF file Type " + Integer.toHexString(by));
        }
        int n = byteBuffer.get();
        byte by2 = byteBuffer.get();
        byte by3 = byteBuffer.get();
        n = n > 90 ? (n += 1900) : (n += 2000);
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, n);
        calendar.set(2, by2 - 1);
        calendar.set(5, by3);
        this.date = calendar.getTime();
        this.recordCnt = byteBuffer.getInt();
        this.headerLength = byteBuffer.get() & 0xFF | (byteBuffer.get() & 0xFF) << 8;
        if (this.headerLength > byteBuffer.capacity()) {
            throw new IllegalArgumentException("The contract says the buffer should be long enough to fit all the header!");
        }
        this.recordLength = byteBuffer.get() & 0xFF | (byteBuffer.get() & 0xFF) << 8;
        byteBuffer.position(byteBuffer.position() + 20);
        this.fieldCnt = (this.headerLength - 32 - 1) / 32;
        ArrayList<DbaseField> arrayList = new ArrayList<DbaseField>();
        for (int i = 0; i < this.fieldCnt; ++i) {
            DbaseField dbaseField = new DbaseField();
            byte[] byArray = new byte[11];
            byteBuffer.get(byArray);
            String string = new String(byArray);
            int n2 = string.indexOf(0);
            if (n2 != -1) {
                string = string.substring(0, n2);
            }
            dbaseField.fieldName = string.trim();
            dbaseField.fieldType = (char)byteBuffer.get();
            dbaseField.fieldDataAddress = byteBuffer.getInt();
            int n3 = byteBuffer.get();
            if (n3 < 0) {
                n3 += 256;
            }
            dbaseField.fieldLength = n3;
            if (n3 > this.largestFieldSize) {
                this.largestFieldSize = n3;
            }
            dbaseField.decimalCount = byteBuffer.get();
            byteBuffer.position(byteBuffer.position() + 14);
            if (dbaseField.fieldLength <= 0) continue;
            arrayList.add(dbaseField);
        }
        byteBuffer.position(byteBuffer.position() + 1);
        this.fields = new DbaseField[arrayList.size()];
        this.fields = arrayList.toArray(this.fields);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (DbaseField dbaseField : this.fields) {
            stringBuffer.append(dbaseField.fieldName + " " + dbaseField.fieldType + " " + dbaseField.fieldLength + " " + dbaseField.decimalCount + " " + dbaseField.fieldDataAddress + "\n");
        }
        return "DB3 Header\nDate : " + this.date + "\n" + "Records : " + this.recordCnt + "\n" + "Fields : " + this.fieldCnt + "\n" + stringBuffer;
    }

    class DbaseField {
        String fieldName;
        char fieldType;
        int fieldDataAddress;
        int fieldLength;
        int decimalCount;

        DbaseField() {
        }
    }
}

