/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources;

import java.io.Serializable;
import java.util.AbstractList;
import org.geotools.util.CheckedCollection;

public class UnmodifiableArrayList<E>
extends AbstractList<E>
implements CheckedCollection<E>,
Serializable {
    private static final long serialVersionUID = -3605810209653785967L;
    private final E[] array;

    protected UnmodifiableArrayList(E[] EArray) {
        this.array = EArray;
    }

    public static <E> UnmodifiableArrayList<E> wrap(E[] EArray) {
        return new UnmodifiableArrayList<E>(EArray);
    }

    @Override
    public Class<E> getElementType() {
        return this.array.getClass().getComponentType();
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public E get(int n) {
        return this.array[n];
    }

    @Override
    public int indexOf(Object object) {
        if (object == null) {
            for (int i = 0; i < this.array.length; ++i) {
                if (this.array[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < this.array.length; ++i) {
                if (!object.equals(this.array[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        int n = this.array.length;
        if (object == null) {
            while (--n >= 0 && this.array[n] != null) {
            }
        } else {
            while (--n >= 0 && !object.equals(this.array[n])) {
            }
        }
        return n;
    }

    @Override
    public boolean contains(Object object) {
        int n = this.array.length;
        if (object == null) {
            while (--n >= 0) {
                if (this.array[n] != null) continue;
                return true;
            }
        } else {
            while (--n >= 0) {
                if (!object.equals(this.array[n])) continue;
                return true;
            }
        }
        return false;
    }
}

