/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.resources;

import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import org.geotools.resources.NIOUtilities;
import org.geotools.util.WeakCollectionCleaner;

class BufferSoftReference
extends SoftReference<ByteBuffer> {
    public BufferSoftReference(ByteBuffer byteBuffer) {
        super(byteBuffer, WeakCollectionCleaner.DEFAULT.getReferenceQueue());
    }

    @Override
    public void clear() {
        ByteBuffer byteBuffer = (ByteBuffer)this.get();
        NIOUtilities.clean(byteBuffer);
        super.clear();
    }

    public boolean equals(Object object) {
        if (!(object instanceof BufferSoftReference)) {
            return false;
        }
        ByteBuffer byteBuffer = (ByteBuffer)this.get();
        if (byteBuffer == null) {
            return false;
        }
        ByteBuffer byteBuffer2 = (ByteBuffer)((BufferSoftReference)object).get();
        if (byteBuffer2 == null) {
            return false;
        }
        return byteBuffer2 == byteBuffer;
    }
}

