/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.geotools.factory.Hints;
import org.geotools.factory.OptionalFactory;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.BufferedAuthorityFactory;
import org.geotools.referencing.factory.FactoryNotFoundException;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Loggings;
import org.opengis.referencing.FactoryException;

public abstract class DeferredAuthorityFactory
extends BufferedAuthorityFactory
implements OptionalFactory {
    private static Timer TIMER = new Timer("GT authority factory disposer", true);
    private TimerTask disposer;
    private boolean used;

    protected DeferredAuthorityFactory(Hints hints, int n) {
        super(n, 20);
    }

    @Override
    public boolean isAvailable() {
        return super.isAvailable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    final AbstractAuthorityFactory getBackingStore() throws FactoryException {
        if (this.backingStore == null) {
            DeferredAuthorityFactory deferredAuthorityFactory = this;
            synchronized (deferredAuthorityFactory) {
                if (this.backingStore == null) {
                    this.backingStore = this.createBackingStore();
                    if (this.backingStore == null) {
                        throw new FactoryNotFoundException(Errors.format(131));
                    }
                    this.completeHints();
                }
            }
        }
        this.used = true;
        return this.backingStore;
    }

    protected abstract AbstractAuthorityFactory createBackingStore() throws FactoryException;

    public synchronized void setTimeout(long l) {
        if (TIMER == null) {
            return;
        }
        if (this.disposer != null) {
            this.disposer.cancel();
        }
        this.disposer = new Disposer();
        TIMER.schedule(this.disposer, l, l);
    }

    protected boolean canDisposeBackingStore(AbstractAuthorityFactory abstractAuthorityFactory) {
        return true;
    }

    @Override
    public synchronized void dispose() throws FactoryException {
        if (this.disposer != null) {
            this.disposer.cancel();
            this.disposer = null;
        }
        super.dispose();
    }

    protected synchronized void disposeBackingStore() {
        try {
            if (this.backingStore != null) {
                LOGGER.log(Level.INFO, "Disposing " + this.getClass() + " backing store");
                this.backingStore.dispose();
                this.backingStore = null;
            }
        }
        catch (FactoryException factoryException) {
            this.backingStore = null;
            LogRecord logRecord = Loggings.format(Level.WARNING, 7);
            logRecord.setSourceMethodName("run");
            logRecord.setSourceClassName(Disposer.class.getName());
            logRecord.setThrown(factoryException);
            logRecord.setLoggerName(LOGGER.getName());
            LOGGER.log(logRecord);
        }
    }

    private final class Disposer
    extends TimerTask {
        private Disposer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DeferredAuthorityFactory deferredAuthorityFactory = DeferredAuthorityFactory.this;
            synchronized (deferredAuthorityFactory) {
                if (DeferredAuthorityFactory.this.used || !DeferredAuthorityFactory.this.canDisposeBackingStore(DeferredAuthorityFactory.this.backingStore)) {
                    DeferredAuthorityFactory.this.used = false;
                    return;
                }
                if (this.cancel()) {
                    DeferredAuthorityFactory.this.disposer = null;
                    if (DeferredAuthorityFactory.this.backingStore != null) {
                        DeferredAuthorityFactory.this.disposeBackingStore();
                    }
                    DeferredAuthorityFactory.this.hints.remove(Hints.DATUM_AUTHORITY_FACTORY);
                    DeferredAuthorityFactory.this.hints.remove(Hints.CS_AUTHORITY_FACTORY);
                    DeferredAuthorityFactory.this.hints.remove(Hints.CRS_AUTHORITY_FACTORY);
                    DeferredAuthorityFactory.this.hints.remove(Hints.COORDINATE_OPERATION_AUTHORITY_FACTORY);
                }
            }
        }
    }
}

