/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.datum;

import java.io.Serializable;
import org.geotools.referencing.operation.matrix.Matrix4;
import org.geotools.referencing.operation.matrix.XMatrix;
import org.geotools.referencing.wkt.Formattable;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Utilities;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.Matrix;
import org.opengis.util.Cloneable;

public class BursaWolfParameters
extends Formattable
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 754825592343010900L;
    public double dx;
    public double dy;
    public double dz;
    public double ex;
    public double ey;
    public double ez;
    public double ppm;
    public final GeodeticDatum targetDatum;

    public BursaWolfParameters(GeodeticDatum geodeticDatum) {
        this.targetDatum = geodeticDatum;
    }

    public boolean isIdentity() {
        return this.dx == 0.0 && this.dy == 0.0 && this.dz == 0.0 && this.ex == 0.0 && this.ey == 0.0 && this.ez == 0.0 && this.ppm == 0.0;
    }

    public boolean isTranslation() {
        return this.ex == 0.0 && this.ey == 0.0 && this.ez == 0.0 && this.ppm == 0.0;
    }

    public XMatrix getAffineTransform() {
        double d = 1.0 + this.ppm / 1000000.0;
        double d2 = 4.84813681109536E-6 * d;
        return new Matrix4(d, -this.ez * d2, this.ey * d2, this.dx, this.ez * d2, d, -this.ex * d2, this.dy, -this.ey * d2, this.ex * d2, d, this.dz, 0.0, 0.0, 0.0, 1.0);
    }

    /*
     * Unable to fully structure code
     */
    public void setAffineTransform(Matrix var1_1, double var2_2) throws IllegalArgumentException {
        if (var1_1.getNumCol() != 4 || var1_1.getNumRow() != 4) {
            throw new IllegalArgumentException("Illegal matrix size.");
        }
        for (var4_3 = 0; var4_3 < 4; ++var4_3) {
            if (var1_1.getElement(3, var4_3) == (double)(var4_3 == 3)) continue;
            throw new IllegalArgumentException(Errors.format(106));
        }
        this.dx = var1_1.getElement(0, 3);
        this.dy = var1_1.getElement(1, 3);
        this.dz = var1_1.getElement(2, 3);
        var4_4 = (var1_1.getElement(0, 0) + var1_1.getElement(1, 1) + var1_1.getElement(2, 2)) / 3.0;
        var6_5 = 4.84813681109536E-6 * var4_4;
        this.ppm = (var4_4 - 1.0) * 1000000.0;
        for (var8_6 = 0; var8_6 < 2; ++var8_6) {
            var9_8 = (var1_1.getElement(var8_6, var8_6) - 1.0) * 1000000.0;
            if (!(Math.abs(var9_8 - this.ppm) <= var2_2)) {
                throw new IllegalArgumentException("Scale is not uniform.");
            }
            block6: for (var11_9 = var8_6 + 1; var11_9 < 3; ++var11_9) {
                var12_10 = var1_1.getElement(var8_6, var11_9) / var6_5;
                if (!(Math.abs(var12_10 + (var14_11 = var1_1.getElement(var11_9, var8_6) / var6_5)) <= var2_2)) {
                    throw new IllegalArgumentException("Matrix is not antisymmetric.");
                }
                var16_7 = 0.5 * (var12_10 - var14_11);
                if (var8_6 != 0) ** GOTO lbl-1000
                switch (var11_9) {
                    case 1: {
                        this.ez = -var16_7;
                        continue block6;
                    }
                    case 2: {
                        this.ey = var16_7;
                        continue block6;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        if (!(BursaWolfParameters.$assertionsDisabled || var8_6 == 1 && var11_9 == 2)) {
                            throw new AssertionError();
                        }
                        this.ex = -var16_7;
                    }
                }
            }
        }
        if (!BursaWolfParameters.$assertionsDisabled && !this.getAffineTransform().equals(var1_1, var2_2 * var6_5)) {
            throw new AssertionError();
        }
    }

    public int hashCode() {
        long l = 754825592343010900L;
        l = l * 37L + Double.doubleToLongBits(this.dx);
        l = l * 37L + Double.doubleToLongBits(this.dy);
        l = l * 37L + Double.doubleToLongBits(this.dz);
        l = l * 37L + Double.doubleToLongBits(this.ex);
        l = l * 37L + Double.doubleToLongBits(this.ey);
        l = l * 37L + Double.doubleToLongBits(this.ez);
        l = l * 37L + Double.doubleToLongBits(this.ppm);
        return (int)(l >>> 32) ^ (int)l;
    }

    @Override
    public BursaWolfParameters clone() {
        try {
            return (BursaWolfParameters)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof BursaWolfParameters) {
            BursaWolfParameters bursaWolfParameters = (BursaWolfParameters)object;
            return Utilities.equals(this.dx, bursaWolfParameters.dx) && Utilities.equals(this.dy, bursaWolfParameters.dy) && Utilities.equals(this.dz, bursaWolfParameters.dz) && Utilities.equals(this.ex, bursaWolfParameters.ex) && Utilities.equals(this.ey, bursaWolfParameters.ey) && Utilities.equals(this.ez, bursaWolfParameters.ez) && Utilities.equals(this.ppm, bursaWolfParameters.ppm) && Utilities.equals(this.targetDatum, bursaWolfParameters.targetDatum);
        }
        return false;
    }
}

