/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.cs;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opengis.referencing.cs.AxisDirection;

public final class DirectionAlongMeridian
implements Comparable,
Serializable {
    private static final long serialVersionUID = 1602711631943838328L;
    static final double EPS = 1.0E-10;
    private static final Pattern EPSG = Pattern.compile("(\\p{Graph}+)\\s+along\\s+([\\-\\p{Digit}\\.]+)\\s*(deg|\u00c2\u00b0)\\s*(\\p{Graph}+)?", 2);
    private static final AxisDirection[] BASE_DIRECTIONS = new AxisDirection[]{AxisDirection.NORTH, AxisDirection.SOUTH, AxisDirection.EAST, AxisDirection.WEST};
    private transient AxisDirection direction;
    public final AxisDirection baseDirection;
    public final double meridian;

    private DirectionAlongMeridian(AxisDirection axisDirection, double d) {
        this.baseDirection = axisDirection;
        this.meridian = d;
    }

    public static DirectionAlongMeridian parse(AxisDirection axisDirection) {
        DirectionAlongMeridian directionAlongMeridian = DirectionAlongMeridian.parse(axisDirection.name());
        if (directionAlongMeridian != null) {
            directionAlongMeridian.direction = axisDirection;
        }
        return directionAlongMeridian;
    }

    public static DirectionAlongMeridian parse(String string) {
        double d;
        Matcher matcher = EPSG.matcher(string);
        if (!matcher.matches()) {
            return null;
        }
        String string2 = matcher.group(1);
        AxisDirection axisDirection = DirectionAlongMeridian.findDirection(BASE_DIRECTIONS, string2);
        if (axisDirection == null || !AxisDirection.NORTH.equals(axisDirection.absolute())) {
            return null;
        }
        string2 = matcher.group(2);
        try {
            d = Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        if (!(d >= -180.0) || !(d <= 180.0)) {
            return null;
        }
        string2 = matcher.group(4);
        if (string2 != null) {
            AxisDirection axisDirection2 = DirectionAlongMeridian.findDirection(BASE_DIRECTIONS, string2);
            AxisDirection axisDirection3 = axisDirection2.absolute();
            if (!AxisDirection.EAST.equals(axisDirection3)) {
                return null;
            }
            if (axisDirection2 != axisDirection3) {
                d = -d;
            }
        }
        return new DirectionAlongMeridian(axisDirection, d);
    }

    private static AxisDirection findDirection(AxisDirection[] axisDirectionArray, String string) {
        for (int i = 0; i < axisDirectionArray.length; ++i) {
            AxisDirection axisDirection = axisDirectionArray[i];
            String string2 = axisDirection.name();
            if (string.equalsIgnoreCase(string2)) {
                return axisDirection;
            }
            if (string.length() != 1) continue;
            if (axisDirection == AxisDirection.NORTH && string.equals("N")) {
                return axisDirection;
            }
            if (axisDirection == AxisDirection.SOUTH && string.equals("S")) {
                return axisDirection;
            }
            if (axisDirection == AxisDirection.WEST && string.equals("W")) {
                return axisDirection;
            }
            if (axisDirection != AxisDirection.EAST || !string.equals("E")) continue;
            return axisDirection;
        }
        return null;
    }

    static AxisDirection findDirection(String string) {
        AxisDirection[] axisDirectionArray = AxisDirection.values();
        AxisDirection axisDirection = DirectionAlongMeridian.findDirection(axisDirectionArray, string);
        if (axisDirection == null) {
            String string2 = string.replace('-', '_');
            if (string2 != string) {
                string = string2;
                axisDirection = DirectionAlongMeridian.findDirection(axisDirectionArray, string2);
            }
            if (axisDirection == null && (string2 = string.replace(' ', '_')) != string) {
                axisDirection = DirectionAlongMeridian.findDirection(axisDirectionArray, string2);
            }
        }
        return axisDirection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AxisDirection getDirection() {
        if (this.direction != null) {
            return this.direction;
        }
        String string = this.toString();
        Class<AxisDirection> clazz = AxisDirection.class;
        synchronized (AxisDirection.class) {
            this.direction = DirectionAlongMeridian.findDirection(string);
            if (this.direction == null) {
                this.direction = AxisDirection.valueOf(string);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.direction;
        }
    }

    public double getAngle(DirectionAlongMeridian directionAlongMeridian) {
        if (!this.baseDirection.equals(directionAlongMeridian.baseDirection)) {
            return Double.NaN;
        }
        double d = this.meridian - directionAlongMeridian.meridian;
        if (d < -180.0) {
            d += 360.0;
        } else if (d > 180.0) {
            d -= 360.0;
        }
        if (!this.baseDirection.equals(this.baseDirection.absolute())) {
            d = -d;
        }
        return d;
    }

    public int compareTo(Object object) {
        DirectionAlongMeridian directionAlongMeridian = (DirectionAlongMeridian)object;
        int n = this.baseDirection.compareTo(directionAlongMeridian.baseDirection);
        if (n != 0) {
            return n;
        }
        double d = this.getAngle(directionAlongMeridian);
        if (d < 0.0) {
            return 1;
        }
        if (d > 0.0) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object instanceof DirectionAlongMeridian) {
            DirectionAlongMeridian directionAlongMeridian = (DirectionAlongMeridian)object;
            return this.baseDirection.equals(directionAlongMeridian.baseDirection) && Double.doubleToLongBits(this.meridian) == Double.doubleToLongBits(directionAlongMeridian.meridian);
        }
        return false;
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.meridian);
        return 0xDB662A78 ^ (int)l ^ (int)(l >> 32) + 37 * this.baseDirection.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.baseDirection.name());
        DirectionAlongMeridian.toLowerCase(stringBuilder, 0);
        stringBuilder.append(" along ");
        double d = Math.abs(this.meridian);
        int n = (int)d;
        if (d == (double)n) {
            stringBuilder.append(n);
        } else {
            stringBuilder.append(d);
        }
        stringBuilder.append(" deg");
        if (d != 0.0 && n != 180) {
            stringBuilder.append(' ');
            int n2 = stringBuilder.length();
            AxisDirection axisDirection = this.meridian < 0.0 ? AxisDirection.WEST : AxisDirection.EAST;
            stringBuilder.append(axisDirection.name());
            DirectionAlongMeridian.toLowerCase(stringBuilder, n2);
        }
        String string = stringBuilder.toString();
        assert (EPSG.matcher(string).matches()) : string;
        return string;
    }

    private static void toLowerCase(StringBuilder stringBuilder, int n) {
        int n2 = stringBuilder.length();
        while (--n2 > n) {
            stringBuilder.setCharAt(n2, Character.toLowerCase(stringBuilder.charAt(n2)));
        }
    }
}

