/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.parameter;

import java.util.Set;
import javax.measure.converter.UnitConverter;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.geotools.measure.Units;
import org.geotools.parameter.AbstractParameter;
import org.geotools.resources.Classes;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Utilities;
import org.opengis.parameter.InvalidParameterTypeException;
import org.opengis.parameter.InvalidParameterValueException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;

public class Parameter<T>
extends AbstractParameter
implements ParameterValue<T> {
    private static final long serialVersionUID = -5837826787089486776L;
    private T value;
    private Unit<?> unit;

    public Parameter(ParameterDescriptor<T> parameterDescriptor) {
        super(parameterDescriptor);
        this.value = parameterDescriptor.getDefaultValue();
        this.unit = parameterDescriptor.getUnit();
    }

    public static <T> T ensureValidValue(ParameterDescriptor<T> parameterDescriptor, Object object) throws InvalidParameterValueException {
        String string;
        if (object == null) {
            return null;
        }
        Class<T> clazz = parameterDescriptor.getValueClass();
        if (!clazz.isInstance(object)) {
            string = Errors.format(72, Classes.getClass(object));
        } else {
            Comparable<Object> comparable = parameterDescriptor.getMinimumValue();
            Comparable<Object> comparable2 = parameterDescriptor.getMaximumValue();
            if (comparable != null && comparable.compareTo(object) > 0 || comparable2 != null && comparable2.compareTo(object) < 0) {
                string = Errors.format(201, object, comparable, comparable2);
            } else {
                Set<T> set = parameterDescriptor.getValidValues();
                if (set != null && !set.contains(object)) {
                    string = Errors.format(58, Parameter.getName(parameterDescriptor), object);
                } else {
                    return clazz.cast(object);
                }
            }
        }
        throw new InvalidParameterValueException(string, Parameter.getName(parameterDescriptor), object);
    }

    private String getClassTypeError() {
        return Errors.format(72, ((ParameterDescriptor)this.descriptor).getValueClass());
    }

    @Override
    public ParameterDescriptor<T> getDescriptor() {
        return (ParameterDescriptor)super.getDescriptor();
    }

    @Override
    public Unit<?> getUnit() {
        return this.unit;
    }

    static int getUnitMessageID(Unit<?> unit) {
        if (Unit.ONE.equals(unit) || Units.PPM.equals(unit)) {
            return 116;
        }
        if (SI.METER.isCompatible(unit)) {
            return 113;
        }
        if (SI.SECOND.isCompatible(unit)) {
            return 117;
        }
        if (SI.RADIAN.isCompatible(unit)) {
            return 107;
        }
        return 76;
    }

    @Override
    public double doubleValue(Unit<?> unit) throws InvalidParameterTypeException {
        if (this.unit == null) {
            throw Parameter.unitlessParameter(this.descriptor);
        }
        Parameter.ensureNonNull("unit", unit);
        int n = Parameter.getUnitMessageID(this.unit);
        if (Parameter.getUnitMessageID(unit) != n) {
            throw new IllegalArgumentException(Errors.format(n, unit));
        }
        return this.unit.getConverterTo(unit).convert(this.doubleValue());
    }

    @Override
    public double doubleValue() throws InvalidParameterTypeException {
        if (this.value instanceof Number) {
            return ((Number)this.value).doubleValue();
        }
        String string = Parameter.getName(this.descriptor);
        if (this.value == null) {
            throw new IllegalStateException(Errors.format(99, string));
        }
        throw new InvalidParameterTypeException(this.getClassTypeError(), string);
    }

    @Override
    public int intValue() throws InvalidParameterTypeException {
        if (this.value instanceof Number) {
            return ((Number)this.value).intValue();
        }
        String string = Parameter.getName(this.descriptor);
        if (this.value == null) {
            throw new IllegalStateException(Errors.format(99, string));
        }
        throw new InvalidParameterTypeException(this.getClassTypeError(), string);
    }

    @Override
    public T getValue() {
        return this.value;
    }

    @Override
    public void setValue(double d, Unit<?> unit) throws InvalidParameterValueException {
        Parameter.ensureNonNull("unit", unit);
        ParameterDescriptor parameterDescriptor = (ParameterDescriptor)this.descriptor;
        Unit<?> unit2 = parameterDescriptor.getUnit();
        if (unit2 == null) {
            throw Parameter.unitlessParameter(parameterDescriptor);
        }
        int n = Parameter.getUnitMessageID(unit2);
        if (Parameter.getUnitMessageID(unit) != n) {
            throw new InvalidParameterValueException(Errors.format(n, unit), parameterDescriptor.getName().getCode(), d);
        }
        Double d2 = unit.getConverterTo(unit2).convert(d);
        Parameter.ensureValidValue(parameterDescriptor, d2);
        this.value = parameterDescriptor.getValueClass().cast(d);
        this.unit = unit;
    }

    @Override
    public void setValue(double d) throws InvalidParameterValueException {
        Double d2 = d;
        ParameterDescriptor parameterDescriptor = (ParameterDescriptor)this.descriptor;
        this.value = Parameter.ensureValidValue(parameterDescriptor, d2);
    }

    @Override
    public void setValue(int n) throws InvalidParameterValueException {
        ParameterDescriptor parameterDescriptor = (ParameterDescriptor)this.descriptor;
        Class clazz = parameterDescriptor.getValueClass();
        if (Double.class.equals(clazz) || Double.TYPE.equals(clazz)) {
            this.setValue((double)n);
            return;
        }
        Integer n2 = n;
        this.value = Parameter.ensureValidValue(parameterDescriptor, n2);
    }

    @Override
    public void setValue(Object object) throws InvalidParameterValueException {
        ParameterDescriptor parameterDescriptor = (ParameterDescriptor)this.descriptor;
        this.value = Parameter.ensureValidValue(parameterDescriptor, object);
    }

    @Override
    public void setValue(double[] dArray, Unit<?> unit) throws InvalidParameterValueException {
        Parameter.ensureNonNull("unit", unit);
        ParameterDescriptor parameterDescriptor = (ParameterDescriptor)this.descriptor;
        Unit<?> unit2 = parameterDescriptor.getUnit();
        if (unit2 == null) {
            throw Parameter.unitlessParameter(parameterDescriptor);
        }
        int n = Parameter.getUnitMessageID(unit2);
        if (Parameter.getUnitMessageID(unit) != n) {
            throw new IllegalArgumentException(Errors.format(n, unit));
        }
        double[] dArray2 = (double[])dArray.clone();
        UnitConverter unitConverter = unit.getConverterTo(unit2);
        for (int i = 0; i < dArray2.length; ++i) {
            dArray2[i] = unitConverter.convert(dArray2[i]);
        }
        this.value = Parameter.ensureValidValue(parameterDescriptor, dArray2);
        this.unit = unit;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            Parameter parameter = (Parameter)object;
            return Utilities.equals(this.value, parameter.value) && Utilities.equals(this.unit, parameter.unit);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode() * 37;
        if (this.value != null) {
            n += this.value.hashCode();
        }
        if (this.unit != null) {
            n += 37 * this.unit.hashCode();
        }
        return n ^ 0x9F456C48;
    }

    @Override
    public Parameter clone() {
        return (Parameter)super.clone();
    }
}

