/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.parameter;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.measure.unit.Unit;
import org.geotools.parameter.AbstractParameter;
import org.geotools.parameter.AbstractParameterDescriptor;
import org.geotools.parameter.FloatParameter;
import org.geotools.parameter.Parameter;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.resources.i18n.Errors;
import org.geotools.util.Utilities;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.referencing.IdentifiedObject;

public class DefaultParameterDescriptor<T>
extends AbstractParameterDescriptor
implements ParameterDescriptor<T> {
    private static final long serialVersionUID = -295668622297737705L;
    private final Class<T> valueClass;
    private final Set<T> validValues;
    private final T defaultValue;
    private final Comparable<T> minimum;
    private final Comparable<T> maximum;
    private final Unit<?> unit;

    public DefaultParameterDescriptor(Map<String, ?> map, Class<T> clazz, T[] TArray, T t, Comparable<T> comparable, Comparable<T> comparable2, Unit<?> unit, boolean bl) {
        this(map, bl, clazz, TArray, t, comparable, comparable2, unit);
    }

    private DefaultParameterDescriptor(Map<String, ?> map, boolean bl, Class<T> clazz, T[] TArray, T t, Comparable<T> comparable, Comparable<T> comparable2, Unit<?> unit) {
        super(map, bl ? 1 : 0, 1);
        this.valueClass = clazz;
        this.defaultValue = t;
        this.minimum = comparable;
        this.maximum = comparable2;
        this.unit = unit;
        DefaultParameterDescriptor.ensureNonNull("valueClass", clazz);
        AbstractParameter.ensureValidClass(clazz, t);
        AbstractParameter.ensureValidClass(clazz, comparable);
        AbstractParameter.ensureValidClass(clazz, comparable2);
        if (comparable != null && comparable2 != null && comparable.compareTo(clazz.cast(comparable2)) > 0) {
            throw new IllegalArgumentException(Errors.format(14, comparable, comparable2));
        }
        if (TArray != null) {
            HashSet<T> hashSet = new HashSet<T>(Math.max(TArray.length * 4 / 3 + 1, 8), 0.75f);
            for (int i = 0; i < TArray.length; ++i) {
                T t2 = TArray[i];
                AbstractParameter.ensureValidClass(clazz, t2);
                hashSet.add(t2);
            }
            this.validValues = Collections.unmodifiableSet(hashSet);
        } else {
            this.validValues = null;
        }
        if (t != null) {
            Parameter.ensureValidValue(this, t);
        }
    }

    public static DefaultParameterDescriptor<Integer> create(String string, int n, int n2, int n3) {
        return DefaultParameterDescriptor.create(Collections.singletonMap("name", string), n, n2, n3, true);
    }

    public static DefaultParameterDescriptor<Integer> create(Map<String, ?> map, int n, int n2, int n3, boolean bl) {
        return new DefaultParameterDescriptor<Integer>(map, bl, Integer.class, null, n, n2 == Integer.MIN_VALUE ? null : Integer.valueOf(n2), n3 == Integer.MAX_VALUE ? null : Integer.valueOf(n3), null);
    }

    public static DefaultParameterDescriptor<Double> create(String string, double d, double d2, double d3, Unit<?> unit) {
        return DefaultParameterDescriptor.create(Collections.singletonMap("name", string), d, d2, d3, unit, true);
    }

    public static DefaultParameterDescriptor<Double> create(Map<String, ?> map, double d, double d2, double d3, Unit<?> unit, boolean bl) {
        return new DefaultParameterDescriptor<Double>(map, bl, Double.class, null, Double.isNaN(d) ? null : Double.valueOf(d), d2 == Double.NEGATIVE_INFINITY ? null : Double.valueOf(d2), d3 == Double.POSITIVE_INFINITY ? null : Double.valueOf(d3), unit);
    }

    @Override
    public int getMaximumOccurs() {
        return 1;
    }

    @Override
    public ParameterValue<T> createValue() {
        if (Double.class.equals(this.valueClass) && this.unit == null) {
            return new FloatParameter(this);
        }
        return new Parameter(this);
    }

    @Override
    public Class<T> getValueClass() {
        return this.valueClass;
    }

    @Override
    public Set<T> getValidValues() {
        return this.validValues;
    }

    @Override
    public T getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Comparable<T> getMinimumValue() {
        return this.minimum;
    }

    @Override
    public Comparable<T> getMaximumValue() {
        return this.maximum;
    }

    @Override
    public Unit<?> getUnit() {
        return this.unit;
    }

    @Override
    public boolean equals(AbstractIdentifiedObject abstractIdentifiedObject, boolean bl) {
        if (abstractIdentifiedObject == this) {
            return true;
        }
        if (super.equals(abstractIdentifiedObject, bl)) {
            if (!(bl || this.nameMatches(abstractIdentifiedObject.getName().getCode()) || DefaultParameterDescriptor.nameMatches((IdentifiedObject)abstractIdentifiedObject, this.getName().getCode()))) {
                return false;
            }
            DefaultParameterDescriptor defaultParameterDescriptor = (DefaultParameterDescriptor)abstractIdentifiedObject;
            return Utilities.equals(this.validValues, defaultParameterDescriptor.validValues) && Utilities.equals(this.defaultValue, defaultParameterDescriptor.defaultValue) && Utilities.equals(this.minimum, defaultParameterDescriptor.minimum) && Utilities.equals(this.maximum, defaultParameterDescriptor.maximum) && Utilities.equals(this.unit, defaultParameterDescriptor.unit);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode() * 37 + this.valueClass.hashCode();
        if (this.defaultValue != null) {
            n += 37 * this.defaultValue.hashCode();
        }
        if (this.minimum != null) {
            n += 1369 * this.minimum.hashCode();
        }
        if (this.maximum != null) {
            n += 50653 * this.maximum.hashCode();
        }
        if (this.unit != null) {
            n += this.unit.hashCode();
        }
        return n;
    }
}

