/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.measure;

import javax.measure.converter.ConversionException;
import javax.measure.converter.UnitConverter;

class SexagesimalConverter
extends UnitConverter {
    private static final long serialVersionUID = 3873494343412121773L;
    private static final double EPS = 1.0E-8;
    final int divider;
    private final UnitConverter inverse;

    private SexagesimalConverter(int n) {
        this.divider = n;
        this.inverse = new Inverse(this);
    }

    private SexagesimalConverter(int n, UnitConverter unitConverter) {
        this.divider = n;
        this.inverse = unitConverter;
    }

    @Override
    public final UnitConverter inverse() {
        return this.inverse;
    }

    @Override
    public double convert(double d) throws ConversionException {
        int n = (int)d;
        d = (d - (double)n) * 60.0;
        int n2 = (int)d;
        d = (d - (double)n2) * 60.0;
        int n3 = (int)d;
        return ((double)((n * 100 + n2) * 100 + n3) + (d -= (double)n3)) / (double)this.divider;
    }

    @Override
    public final boolean isLinear() {
        return false;
    }

    @Override
    public final boolean equals(Object object) {
        return object != null && object.getClass().equals(this.getClass()) && ((SexagesimalConverter)object).divider == this.divider;
    }

    @Override
    public int hashCode() {
        return 714113197 + this.divider;
    }

    private static final class Inverse
    extends SexagesimalConverter {
        private static final long serialVersionUID = -7171869900634417819L;

        public Inverse(SexagesimalConverter sexagesimalConverter) {
            super(sexagesimalConverter.divider, sexagesimalConverter);
        }

        @Override
        public double convert(double d) throws ConversionException {
            int n = (int)((d *= (double)this.divider) / 10000.0);
            int n2 = (int)((d -= (double)(10000 * n)) / 100.0);
            d -= (double)(100 * n2);
            if (n2 <= -60 || n2 >= 60) {
                if ((double)Math.abs(Math.abs(n2) - 100) <= 1.0E-8) {
                    n = n2 >= 0 ? ++n : --n;
                    n2 = 0;
                } else {
                    throw new ConversionException("Invalid minutes: " + n2);
                }
            }
            if (d <= -60.0 || d >= 60.0) {
                if (Math.abs(Math.abs(d) - 100.0) <= 1.0E-8) {
                    n2 = d >= 0.0 ? ++n2 : --n2;
                    d = 0.0;
                } else {
                    throw new ConversionException("Invalid secondes: " + d);
                }
            }
            d = (d / 60.0 + (double)n2) / 60.0 + (double)n;
            return d;
        }

        @Override
        public int hashCode() {
            return -715221659 + this.divider;
        }
    }
}

