/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import org.geotools.geometry.jts.CoordinateSequenceTransformer;
import org.geotools.geometry.jts.DefaultCoordinateSequenceTransformer;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class GeometryCoordinateSequenceTransformer {
    private MathTransform transform;
    private CoordinateSequenceTransformer csTransformer = new DefaultCoordinateSequenceTransformer();
    private CoordinateReferenceSystem crs;

    public void setMathTransform(MathTransform mathTransform) {
        this.transform = mathTransform;
    }

    public Geometry transform(Geometry geometry) throws TransformException {
        GeometryFactory geometryFactory = geometry.getFactory();
        Point point = null;
        if (geometry instanceof Point) {
            point = this.transformPoint((Point)geometry, geometryFactory);
        } else if (geometry instanceof MultiPoint) {
            MultiPoint multiPoint = (MultiPoint)geometry;
            Point[] pointArray = new Point[multiPoint.getNumGeometries()];
            for (int i = 0; i < pointArray.length; ++i) {
                pointArray[i] = this.transformPoint((Point)multiPoint.getGeometryN(i), geometryFactory);
            }
            point = geometryFactory.createMultiPoint(pointArray);
        } else if (geometry instanceof LineString) {
            point = this.transformLineString((LineString)geometry, geometryFactory);
        } else if (geometry instanceof MultiLineString) {
            MultiLineString multiLineString = (MultiLineString)geometry;
            LineString[] lineStringArray = new LineString[multiLineString.getNumGeometries()];
            for (int i = 0; i < lineStringArray.length; ++i) {
                lineStringArray[i] = this.transformLineString((LineString)multiLineString.getGeometryN(i), geometryFactory);
            }
            point = geometryFactory.createMultiLineString(lineStringArray);
        } else if (geometry instanceof Polygon) {
            point = this.transformPolygon((Polygon)geometry, geometryFactory);
        } else if (geometry instanceof MultiPolygon) {
            MultiPolygon multiPolygon = (MultiPolygon)geometry;
            Polygon[] polygonArray = new Polygon[multiPolygon.getNumGeometries()];
            for (int i = 0; i < polygonArray.length; ++i) {
                polygonArray[i] = this.transformPolygon((Polygon)multiPolygon.getGeometryN(i), geometryFactory);
            }
            point = geometryFactory.createMultiPolygon(polygonArray);
        } else if (geometry instanceof GeometryCollection) {
            GeometryCollection geometryCollection = (GeometryCollection)geometry;
            Geometry[] geometryArray = new Geometry[geometryCollection.getNumGeometries()];
            for (int i = 0; i < geometryArray.length; ++i) {
                geometryArray[i] = this.transform(geometryCollection.getGeometryN(i));
            }
            point = geometryFactory.createGeometryCollection(geometryArray);
        } else {
            throw new IllegalArgumentException("Unsupported geometry type " + geometry.getClass());
        }
        point.setUserData(geometry.getUserData());
        if ((geometry.getUserData() == null || geometry.getUserData() instanceof CoordinateReferenceSystem) && this.crs != null) {
            point.setUserData((Object)this.crs);
        }
        return point;
    }

    public LineString transformLineString(LineString lineString, GeometryFactory geometryFactory) throws TransformException {
        CoordinateSequence coordinateSequence = this.projectCoordinateSequence(lineString.getCoordinateSequence());
        Object object = null;
        object = lineString instanceof LinearRing ? geometryFactory.createLinearRing(coordinateSequence) : geometryFactory.createLineString(coordinateSequence);
        object.setUserData(lineString.getUserData());
        return object;
    }

    public Point transformPoint(Point point, GeometryFactory geometryFactory) throws TransformException {
        CoordinateSequence coordinateSequence = this.projectCoordinateSequence(point.getCoordinateSequence());
        Point point2 = geometryFactory.createPoint(coordinateSequence);
        point2.setUserData(point.getUserData());
        return point2;
    }

    public CoordinateSequence projectCoordinateSequence(CoordinateSequence coordinateSequence) throws TransformException {
        return this.csTransformer.transform(coordinateSequence, this.transform);
    }

    public Polygon transformPolygon(Polygon polygon, GeometryFactory geometryFactory) throws TransformException {
        LinearRing linearRing = (LinearRing)this.transformLineString(polygon.getExteriorRing(), geometryFactory);
        LinearRing[] linearRingArray = new LinearRing[polygon.getNumInteriorRing()];
        for (int i = 0; i < linearRingArray.length; ++i) {
            linearRingArray[i] = (LinearRing)this.transformLineString(polygon.getInteriorRingN(i), geometryFactory);
        }
        Polygon polygon2 = geometryFactory.createPolygon(linearRing, linearRingArray);
        polygon2.setUserData(polygon.getUserData());
        return polygon2;
    }
}

