/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.type;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geotools.resources.Classes;
import org.geotools.util.Utilities;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyType;
import org.opengis.filter.Filter;
import org.opengis.util.InternationalString;

public abstract class PropertyTypeImpl
implements PropertyType {
    private static final List<Filter> NO_RESTRICTIONS = Collections.emptyList();
    protected final Name name;
    protected final Class<?> binding;
    protected final boolean isAbstract;
    protected final PropertyType superType;
    protected final List<Filter> restrictions;
    protected final InternationalString description;
    protected final Map<Object, Object> userData;

    public PropertyTypeImpl(Name name, Class<?> clazz, boolean bl, List<Filter> list, PropertyType propertyType, InternationalString internationalString) {
        if (name == null) {
            throw new NullPointerException("Name is required for PropertyType");
        }
        if (clazz == null) {
            if (propertyType != null && propertyType.getBinding() != null) {
                throw new NullPointerException("Binding to a Java class, did you mean to bind to " + propertyType.getBinding());
            }
            throw new NullPointerException("Binding to a Java class is required");
        }
        this.name = name;
        this.binding = clazz;
        this.isAbstract = bl;
        this.restrictions = list == null ? NO_RESTRICTIONS : Collections.unmodifiableList(list);
        this.superType = propertyType;
        this.description = internationalString;
        this.userData = new HashMap<Object, Object>();
    }

    @Override
    public Name getName() {
        return this.name;
    }

    @Override
    public Class<?> getBinding() {
        return this.binding;
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public List<Filter> getRestrictions() {
        return this.restrictions;
    }

    @Override
    public PropertyType getSuper() {
        return this.superType;
    }

    @Override
    public InternationalString getDescription() {
        return this.description;
    }

    @Override
    public int hashCode() {
        return ((Object)this.getName()).hashCode() ^ this.getBinding().hashCode() ^ (this.getDescription() != null ? this.getDescription().hashCode() : 17);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PropertyType)) {
            return false;
        }
        PropertyType propertyType = (PropertyType)object;
        if (!Utilities.equals(this.name, propertyType.getName())) {
            return false;
        }
        if (!Utilities.equals(this.binding, propertyType.getBinding())) {
            return false;
        }
        if (this.isAbstract != propertyType.isAbstract()) {
            return false;
        }
        if (!this.equals(this.getRestrictions(), propertyType.getRestrictions())) {
            return false;
        }
        if (!Utilities.equals(this.superType, propertyType.getSuper())) {
            return false;
        }
        return Utilities.equals(this.description, propertyType.getDescription());
    }

    private boolean equals(List list, List list2) {
        if (list == list2 || list != null && ((Object)list).equals(list2)) {
            return true;
        }
        if (list == null && list2.size() == 0) {
            return true;
        }
        return list2 == null && list.size() == 0;
    }

    @Override
    public Map<Object, Object> getUserData() {
        return this.userData;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(Classes.getShortClassName(this));
        stringBuffer.append(" ");
        stringBuffer.append(this.getName());
        if (this.isAbstract()) {
            stringBuffer.append(" abstract");
        }
        if (this.superType != null) {
            stringBuffer.append(" extends ");
            stringBuffer.append(this.superType.getName().getLocalPart());
        }
        if (this.binding != null) {
            stringBuffer.append("<");
            stringBuffer.append(Classes.getShortName(this.binding));
            stringBuffer.append(">");
        }
        if (this.description != null) {
            stringBuffer.append("\n\tdescription=");
            stringBuffer.append(this.description);
        }
        if (this.restrictions != null && !this.restrictions.isEmpty()) {
            stringBuffer.append("\nrestrictions=");
            boolean bl = true;
            for (Filter filter : this.restrictions) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(" AND ");
                }
                stringBuffer.append(filter);
            }
        }
        return stringBuffer.toString();
    }
}

