/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile;

import com.vividsolutions.jts.geom.Geometry;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Logger;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFactorySpi;
import org.geotools.data.directory.DirectoryDataStore;
import org.geotools.data.directory.FileStoreFactory;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShpFiles;
import org.geotools.data.shapefile.indexed.IndexType;
import org.geotools.data.shapefile.indexed.IndexedShapefileDataStore;
import org.geotools.util.KVP;
import org.geotools.util.logging.Logging;

public class ShapefileDataStoreFactory
implements FileDataStoreFactorySpi {
    public static final Logger LOGGER = Logging.getLogger("org.geotools.data.shapefile");
    public static final DataAccessFactory.Param URLP = new DataAccessFactory.Param("url", URL.class, "url to a .shp file", true, null, new KVP("ext", "shp"));
    public static final DataAccessFactory.Param NAMESPACEP = new DataAccessFactory.Param("namespace", URI.class, "uri to a the namespace", false, null, new KVP("level", "advanced"));
    public static final DataAccessFactory.Param MEMORY_MAPPED = new DataAccessFactory.Param("memory mapped buffer", Boolean.class, "enable/disable the use of memory-mapped io", false, (Object)false, new KVP("level", "advanced"));
    public static final DataAccessFactory.Param CACHE_MEMORY_MAPS = new DataAccessFactory.Param("cache and reuse memory maps", Boolean.class, "only memory map a file one, then cache and reuse the map", false, (Object)true, new KVP("level", "advanced"));
    public static final DataAccessFactory.Param FILE_TYPE = new DataAccessFactory.Param("filetype", String.class, "Discriminator for directory stores", false, (Object)"shapefile", new KVP("level", "advanced"));
    public static final DataAccessFactory.Param CREATE_SPATIAL_INDEX = new DataAccessFactory.Param("create spatial index", Boolean.class, "enable/disable the automatic creation of spatial index", false, (Object)true, new KVP("level", "advanced"));
    public static final DataAccessFactory.Param DBFCHARSET = new DataAccessFactory.Param("charset", (Class)Charset.class, "character used to decode strings from the DBF file", false, (Object)Charset.forName("ISO-8859-1"), (Map)new KVP("level", "advanced")){

        @Override
        public Object parse(String string) throws IOException {
            return Charset.forName(string);
        }

        @Override
        public String text(Object object) {
            return ((Charset)object).name();
        }
    };
    public static final DataAccessFactory.Param DBFTIMEZONE = new DataAccessFactory.Param("timezone", (Class)TimeZone.class, "time zone used to read dates from the DBF file", false, (Object)TimeZone.getDefault(), (Map)new KVP("level", "advanced")){

        @Override
        public Object parse(String string) throws IOException {
            return TimeZone.getTimeZone(string);
        }

        @Override
        public String text(Object object) {
            return ((TimeZone)object).getID();
        }
    };

    public boolean canProcess(Map map) {
        boolean bl = false;
        if (map.containsKey(ShapefileDataStoreFactory.URLP.key)) {
            try {
                URL uRL = (URL)URLP.lookUp(map);
                bl = this.canProcess(uRL);
                if (!bl) {
                    Object object = FILE_TYPE.lookUp(map);
                    File file = DataUtilities.urlToFile(uRL);
                    bl = file.isDirectory() && (object == null || "shapefile".equals(object));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bl;
    }

    public DataStore createDataStore(Map map) throws IOException {
        return this.createNewDataStore(map);
    }

    public DataStore createNewDataStore(Map map) throws IOException {
        File file;
        URL uRL = (URL)URLP.lookUp(map);
        Boolean bl = (Boolean)MEMORY_MAPPED.lookUp(map);
        Boolean bl2 = (Boolean)CACHE_MEMORY_MAPS.lookUp(map);
        URI uRI = (URI)NAMESPACEP.lookUp(map);
        Charset charset = (Charset)DBFCHARSET.lookUp(map);
        TimeZone timeZone = (TimeZone)DBFTIMEZONE.lookUp(map);
        Boolean bl3 = (Boolean)CREATE_SPATIAL_INDEX.lookUp(map);
        if (bl3 == null) {
            bl3 = Boolean.TRUE;
        }
        if (charset == null) {
            charset = Charset.forName("ISO-8859-1");
        }
        if (timeZone == null) {
            timeZone = TimeZone.getDefault();
        }
        if (bl == null) {
            bl = Boolean.FALSE;
        }
        if (bl2 == null) {
            bl2 = Boolean.FALSE;
        }
        if ((file = DataUtilities.urlToFile(uRL)) != null && file.isDirectory()) {
            return new DirectoryDataStore(DataUtilities.urlToFile(uRL), new ShpFileStoreFactory(this, map));
        }
        ShpFiles shpFiles = new ShpFiles(uRL);
        boolean bl4 = shpFiles.isLocal();
        boolean bl5 = bl4 && bl != false;
        boolean bl6 = bl3 != false && bl4;
        ShapefileDataStore shapefileDataStore = bl6 ? new IndexedShapefileDataStore(uRL, uRI, bl5, bl2, true, IndexType.QIX, charset) : new ShapefileDataStore(uRL, uRI, bl5, bl2, charset);
        shapefileDataStore.setDbftimeZone(timeZone);
        return shapefileDataStore;
    }

    public String getDisplayName() {
        return "Shapefile";
    }

    @Override
    public String getDescription() {
        return "ESRI(tm) Shapefiles (*.shp)";
    }

    @Override
    public boolean isAvailable() {
        try {
            ShapefileDataStore.class.getName();
            IndexedShapefileDataStore.class.getName();
            Geometry.class.getName();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    @Override
    public boolean canProcess(URL uRL) {
        return uRL.getFile().toUpperCase().endsWith("SHP");
    }

    @Override
    public FileDataStore createDataStore(URL uRL) throws IOException {
        HashMap<String, URL> hashMap = new HashMap<String, URL>();
        hashMap.put(ShapefileDataStoreFactory.URLP.key, uRL);
        boolean bl = uRL.getProtocol().equalsIgnoreCase("file");
        File file = DataUtilities.urlToFile(uRL);
        if (file != null && file.isDirectory()) {
            return null;
        }
        if (bl && !file.exists()) {
            return (FileDataStore)this.createNewDataStore(hashMap);
        }
        return (FileDataStore)this.createDataStore(hashMap);
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }

    public static class ShpFileStoreFactory
    implements FileStoreFactory {
        ShapefileDataStoreFactory shpFactory;
        Map originalParams;

        public ShpFileStoreFactory(ShapefileDataStoreFactory shapefileDataStoreFactory, Map map) {
            this.shpFactory = shapefileDataStoreFactory;
            this.originalParams = map;
        }

        @Override
        public DataStore getDataStore(File file) throws IOException {
            URL uRL = DataUtilities.fileToURL(file);
            if (this.shpFactory.canProcess(uRL)) {
                HashMap<String, URL> hashMap = new HashMap<String, URL>(this.originalParams);
                hashMap.put(ShapefileDataStoreFactory.URLP.key, uRL);
                return this.shpFactory.createDataStore(hashMap);
            }
            return null;
        }
    }
}

